/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.intpuf;

import de.bsvrz.sys.funclib.bitctrl.dua.intpuf.IIntervallDatum;
import de.bsvrz.sys.funclib.bitctrl.dua.intpuf.IIntervallPufferElement;
import de.bsvrz.sys.funclib.bitctrl.dua.intpuf.IntervallPufferElementAdapter;
import de.bsvrz.sys.funclib.bitctrl.dua.intpuf.IntervallPufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class IntervallPuffer<T extends IIntervallDatum<T>> {
    protected final SortedMap<Long, Intervall<T>> puffer = new TreeMap<Long, Intervall<T>>();

    public final void loescheAllesUnterhalbVon(long startIntervall) throws IntervallPufferException {
        ArrayList<Long> loeschListe = new ArrayList<Long>();
        for (long start : this.puffer.keySet()) {
            Intervall intervall = (Intervall)this.puffer.get(start);
            if (intervall.getIntervallStart() < startIntervall && intervall.getIntervallEnde() <= startIntervall) {
                loeschListe.add(start);
                continue;
            }
            if (intervall.getIntervallStart() >= startIntervall || intervall.getIntervallEnde() <= startIntervall) continue;
            long restImIntervall = intervall.getIntervallEnde() - startIntervall;
            long restIntervallTeile = restImIntervall / intervall.getGranularitaet();
            if (restIntervallTeile > 0L) {
                intervall.setStart(intervall.getIntervallEnde() - restIntervallTeile * intervall.getGranularitaet());
                continue;
            }
            loeschListe.add(start);
        }
        for (Long zuLoeschenderSchluessel : loeschListe) {
            this.puffer.remove(zuLoeschenderSchluessel);
        }
    }

    public final void add(IIntervallPufferElement<T> element) throws IntervallPufferException {
        Intervall<T> letztesIntervall = null;
        if (!this.puffer.keySet().isEmpty()) {
            letztesIntervall = (Intervall)this.puffer.get(this.puffer.lastKey());
        }
        if (letztesIntervall == null) {
            letztesIntervall = new Intervall<T>(element);
            this.puffer.put(element.getIntervallStart(), letztesIntervall);
        } else if (letztesIntervall.isKompatibel(element)) {
            letztesIntervall.add(element);
        } else {
            Intervall<T> neuesIntervall = new Intervall<T>(element);
            this.puffer.put(element.getIntervallStart(), neuesIntervall);
        }
    }

    public final long getSpeicherAuslastung() {
        return this.puffer.keySet().size();
    }

    public String toString() {
        long start = Long.MAX_VALUE;
        long ende = Long.MIN_VALUE;
        for (Intervall<T> intervall : this.puffer.values()) {
            if (intervall.getIntervallStart() < start) {
                start = intervall.getIntervallStart();
            }
            if (intervall.getIntervallEnde() <= ende) continue;
            ende = intervall.getIntervallEnde();
        }
        return this.puffer.isEmpty() ? "leer" : "[" + start + ", " + ende + "] Mem: " + this.puffer.size();
    }

    public List<Intervall<T>> getPuffer() {
        return new ArrayList<Intervall<T>>(this.puffer.values());
    }

    protected class Intervall<T1 extends IIntervallDatum<T1>>
    extends IntervallPufferElementAdapter<T1> {
        private final long granularitaet;

        protected Intervall(IIntervallPufferElement<T1> element) throws IntervallPufferException {
            super(element.getIntervallStart(), element.getIntervallEnde());
            this.setInhalt(element.getInhalt());
            this.granularitaet = this.getIntervallEnde() - this.getIntervallStart();
            if (this.granularitaet < 0L) {
                throw new IntervallPufferException("Intervallende (" + this.getIntervallEnde() + ") liegt vor Intervallanfang (" + this.getIntervallStart() + "):\n" + this.getInhalt());
            }
        }

        protected final void setStart(long start) throws IntervallPufferException {
            if (this.getIntervallEnde() - start < 0L) {
                throw new IntervallPufferException("Intervallende (" + this.getIntervallEnde() + ") liegt vor Intervallanfang (" + this.getIntervallStart() + "):\n" + this.getInhalt());
            }
            this.setIntervallStart(start);
        }

        protected final boolean isKompatibel(IIntervallPufferElement<T1> element) {
            return element.getInhalt().istGleich(this.getInhalt()) && element.getIntervallEnde() - element.getIntervallStart() == this.granularitaet && this.getIntervallEnde() == element.getIntervallStart();
        }

        protected final void add(IIntervallPufferElement<T1> element) throws IntervallPufferException {
            if (!this.isKompatibel(element)) {
                throw new IntervallPufferException("Versuch inkompatibles Datum\n" + element + "einzufuegen in Puffer:\n" + this);
            }
            this.setIntervallEnde(this.getIntervallEnde() + this.granularitaet);
        }

        protected final long getGranularitaet() {
            return this.granularitaet;
        }

        @Override
        public String toString() {
            return "[" + this.getIntervallStart() + ", " + this.getIntervallEnde() + "] Granularitaet: " + this.granularitaet + "\n" + this.getInhalt();
        }
    }
}

