/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.lve;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.FahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessQuerschnittVirtuell;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessStelle;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessStellenGruppe;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DuaVerkehrsNetz {
    private final Map<SystemObject, FahrStreifen> fahrStreifen = new LinkedHashMap<SystemObject, FahrStreifen>();
    private final Map<SystemObject, MessQuerschnitt> messQuerSchnitte = new LinkedHashMap<SystemObject, MessQuerschnitt>();
    private final Map<SystemObject, MessQuerschnittVirtuell> messQuerSchnitteVirtuell = new LinkedHashMap<SystemObject, MessQuerschnittVirtuell>();
    private final Map<SystemObject, MessStelle> messStellen = new LinkedHashMap<SystemObject, MessStelle>();
    private final Map<SystemObject, MessStellenGruppe> messStellenGruppen = new LinkedHashMap<SystemObject, MessStellenGruppe>();

    public DuaVerkehrsNetz(ClientDavInterface dav, ConfigurationArea[] kbs) throws DUAInitialisierungsException {
        this.fahrStreifen.putAll(FahrStreifen.einlesen(this, dav, kbs));
        this.messQuerSchnitte.putAll(MessQuerschnitt.einlesen(this, dav, kbs));
        this.messQuerSchnitteVirtuell.putAll(MessQuerschnittVirtuell.einlesen(this, dav, kbs));
        this.messStellen.putAll(MessStelle.einlesen(this, dav, kbs));
        this.ermittleErsatzUndNachbarFS();
        this.messStellenGruppen.putAll(MessStellenGruppe.einlesen(this, dav, kbs));
    }

    private void ermittleErsatzUndNachbarFS() {
        for (MessQuerschnitt mq : this.getAlleMessQuerSchnitte()) {
            for (FahrStreifen fs : mq.getFahrStreifen()) {
                MessQuerschnittAllgemein ersatzQuerschnitt;
                FahrStreifen nachbar;
                if (fs.getNachbarFahrStreifen() == null && (nachbar = mq.getNachbarVon(fs)) != null) {
                    fs.setNachbarFahrStreifen(nachbar.getSystemObject());
                }
                if (fs.getNachbarFahrStreifen() == null) {
                    Debug.getLogger().warning("F\u00fcr Fahrstreifen " + fs + " kann kein Nachbarfahrstreifen ermittelt werden");
                }
                if (fs.getErsatzFahrStreifen() == null && (ersatzQuerschnitt = mq.getErsatzMessquerSchnitt()) != null) {
                    ArrayList<FahrStreifen> ersatzFahstreifen = new ArrayList<FahrStreifen>();
                    for (FahrStreifen fsAnErsatzQuerschnitt : ersatzQuerschnitt.getFahrStreifen()) {
                        if (!fsAnErsatzQuerschnitt.getLage().equals(fs.getLage())) continue;
                        ersatzFahstreifen.add(fsAnErsatzQuerschnitt);
                    }
                    if (ersatzFahstreifen.size() > 0) {
                        if (ersatzFahstreifen.size() > 1) {
                            Debug.getLogger().warning("F\u00fcr Fahrstreifen " + fs + " sind mehrere Ersatzfahrstreifen ermittelbar. W\u00e4hle: " + ersatzFahstreifen.get(0));
                        }
                        fs.setErsatzFahrStreifen(((FahrStreifen)ersatzFahstreifen.get(0)).getSystemObject());
                    }
                }
                if (fs.getErsatzFahrStreifen() != null) continue;
                Debug.getLogger().warning("F\u00fcr Fahrstreifen " + fs + " kann kein Ersatzfahrstreifen ermittelt werden");
            }
        }
    }

    public Collection<FahrStreifen> getAlleFahrStreifen() {
        return Collections.unmodifiableCollection(this.fahrStreifen.values());
    }

    public FahrStreifen getFahrStreifen(SystemObject systemObject) {
        return this.fahrStreifen.get(systemObject);
    }

    public Collection<MessQuerschnitt> getAlleMessQuerSchnitte() {
        return Collections.unmodifiableCollection(this.messQuerSchnitte.values());
    }

    public MessQuerschnitt getMessQuerSchnitt(SystemObject systemObject) {
        return this.messQuerSchnitte.get(systemObject);
    }

    public Collection<MessQuerschnittVirtuell> getAlleMessQuerSchnitteVirtuell() {
        return Collections.unmodifiableCollection(this.messQuerSchnitteVirtuell.values());
    }

    public MessQuerschnittVirtuell getMessQuerSchnittVirtuell(SystemObject systemObject) {
        return this.messQuerSchnitteVirtuell.get(systemObject);
    }

    public MessQuerschnittAllgemein getMessQuerSchnittAllgemein(SystemObject mqaObjekt) {
        MessQuerschnitt result = this.getMessQuerSchnitt(mqaObjekt);
        if (result != null) {
            return result;
        }
        return this.getMessQuerSchnittVirtuell(mqaObjekt);
    }

    public Collection<MessStelle> getAlleMessStellen() {
        return Collections.unmodifiableCollection(this.messStellen.values());
    }

    public MessStelle getMessStelle(SystemObject systemObject) {
        return this.messStellen.get(systemObject);
    }

    public Collection<MessStellenGruppe> getAlleMessStellenGruppen() {
        return Collections.unmodifiableCollection(this.messStellenGruppen.values());
    }

    public MessStellenGruppe getMessStellenGruppe(SystemObject systemObject) {
        return this.messStellenGruppen.get(systemObject);
    }
}

