/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.lve;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.DuaVerkehrsNetz;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.NetzElement;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.typen.FahrStreifenLage;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.LinkedHashMap;
import java.util.Map;

public class FahrStreifen
extends NetzElement {
    private FahrStreifenLage lage;
    private SystemObject ersatzFahrstreifenObj;
    private SystemObject nachbarFahrstreifenObj;

    protected FahrStreifen(DuaVerkehrsNetz netz, SystemObject fsObjekt) throws DUAInitialisierungsException {
        super(netz, fsObjekt);
        if (fsObjekt == null) {
            throw new NullPointerException("\u00dcbergebenes Fahrstreifenobjekt ist <<null>>");
        }
        AttributeGroup atgEigenschaften = fsObjekt.getDataModel().getAttributeGroup("atg.fahrStreifen");
        Data eigenschaften = fsObjekt.getConfigurationData(atgEigenschaften);
        if (eigenschaften == null) {
            Debug.getLogger().error("\"atg.fahrStreifen\" von Fahrstreifenobjekt " + fsObjekt + " konnten nicht ausgelesen werden");
        } else {
            this.lage = FahrStreifenLage.getZustand(eigenschaften.getUnscaledValue("Lage").intValue());
            if (eigenschaften.getReferenceValue("ErsatzFahrStreifen") != null) {
                this.ersatzFahrstreifenObj = eigenschaften.getReferenceValue("ErsatzFahrStreifen").getSystemObject();
            }
        }
    }

    static final Map<SystemObject, FahrStreifen> einlesen(DuaVerkehrsNetz netz, ClientDavInterface dav1, ConfigurationArea[] kbs) throws DUAInitialisierungsException {
        if (dav1 == null) {
            throw new NullPointerException("Datenverteiler-Verbindung ist <<null>>");
        }
        LinkedHashMap<SystemObject, FahrStreifen> result = new LinkedHashMap<SystemObject, FahrStreifen>();
        for (SystemObject fsObjekt : dav1.getDataModel().getType("typ.fahrStreifen").getElements()) {
            if (!fsObjekt.isValid() || !DUAUtensilien.isObjektInKBsEnthalten(fsObjekt, kbs)) continue;
            result.put(fsObjekt, new FahrStreifen(netz, fsObjekt));
        }
        return result;
    }

    public FahrStreifenLage getLage() {
        return this.lage;
    }

    public final FahrStreifen getErsatzFahrStreifen() {
        return this.getNetz().getFahrStreifen(this.ersatzFahrstreifenObj);
    }

    protected final void setErsatzFahrStreifen(SystemObject ersatzFahrstreifenObj1) {
        this.ersatzFahrstreifenObj = ersatzFahrstreifenObj1;
    }

    public final FahrStreifen getNachbarFahrStreifen() {
        return this.getNetz().getFahrStreifen(this.nachbarFahrstreifenObj);
    }

    protected final void setNachbarFahrStreifen(SystemObject nachbarFahrstreifenObj1) {
        this.nachbarFahrstreifenObj = nachbarFahrstreifenObj1;
    }
}

