/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.lve;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.NonMutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.DuaVerkehrsNetz;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.FahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.typen.FahrStreifenLage;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MessQuerschnitt
extends MessQuerschnittAllgemein {
    private final List<FahrStreifen> fahrStreifen = new ArrayList<FahrStreifen>();

    private MessQuerschnitt(DuaVerkehrsNetz netz, SystemObject mqObjekt) {
        super(netz, mqObjekt);
        if (mqObjekt == null) {
            throw new NullPointerException("\u00dcbergebenes Messquerschnitt-Systemobjekt ist <<null>>");
        }
        ConfigurationObject konfigObjekt = (ConfigurationObject)mqObjekt;
        NonMutableSet fsMenge = konfigObjekt.getNonMutableSet("FahrStreifen");
        for (SystemObject fsObj : fsMenge.getElements()) {
            if (!fsObj.isValid()) continue;
            FahrStreifen fs = netz.getFahrStreifen(fsObj);
            if (fs != null) {
                this.fahrStreifen.add(fs);
                continue;
            }
            Debug.getLogger().warning("Fahrstreifen " + fsObj + " an " + mqObjekt + " konnte nicht identifiziert werden");
        }
    }

    static Map<SystemObject, MessQuerschnitt> einlesen(DuaVerkehrsNetz netz, ClientDavInterface dav1, ConfigurationArea[] kbs) {
        if (dav1 == null) {
            throw new NullPointerException("Datenverteiler-Verbindung ist <<null>>");
        }
        LinkedHashMap<SystemObject, MessQuerschnitt> result = new LinkedHashMap<SystemObject, MessQuerschnitt>();
        for (SystemObject mqObjekt : dav1.getDataModel().getType("typ.messQuerschnitt").getElements()) {
            if (!mqObjekt.isValid() || !DUAUtensilien.isObjektInKBsEnthalten(mqObjekt, kbs)) continue;
            result.put(mqObjekt, new MessQuerschnitt(netz, mqObjekt));
        }
        return result;
    }

    public final List<FahrStreifen> getFahrStreifen() {
        return this.fahrStreifen;
    }

    protected final FahrStreifen getNachbarVon(FahrStreifen fs) {
        FahrStreifen nachbar = null;
        if (fs.getLage() != null) {
            FahrStreifenLage lageLinksVonHier = fs.getLage().getLinksVonHier();
            FahrStreifenLage lageRechtsVonHier = fs.getLage().getRechtsVonHier();
            FahrStreifen linkerNachbar = null;
            FahrStreifen rechterNachbar = null;
            for (FahrStreifen fs1 : this.fahrStreifen) {
                if (lageLinksVonHier != null && fs1.getLage().equals(lageLinksVonHier)) {
                    linkerNachbar = fs1;
                    break;
                }
                if (lageRechtsVonHier == null || !fs1.getLage().equals(lageRechtsVonHier)) continue;
                rechterNachbar = fs1;
            }
            nachbar = linkerNachbar != null ? linkerNachbar : rechterNachbar;
        }
        return nachbar;
    }
}

