/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.lve;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.DuaVerkehrsNetz;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.FahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.NetzElement;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.typen.MessQuerschnittTyp;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;

public abstract class MessQuerschnittAllgemein
extends NetzElement {
    private SystemObject ersatzQuerschnittObj;
    private MessQuerschnittTyp typ;

    protected MessQuerschnittAllgemein(DuaVerkehrsNetz netz, SystemObject mqaObjekt) {
        super(netz, mqaObjekt);
        if (mqaObjekt == null) {
            throw new NullPointerException("\u00dcbergebenes allgemeines Messquerschnittobjekt ist <<null>>");
        }
        AttributeGroup atgEigenschaften = mqaObjekt.getDataModel().getAttributeGroup("atg.messQuerschnittAllgemein");
        Data eigenschaften = mqaObjekt.getConfigurationData(atgEigenschaften);
        if (eigenschaften == null) {
            Debug.getLogger().warning("\"atg.messQuerschnittAllgemein\" von allgemeinem Messquerschnittobjekt " + mqaObjekt + " konnten nicht ausgelesen werden");
        } else {
            this.typ = MessQuerschnittTyp.getZustand(eigenschaften.getUnscaledValue("Typ").intValue());
            if (eigenschaften.getReferenceValue("ErsatzMessQuerschnitt") != null) {
                this.ersatzQuerschnittObj = eigenschaften.getReferenceValue("ErsatzMessQuerschnitt").getSystemObject();
            }
        }
    }

    public abstract Collection<FahrStreifen> getFahrStreifen();

    public final MessQuerschnittAllgemein getErsatzMessquerSchnitt() {
        return this.getNetz().getMessQuerSchnittAllgemein(this.ersatzQuerschnittObj);
    }

    public final MessQuerschnittTyp getMQTyp() {
        return this.typ;
    }
}

