/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.lve;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.DuaVerkehrsNetz;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.FahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.daten.AtgMessQuerschnittVirtuell;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.daten.AtgMessQuerschnittVirtuellVLage;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.daten.KeineDatenException;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.daten.MessQuerschnittAnteile;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.typen.MessQuerschnittVirtuellLage;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class MessQuerschnittVirtuell
extends MessQuerschnittAllgemein {
    private BerechnungsVorschrift berechnungsVorschrift = BerechnungsVorschrift.UNBEKANNT;
    private MessQuerschnitt mqVorObj;
    private MessQuerschnitt mqNachObj;
    private MessQuerschnitt mqMitteObj;
    private MessQuerschnitt mqAusfahrtObj;
    private MessQuerschnitt mqEinfahrtObj;
    private MessQuerschnittVirtuellLage mqVirtLage;
    private MessQuerschnittAnteile messQuerschnittAnteile;
    private final DuaVerkehrsNetz netz;

    private MessQuerschnittVirtuell(DuaVerkehrsNetz netz, SystemObject mqvObjekt) throws DUAInitialisierungsException {
        super(netz, mqvObjekt);
        this.netz = netz;
        if (mqvObjekt == null) {
            throw new NullPointerException("Uebergebenes MessQuerschnittVirtuell-Systemobjekt ist <<null>>");
        }
        AttributeGroup atgEigenschaftenSTD = mqvObjekt.getDataModel().getAttributeGroup("atg.messQuerschnittVirtuellStandard");
        Data eigenschaftenSTD = mqvObjekt.getConfigurationData(atgEigenschaftenSTD);
        if (eigenschaftenSTD == null) {
            Debug.getLogger().fine("\"atg.messQuerschnittVirtuellStandard\" von MessQuerschnittVirtuell-Objekt " + mqvObjekt + " konnten nicht ausgelesen werden");
        } else {
            this.mqVirtLage = MessQuerschnittVirtuellLage.getZustand(eigenschaftenSTD.getUnscaledValue("Lage").intValue());
            if (eigenschaftenSTD.getReferenceValue("MessQuerschnittVor") != null) {
                this.mqVorObj = netz.getMessQuerSchnitt(eigenschaftenSTD.getReferenceValue("MessQuerschnittVor").getSystemObject());
            }
            if (eigenschaftenSTD.getReferenceValue("MessQuerschnittNach") != null) {
                this.mqNachObj = netz.getMessQuerSchnitt(eigenschaftenSTD.getReferenceValue("MessQuerschnittNach").getSystemObject());
            }
            if (eigenschaftenSTD.getReferenceValue("MessQuerschnittMitte") != null) {
                this.mqMitteObj = netz.getMessQuerSchnitt(eigenschaftenSTD.getReferenceValue("MessQuerschnittMitte").getSystemObject());
            }
            if (eigenschaftenSTD.getReferenceValue("MessQuerschnittAusfahrt") != null) {
                this.mqAusfahrtObj = netz.getMessQuerSchnitt(eigenschaftenSTD.getReferenceValue("MessQuerschnittAusfahrt").getSystemObject());
            }
            if (eigenschaftenSTD.getReferenceValue("MessQuerschnittEinfahrt") != null) {
                this.mqEinfahrtObj = netz.getMessQuerSchnitt(eigenschaftenSTD.getReferenceValue("MessQuerschnittEinfahrt").getSystemObject());
            }
            this.berechnungsVorschrift = BerechnungsVorschrift.AUF_BASIS_VON_ATG_MQ_VIRTUELL_STANDARD;
        }
        try {
            this.messQuerschnittAnteile = new AtgMessQuerschnittVirtuell(mqvObjekt);
            this.berechnungsVorschrift = BerechnungsVorschrift.AUF_BASIS_VON_ATG_MQ_VIRTUELL_V_LAGE;
        }
        catch (KeineDatenException e) {
            Debug.getLogger().fine("\"atg.messQuerschnittVirtuellVLage\" von MessQuerschnittVirtuell-Objekt " + mqvObjekt + " konnten nicht ausgelesen werden:\n" + e.getMessage());
        }
        try {
            this.messQuerschnittAnteile = new AtgMessQuerschnittVirtuellVLage(mqvObjekt);
            this.berechnungsVorschrift = BerechnungsVorschrift.AUF_BASIS_VON_ATG_MQ_VIRTUELL_V_LAGE;
        }
        catch (KeineDatenException e) {
            Debug.getLogger().fine("\"atg.messQuerschnittVirtuellVLage\" von MessQuerschnittVirtuell-Objekt " + mqvObjekt + " konnten nicht ausgelesen werden:\n" + e.getMessage());
        }
    }

    static Map<SystemObject, MessQuerschnittVirtuell> einlesen(DuaVerkehrsNetz netz, ClientDavInterface dav1, ConfigurationArea[] kbs) throws DUAInitialisierungsException {
        if (dav1 == null) {
            throw new NullPointerException("Datenverteiler-Verbindung ist <<null>>");
        }
        LinkedHashMap<SystemObject, MessQuerschnittVirtuell> result = new LinkedHashMap<SystemObject, MessQuerschnittVirtuell>();
        for (SystemObject mqvObjekt : dav1.getDataModel().getType("typ.messQuerschnittVirtuell").getElements()) {
            if (!mqvObjekt.isValid() || !DUAUtensilien.isObjektInKBsEnthalten(mqvObjekt, kbs)) continue;
            result.put(mqvObjekt, new MessQuerschnittVirtuell(netz, mqvObjekt));
        }
        return result;
    }

    @Override
    public Collection<FahrStreifen> getFahrStreifen() {
        HashSet<FahrStreifen> fahrStreifenMenge = new HashSet<FahrStreifen>();
        if (this.getBerechnungsVorschrift() == null || this.getBerechnungsVorschrift() == BerechnungsVorschrift.AUF_BASIS_VON_ATG_MQ_VIRTUELL_V_LAGE) {
            for (AtgMessQuerschnittVirtuellVLage.AtlMessQuerSchnittBestandTeil mqBestandteil : this.getMessQuerschnittAnteile().getMessQuerSchnittBestandTeile()) {
                MessQuerschnittAllgemein mqa = this.netz.getMessQuerSchnittAllgemein(mqBestandteil.getMQReferenz());
                if (mqa == null) continue;
                fahrStreifenMenge.addAll(mqa.getFahrStreifen());
            }
        } else {
            if (this.getMQVor() != null) {
                fahrStreifenMenge.addAll(this.getMQVor().getFahrStreifen());
            }
            if (this.getMQNach() != null) {
                fahrStreifenMenge.addAll(this.getMQNach().getFahrStreifen());
            }
            if (this.getMQEinfahrt() != null) {
                fahrStreifenMenge.addAll(this.getMQEinfahrt().getFahrStreifen());
            }
            if (this.getMQAusfahrt() != null) {
                fahrStreifenMenge.addAll(this.getMQAusfahrt().getFahrStreifen());
            }
            if (this.getMQMitte() != null) {
                fahrStreifenMenge.addAll(this.getMQMitte().getFahrStreifen());
            }
        }
        return fahrStreifenMenge;
    }

    public final MessQuerschnitt getMQVor() {
        return this.mqVorObj;
    }

    public final MessQuerschnitt getMQNach() {
        return this.mqNachObj;
    }

    public final MessQuerschnitt getMQMitte() {
        return this.mqMitteObj;
    }

    public final MessQuerschnitt getMQAusfahrt() {
        return this.mqAusfahrtObj;
    }

    public final MessQuerschnitt getMQEinfahrt() {
        return this.mqEinfahrtObj;
    }

    public final MessQuerschnittVirtuellLage getMQVirtuellLage() {
        return this.mqVirtLage;
    }

    public final BerechnungsVorschrift getBerechnungsVorschrift() {
        return this.berechnungsVorschrift;
    }

    @Deprecated
    public final AtgMessQuerschnittVirtuellVLage getAtgMessQuerschnittVirtuellVLage() {
        if (this.messQuerschnittAnteile instanceof AtgMessQuerschnittVirtuellVLage) {
            return (AtgMessQuerschnittVirtuellVLage)this.messQuerschnittAnteile;
        }
        return null;
    }

    public final MessQuerschnittAnteile getMessQuerschnittAnteile() {
        return this.messQuerschnittAnteile;
    }

    public static enum BerechnungsVorschrift {
        UNBEKANNT,
        AUF_BASIS_VON_ATG_MQ_VIRTUELL_V_LAGE,
        AUF_BASIS_VON_ATG_MQ_VIRTUELL_STANDARD;

    }
}

