/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.lve;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.NonMutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.DuaVerkehrsNetz;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.NetzElement;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class MessStelle
extends NetzElement {
    private final Collection<MessQuerschnittAllgemein> zufahrten = new HashSet<MessQuerschnittAllgemein>();
    private final Collection<MessQuerschnittAllgemein> abfahrten = new HashSet<MessQuerschnittAllgemein>();
    private SystemObject pruefling;
    private final DuaVerkehrsNetz netz;

    protected MessStelle(DuaVerkehrsNetz netz, SystemObject msObjekt) throws DUAInitialisierungsException {
        super(netz, msObjekt);
        this.netz = netz;
        ConfigurationObject konfigObjekt = (ConfigurationObject)msObjekt;
        NonMutableSet mqMengeAbfahrten = konfigObjekt.getNonMutableSet("Abfahrten");
        for (Object mqObj : mqMengeAbfahrten.getElements()) {
            if (!mqObj.isValid()) continue;
            MessQuerschnittAllgemein mqa = netz.getMessQuerSchnittAllgemein((SystemObject)mqObj);
            if (mqa != null) {
                this.abfahrten.add(mqa);
                continue;
            }
            Debug.getLogger().warning("Abfahrt " + (SystemObject)mqObj + " an " + msObjekt + " konnte nicht identifiziert werden");
        }
        NonMutableSet mqMengeZufahrten = konfigObjekt.getNonMutableSet("Zufahrten");
        for (SystemObject mqObj : mqMengeZufahrten.getElements()) {
            if (!mqObj.isValid()) continue;
            MessQuerschnittAllgemein mqa = netz.getMessQuerSchnittAllgemein(mqObj);
            if (mqa != null) {
                this.zufahrten.add(mqa);
                continue;
            }
            Debug.getLogger().warning("Zufahrt " + mqObj + " an " + msObjekt + " konnte nicht identifiziert werden");
        }
        AttributeGroup atgEigenschaften = msObjekt.getDataModel().getAttributeGroup("atg.messStelle");
        Data eigenschaften = msObjekt.getConfigurationData(atgEigenschaften);
        if (eigenschaften == null) {
            Debug.getLogger().warning("\"atg.messStelle\" von Messstelle " + msObjekt + " konnten nicht ausgelesen werden");
        } else if (eigenschaften.getReferenceValue("Pr\u00fcfling") != null) {
            this.pruefling = eigenschaften.getReferenceValue("Pr\u00fcfling").getSystemObject();
        }
    }

    static Map<SystemObject, MessStelle> einlesen(DuaVerkehrsNetz netz, ClientDavInterface dav1, ConfigurationArea[] kbs) throws DUAInitialisierungsException {
        if (dav1 == null) {
            throw new NullPointerException("Datenverteiler-Verbindung ist <<null>>");
        }
        LinkedHashMap<SystemObject, MessStelle> result = new LinkedHashMap<SystemObject, MessStelle>();
        for (SystemObject msObj : dav1.getDataModel().getType("typ.messStelle").getElements()) {
            if (!msObj.isValid() || !DUAUtensilien.isObjektInKBsEnthalten(msObj, kbs)) continue;
            result.put(msObj, new MessStelle(netz, msObj));
        }
        return result;
    }

    public final Collection<MessQuerschnittAllgemein> getZufahrten() {
        return this.zufahrten;
    }

    public final Collection<MessQuerschnittAllgemein> getAbfahrten() {
        return this.abfahrten;
    }

    public final MessQuerschnittAllgemein getPruefling() {
        return this.netz.getMessQuerSchnittAllgemein(this.pruefling);
    }
}

