/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.lve;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.DuaVerkehrsNetz;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.MessStelle;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.NetzElement;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.LinkedHashMap;
import java.util.Map;

public class MessStellenGruppe
extends NetzElement {
    private MessStelle[] messStellen = new MessStelle[0];
    private boolean systematischeDetektorfehler;

    protected MessStellenGruppe(DuaVerkehrsNetz netz, SystemObject msgObjekt) throws DUAInitialisierungsException {
        super(netz, msgObjekt);
        AttributeGroup atgEigenschaften = msgObjekt.getDataModel().getAttributeGroup("atg.messStellenGruppe");
        Data eigenschaften = msgObjekt.getConfigurationData(atgEigenschaften);
        if (eigenschaften == null) {
            Debug.getLogger().warning("\"atg.messStellenGruppe\" von Messstellengruppe " + msgObjekt + " konnten nicht ausgelesen werden");
        } else {
            if (eigenschaften.getReferenceArray("MessStellen") != null) {
                int i;
                MessStelle[] dummy = new MessStelle[eigenschaften.getReferenceArray("MessStellen").getLength()];
                int c = 0;
                for (i = 0; i < eigenschaften.getReferenceArray("MessStellen").getLength(); ++i) {
                    if (eigenschaften.getReferenceArray("MessStellen").getReferenceValue(i) == null || eigenschaften.getReferenceArray("MessStellen").getReferenceValue(i).getSystemObject() == null) continue;
                    dummy[c++] = netz.getMessStelle(eigenschaften.getReferenceArray("MessStellen").getReferenceValue(i).getSystemObject());
                }
                if (c > 0) {
                    this.messStellen = new MessStelle[c];
                    for (i = 0; i < c; ++i) {
                        this.messStellen[i] = dummy[i];
                    }
                }
            }
            this.systematischeDetektorfehler = eigenschaften.getUnscaledValue("SystematischeDetektorfehler").intValue() == 1;
        }
    }

    static Map<SystemObject, MessStellenGruppe> einlesen(DuaVerkehrsNetz netz, ClientDavInterface dav1, ConfigurationArea[] kbs) throws DUAInitialisierungsException {
        if (dav1 == null) {
            throw new NullPointerException("Datenverteiler-Verbindung ist <<null>>");
        }
        LinkedHashMap<SystemObject, MessStellenGruppe> result = new LinkedHashMap<SystemObject, MessStellenGruppe>();
        for (SystemObject msObj : dav1.getDataModel().getType("typ.messStellenGruppe").getElements()) {
            if (!msObj.isValid() || !DUAUtensilien.isObjektInKBsEnthalten(msObj, kbs)) continue;
            result.put(msObj, new MessStellenGruppe(netz, msObj));
        }
        return result;
    }

    public final MessStelle[] getMessStellen() {
        return this.messStellen;
    }

    public final boolean isSystematischeDetektorfehler() {
        return this.systematischeDetektorfehler;
    }
}

