/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.lve.daten;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.impl.InvalidArgumentException;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.daten.KeineDatenException;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.daten.MessQuerschnittAnteile;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;

public class AtgMessQuerschnittVirtuellVLage
implements MessQuerschnittAnteile {
    private final AtlMessQuerSchnittBestandTeil[] messQuerSchnittBestandTeile;
    private SystemObject messQuerschnittGeschwindigkeit;

    @Deprecated
    public AtgMessQuerschnittVirtuellVLage(ClientDavInterface dav, SystemObject objekt) throws KeineDatenException {
        this(objekt);
    }

    public AtgMessQuerschnittVirtuellVLage(SystemObject objekt) throws KeineDatenException {
        Data atgData = objekt.getConfigurationData(objekt.getDataModel().getAttributeGroup("atg.messQuerschnittVirtuellVLage"));
        if (atgData == null) {
            throw new KeineDatenException("Die Attributgruppe \"atg.messQuerschnittVirtuellVLage\" von VMQ " + objekt + " ist nicht definiert.");
        }
        if (atgData.getReferenceValue("MessQuerschnittGeschwindigkeit") != null) {
            this.messQuerschnittGeschwindigkeit = atgData.getReferenceValue("MessQuerschnittGeschwindigkeit").getSystemObject();
        }
        ArrayList<AtlMessQuerSchnittBestandTeil> dummy = new ArrayList<AtlMessQuerSchnittBestandTeil>();
        for (int i = 0; i < atgData.getArray("MessQuerSchnittBestandTeile").getLength(); ++i) {
            try {
                AtlMessQuerSchnittBestandTeil anteil = new AtlMessQuerSchnittBestandTeil(atgData.getArray("MessQuerSchnittBestandTeile").getItem(i));
                dummy.add(anteil);
                continue;
            }
            catch (InvalidArgumentException e) {
                e.printStackTrace();
                Debug.getLogger().warning("Problem beim Auslesen von Konfigurationsdaten von VMQ " + objekt + ":\n" + e.getMessage());
            }
        }
        this.messQuerSchnittBestandTeile = dummy.toArray(new AtlMessQuerSchnittBestandTeil[0]);
    }

    @Override
    public AtlMessQuerSchnittBestandTeil[] getMessQuerSchnittBestandTeile() {
        return this.messQuerSchnittBestandTeile;
    }

    @Override
    public SystemObject getMessQuerschnittGeschwindigkeit() {
        return this.messQuerschnittGeschwindigkeit;
    }

    public static final class AtlMessQuerSchnittBestandTeil {
        private final SystemObject mqReferenz;
        private double anteil = Double.NaN;

        AtlMessQuerSchnittBestandTeil(Data datum) throws InvalidArgumentException {
            if (datum.getReferenceValue("MessQuerschnittReferenz") == null) {
                throw new InvalidArgumentException("Attribut \"MessQuerschnittReferenz\" konnte nicht ausgelesen werden");
            }
            if (datum.getReferenceValue("MessQuerschnittReferenz").getSystemObject() == null) {
                throw new InvalidArgumentException("Attribut \"MessQuerschnittReferenz\" ist <<null>>");
            }
            this.mqReferenz = datum.getReferenceValue("MessQuerschnittReferenz").getSystemObject();
            long anteilDummy = datum.getUnscaledValue("Anteil").longValue();
            this.anteil = anteilDummy == 100L ? 1.0 : (anteilDummy == -100L ? -1.0 : datum.getScaledValue("Anteil").doubleValue());
            if (this.anteil == 0.0) {
                throw new InvalidArgumentException("Attribut \"Anteil\" ist 0. Dieser Datensatz kann vernachlaessigt werden.");
            }
        }

        public SystemObject getMQReferenz() {
            return this.mqReferenz;
        }

        public double getAnteil() {
            return this.anteil;
        }
    }
}

