/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.test;

import de.bsvrz.sys.funclib.debug.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class CSVImporter {
    private final File csvDatei;
    private BufferedReader leser;
    private int zeilenNummer = -1;

    public CSVImporter(File csvDatei) throws Exception {
        this.csvDatei = csvDatei;
        this.leser = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvDatei), Charset.defaultCharset()));
    }

    public CSVImporter(String csvDateiName) throws Exception {
        Object name = csvDateiName;
        if (!((String)name).toLowerCase().endsWith(".csv")) {
            name = (String)name + ".csv";
        }
        this.csvDatei = new File((String)name);
        this.leser = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.csvDatei), Charset.defaultCharset()));
    }

    public final String[] getNaechsteZeile() {
        String[] result = null;
        try {
            String red = this.leser.readLine();
            ++this.zeilenNummer;
            if (red != null) {
                result = red.split(";");
            }
        }
        catch (IOException ex) {
            Debug.getLogger().error("Fehler beim Lesen aus " + this, (Throwable)ex);
        }
        return result;
    }

    public final int getZeilenNummer() {
        return this.zeilenNummer;
    }

    public String toString() {
        String s = this.csvDatei.toString();
        try {
            s = this.csvDatei.getCanonicalPath();
        }
        catch (IOException ex) {
            Debug.getLogger().error("", (Throwable)ex);
        }
        return s;
    }

    public final void reset() {
        try {
            this.leser.close();
            this.leser = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.csvDatei), Charset.defaultCharset()));
        }
        catch (IOException ex) {
            Debug.getLogger().error("", (Throwable)ex);
        }
    }

    public void finalize() throws Throwable {
        if (this.leser != null) {
            this.leser.close();
        }
        super.finalize();
    }
}

