/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.test;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Random;

public final class DAVTest {
    private static final Debug LOGGER = Debug.getLogger();
    private static ClientDavInterface verbindung;
    public static final Random RANDOM;

    private DAVTest() {
    }

    public static ClientDavInterface getDav(String[] kommandoZeile) throws Exception {
        if (verbindung == null) {
            verbindung = DAVTest.newDav(kommandoZeile);
        }
        return verbindung;
    }

    public static ClientDavInterface newDav(String[] kommandoZeile) throws Exception {
        StandardApplicationRunner.run((StandardApplication)new StandardApplication(){

            public void initialize(ClientDavInterface connection) throws Exception {
                verbindung = connection;
            }

            public void parseArguments(ArgumentList argumentList) throws Exception {
                argumentList.fetchUnusedArguments();
            }
        }, (String[])kommandoZeile);
        return verbindung;
    }

    public static void warteBis(long zeitStempel) {
        while (System.currentTimeMillis() <= zeitStempel) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ex) {
                LOGGER.finest(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }

    public static int[] getZufaelligeZahlen(int anzahl) {
        int belegt = 0;
        int[] zahlen = new int[anzahl];
        for (int i = 0; i < anzahl; ++i) {
            zahlen[i] = -1;
        }
        while (belegt < anzahl) {
            int index = RANDOM.nextInt(anzahl);
            if (zahlen[index] != -1) continue;
            zahlen[index] = belegt++;
        }
        return zahlen;
    }

    static {
        RANDOM = new Random(System.currentTimeMillis());
    }
}

