/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.testausfall;

import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.KontrollProzess;
import de.bsvrz.sys.funclib.bitctrl.dua.adapter.AbstraktBearbeitungsKnotenAdapter;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.schnittstellen.IDatenFlussSteuerung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.typen.ModulTyp;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IKontrollProzessListener;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.bitctrl.dua.testausfall.ObjektResultat;
import de.bsvrz.sys.funclib.debug.Debug;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class AbstraktAusfallUeberwachung
extends AbstraktBearbeitungsKnotenAdapter
implements IKontrollProzessListener<Long> {
    private static final Debug LOGGER = Debug.getLogger();
    private final Map<SystemObject, Long> objektWertErfassungVerzug = Collections.synchronizedMap(new TreeMap());
    private final SortedMap<Long, Collection<ObjektResultat>> kontrollZeitpunkte = Collections.synchronizedSortedMap(new TreeMap());
    private KontrollProzess<Long> kontrollProzess;
    private final Map<SystemObject, Long> letzteEmpfangeneDatenZeitProObj = new HashMap<SystemObject, Long>();

    protected abstract long getTVon(ResultData var1);

    protected abstract ResultData getAusfallDatumVon(ResultData var1);

    @Override
    public void initialisiere(IVerwaltung dieVerwaltung) throws DUAInitialisierungsException {
        super.initialisiere(dieVerwaltung);
        this.kontrollProzess = new KontrollProzess();
        this.kontrollProzess.addListener(this);
        for (SystemObject objekt : this.getVerwaltung().getSystemObjekte()) {
            this.letzteEmpfangeneDatenZeitProObj.put(objekt, -1L);
        }
    }

    protected void setObjectWertErfassungVerzug(SystemObject object, Long zeitVerzug) {
        this.objektWertErfassungVerzug.put(object, zeitVerzug);
    }

    @Override
    public synchronized void aktualisiereDaten(ResultData[] resultate) {
        if (resultate != null) {
            ArrayList<ResultData> weiterzuleitendeResultate = new ArrayList<ResultData>();
            for (ResultData resultat : resultate) {
                if (resultat == null) continue;
                if (this.getMaxZeitVerzug(resultat.getObject()) < 0L) {
                    weiterzuleitendeResultate.add(resultat);
                    continue;
                }
                if (this.letzteEmpfangeneDatenZeitProObj.get(resultat.getObject()) < resultat.getDataTime()) {
                    weiterzuleitendeResultate.add(resultat);
                }
                this.letzteEmpfangeneDatenZeitProObj.put(resultat.getObject(), resultat.getDataTime());
                if (resultat.getData() == null) continue;
                this.bereinigeKontrollZeitpunkte(resultat);
                long kontrollZeitpunkt = this.getKontrollZeitpunktVon(resultat);
                if (kontrollZeitpunkt > 0L) {
                    TreeSet<ObjektResultat> kontrollObjekte = (TreeSet<ObjektResultat>)this.kontrollZeitpunkte.get(kontrollZeitpunkt);
                    ObjektResultat neuesKontrollObjekt = new ObjektResultat(resultat);
                    if (kontrollObjekte != null) {
                        kontrollObjekte.add(neuesKontrollObjekt);
                    } else {
                        kontrollObjekte = new TreeSet<ObjektResultat>();
                        kontrollObjekte.add(neuesKontrollObjekt);
                        this.kontrollZeitpunkte.put(kontrollZeitpunkt, kontrollObjekte);
                    }
                }
                long fruehesterKontrollZeitpunkt = -1L;
                if (!this.kontrollZeitpunkte.isEmpty()) {
                    fruehesterKontrollZeitpunkt = this.kontrollZeitpunkte.firstKey();
                    if (fruehesterKontrollZeitpunkt > 0L) {
                        this.kontrollProzess.setNaechstenAufrufZeitpunkt(fruehesterKontrollZeitpunkt, fruehesterKontrollZeitpunkt);
                        continue;
                    }
                    LOGGER.warning("Der momentan aktuellste Kontrollzeitpunkt ist <= 0");
                    continue;
                }
                LOGGER.warning("Die Menge der Kontrollzeitpunkte ist leer");
            }
            if (this.getKnoten() != null && !weiterzuleitendeResultate.isEmpty()) {
                this.getKnoten().aktualisiereDaten(weiterzuleitendeResultate.toArray(new ResultData[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getMaxZeitVerzug(SystemObject obj) {
        long maxZeitVerzug = -1L;
        if (obj != null) {
            Map<SystemObject, Long> map = this.objektWertErfassungVerzug;
            synchronized (map) {
                Long dummy = this.objektWertErfassungVerzug.get(obj);
                if (dummy != null && dummy > 0L) {
                    maxZeitVerzug = dummy;
                }
            }
        }
        return maxZeitVerzug;
    }

    private synchronized void bereinigeKontrollZeitpunkte(ResultData resultat) {
        Long letzterErwarteterZeitpunkt = resultat.getDataTime() + this.getTVon(resultat) + this.getMaxZeitVerzug(resultat.getObject());
        Collection kontrollObjekte = (Collection)this.kontrollZeitpunkte.get(letzterErwarteterZeitpunkt);
        ObjektResultat datum = new ObjektResultat(resultat);
        if (kontrollObjekte != null) {
            if (kontrollObjekte.remove(datum)) {
                if (kontrollObjekte.isEmpty()) {
                    this.kontrollZeitpunkte.remove(letzterErwarteterZeitpunkt);
                }
            } else {
                kontrollObjekte = null;
            }
        }
        if (kontrollObjekte == null) {
            Long gefundenInKontrollZeitpunkt = -1L;
            for (Long kontrollZeitpunkt : this.kontrollZeitpunkte.keySet()) {
                kontrollObjekte = (Collection)this.kontrollZeitpunkte.get(kontrollZeitpunkt);
                if (!kontrollObjekte.remove(datum)) continue;
                gefundenInKontrollZeitpunkt = kontrollZeitpunkt;
                break;
            }
            if (kontrollObjekte != null && gefundenInKontrollZeitpunkt >= 0L) {
                if (kontrollObjekte.isEmpty()) {
                    this.kontrollZeitpunkte.remove(gefundenInKontrollZeitpunkt);
                }
            } else {
                LOGGER.info("Datum " + datum + " konnte nicht aus Kontrollwarteschlange gel\u00f6scht werden");
            }
        }
    }

    @Override
    public synchronized void trigger(Long kontrollZeitpunkt) {
        ArrayList<ResultData> zuSendendeAusfallDatenMenge = new ArrayList<ResultData>();
        Collection ausfallDaten = (Collection)this.kontrollZeitpunkte.get(kontrollZeitpunkt);
        if (ausfallDaten != null) {
            for (ObjektResultat ausfallDatum : ausfallDaten) {
                zuSendendeAusfallDatenMenge.add(this.getAusfallDatumVon(ausfallDatum.getDatum()));
            }
        } else {
            LOGGER.warning("Der Kontrollzeitpunkt " + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS").format(new Date(kontrollZeitpunkt)) + " wurde inzwischen entfernt");
        }
        if (!zuSendendeAusfallDatenMenge.isEmpty()) {
            this.aktualisiereDaten(zuSendendeAusfallDatenMenge.toArray(new ResultData[0]));
        }
    }

    private long getKontrollZeitpunktVon(ResultData empfangenesResultat) {
        long kontrollZeitpunkt = -1L;
        long maxZeitVerzug = this.getMaxZeitVerzug(empfangenesResultat.getObject());
        if (maxZeitVerzug >= 0L) {
            kontrollZeitpunkt = empfangenesResultat.getDataTime() + this.getTVon(empfangenesResultat) + maxZeitVerzug;
        } else {
            LOGGER.fine("Es wurden noch keine (sinnvollen) Parameter empfangen: " + empfangenesResultat.getObject());
        }
        return kontrollZeitpunkt;
    }

    @Override
    public ModulTyp getModulTyp() {
        return null;
    }

    @Override
    public void aktualisierePublikation(IDatenFlussSteuerung dfs) {
    }
}

