/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.ufd;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.sys.funclib.bitctrl.dua.GanzZahl;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.UmfeldDatenSensorUnbekannteDatenartException;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.UmfeldDatenSensorWert;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.typen.UmfeldDatenArt;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Date;

public class UmfeldDatenSensorDatum {
    private final ResultData originalDatum;
    private UmfeldDatenArt datenArt;
    private Data datum;
    private boolean copy;
    private final UmfeldDatenSensorWert wert;

    public UmfeldDatenSensorDatum(ResultData resultat) {
        if (resultat == null) {
            throw new NullPointerException("Datensatz ist <<null>>");
        }
        if (resultat.getData() == null) {
            throw new NullPointerException("Datensatz enthaelt keine Daten");
        }
        this.originalDatum = resultat;
        try {
            this.datenArt = UmfeldDatenArt.getUmfeldDatenArtVon(resultat.getObject());
        }
        catch (UmfeldDatenSensorUnbekannteDatenartException ex) {
            Debug.getLogger().finest(ex.getLocalizedMessage(), (Throwable)ex);
        }
        if (this.datenArt == null) {
            throw new NullPointerException("Datenart konnte nicht identifiziert werden:\n" + resultat);
        }
        this.datum = resultat.getData();
        this.wert = new UmfeldDatenSensorWert(this.datenArt);
        this.wert.setWert(this.datum.getItem(this.datenArt.getName()).getUnscaledValue("Wert").longValue());
        this.wert.setVeraendert(false);
    }

    public final ResultData getVeraendertesOriginalDatum() {
        ResultData resultat = this.originalDatum;
        if (this.copy) {
            resultat = new ResultData(this.originalDatum.getObject(), this.originalDatum.getDataDescription(), this.originalDatum.getDataTime(), this.datum);
        }
        return resultat;
    }

    public final boolean isVeraendert() {
        return this.copy;
    }

    private void erstelleKopie() {
        if (!this.copy) {
            this.copy = true;
            this.datum = this.datum.createModifiableCopy();
        }
    }

    public final ResultData getOriginalDatum() {
        return this.originalDatum;
    }

    public final GanzZahl getGueteIndex() {
        GanzZahl gueteIndex = GanzZahl.getGueteIndex();
        gueteIndex.setWert(this.datum.getItem(this.datenArt.getName()).getItem("G\u00fcte").getUnscaledValue("Index").longValue());
        return gueteIndex;
    }

    public final int getGueteVerfahren() {
        int gueteVerfahren = this.datum.getItem(this.datenArt.getName()).getItem("G\u00fcte").getUnscaledValue("Verfahren").intValue();
        return gueteVerfahren;
    }

    public final long getT() {
        return this.datum.getTimeValue("T").getMillis();
    }

    public final void setT(long t) {
        this.erstelleKopie();
        this.datum.getTimeValue("T").setMillis(t);
    }

    public final int getStatusErfassungNichtErfasst() {
        return this.datum.getItem(this.datenArt.getName()).getItem("Status").getItem("Erfassung").getUnscaledValue("NichtErfasst").intValue();
    }

    public final void setStatusErfassungNichtErfasst(int statusErfassungNichtErfasst) {
        this.erstelleKopie();
        this.datum.getItem(this.datenArt.getName()).getItem("Status").getItem("Erfassung").getUnscaledValue("NichtErfasst").set(statusErfassungNichtErfasst);
    }

    public final void setGueteIndex(long guete) {
        this.erstelleKopie();
        this.datum.getItem(this.datenArt.getName()).getItem("G\u00fcte").getUnscaledValue("Index").set(guete);
    }

    public final void setGueteVerfahren(int gueteVerfahren) {
        this.erstelleKopie();
        this.datum.getItem(this.datenArt.getName()).getItem("G\u00fcte").getUnscaledValue("Verfahren").set(gueteVerfahren);
    }

    public final int getStatusMessWertErsetzungImplausibel() {
        return this.datum.getItem(this.datenArt.getName()).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Implausibel").intValue();
    }

    public final int getStatusMessWertErsetzungInterpoliert() {
        return this.datum.getItem(this.datenArt.getName()).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Interpoliert").intValue();
    }

    public final void setStatusMessWertErsetzungImplausibel(int statusMessWertErsetzungImplausibel) {
        this.erstelleKopie();
        this.datum.getItem(this.datenArt.getName()).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Implausibel").set(statusMessWertErsetzungImplausibel);
    }

    public final void setStatusMessWertErsetzungInterpoliert(int statusMessWertErsetzungInterpoliert) {
        this.erstelleKopie();
        this.datum.getItem(this.datenArt.getName()).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Interpoliert").set(statusMessWertErsetzungInterpoliert);
    }

    public final UmfeldDatenSensorWert getWert() {
        return this.wert;
    }

    public final long getDatenZeit() {
        return this.originalDatum.getDataTime();
    }

    public final Data getDatum() {
        if (this.wert.isVeraendert()) {
            this.erstelleKopie();
            this.datum.getItem(this.datenArt.getName()).getUnscaledValue("Wert").set(this.wert.getWert());
        }
        return this.datum;
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.datenArt.toString());
        s.append("\nKopiert: ").append(this.copy ? "ja" : "nein");
        s.append("\nDatum: ").append(this.datum);
        s.append("\nDatenzeit: ").append(new Date(this.getDatenZeit()));
        s.append("\nWert: ").append(this.wert);
        return s.toString();
    }
}

