/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.ufd;

import de.bsvrz.sys.funclib.bitctrl.dua.ufd.typen.UmfeldDatenArt;

public class UmfeldDatenSensorWert
implements Comparable<UmfeldDatenSensorWert> {
    private static boolean fehlerhafteWertePublizieren;
    private long wert;
    private boolean fehlerhaftBzwNichtErmittelbar;
    private boolean fehlerhaft;
    private boolean nichtErmittelbar;
    private final UmfeldDatenArt datenArt;
    private boolean veraendert;

    public UmfeldDatenSensorWert(UmfeldDatenArt datenArt) {
        this.datenArt = datenArt;
    }

    private double getWertSkalierung() {
        return this.datenArt.getSkalierung();
    }

    private long getWertStatusOffset() {
        return this.datenArt.getStatusOffset();
    }

    public final boolean isVeraendert() {
        return this.veraendert;
    }

    public final void setVeraendert(boolean veraendert) {
        this.veraendert = veraendert;
    }

    public final long getWert() {
        return this.wert;
    }

    public final void setWert(long wert) {
        this.veraendert = true;
        this.wert = wert;
        this.fehlerhaft = this.wert == this.getWertStatusOffset() + -2L;
        this.fehlerhaftBzwNichtErmittelbar = this.wert == this.getWertStatusOffset() + -3L;
        this.nichtErmittelbar = this.wert == this.getWertStatusOffset() + -1L;
    }

    public final void setSkaliertenWert(double wert1) {
        double skalierung = this.getWertSkalierung();
        this.setWert(Math.round(wert1 / skalierung));
    }

    public final double getSkaliertenWert() {
        return (double)this.getWert() * this.getWertSkalierung();
    }

    public final void setFehlerhaftAn() {
        if (fehlerhafteWertePublizieren) {
            this.fehlerhaft = true;
        } else {
            this.setWert(this.getWertStatusOffset() + -2L);
        }
    }

    public final boolean isFehlerhaft() {
        return this.fehlerhaft;
    }

    public final void setFehlerhaftBzwNichtErmittelbarAn() {
        this.setWert(this.getWertStatusOffset() + -3L);
    }

    public final boolean isFehlerhaftBzwNichtErmittelbar() {
        return this.fehlerhaftBzwNichtErmittelbar;
    }

    public final void setNichtErmittelbarAn() {
        this.setWert(this.getWertStatusOffset() + -1L);
    }

    public final boolean isNichtErmittelbar() {
        return this.nichtErmittelbar;
    }

    public final boolean isOk() {
        return !this.nichtErmittelbar && !this.fehlerhaft && !this.fehlerhaftBzwNichtErmittelbar;
    }

    public String toString() {
        String wertStr = new Long(this.wert).toString();
        if (this.isFehlerhaft()) {
            wertStr = "fehlerhaft";
        } else if (this.isFehlerhaftBzwNichtErmittelbar()) {
            wertStr = "nicht ermittelbar/fehlerhaft";
        } else if (this.isNichtErmittelbar()) {
            wertStr = "nicht ermittelbar";
        }
        return wertStr;
    }

    @Override
    public int compareTo(UmfeldDatenSensorWert that) {
        if (that == null) {
            throw new NullPointerException("Vergleichswert ist <<null>>");
        }
        return new Long(this.getWert()).compareTo(that.getWert());
    }

    public static void setFehlerhafteWertePublizieren(boolean fehlerhafteWertePublizieren) {
        UmfeldDatenSensorWert.fehlerhafteWertePublizieren = fehlerhafteWertePublizieren;
    }
}

