/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.ufd.modell;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.NonMutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.UmfeldDatenSensorUnbekannteDatenartException;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.modell.DUAUmfeldDatenSensor;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.typen.UmfeldDatenArt;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class DUAUmfeldDatenMessStelle {
    private static final Map<SystemObject, DUAUmfeldDatenMessStelle> INSTANZEN = new LinkedHashMap<SystemObject, DUAUmfeldDatenMessStelle>();
    private final SystemObject objekt;
    private static final Map<SystemObject, DUAUmfeldDatenSensor> SENSORENMAP = new LinkedHashMap<SystemObject, DUAUmfeldDatenSensor>();
    private final Map<UmfeldDatenArt, DatenSensorMenge> sensoren = new HashMap<UmfeldDatenArt, DatenSensorMenge>();

    public static void initialisiere(ClientDavInterface dav, SystemObject[] messStellenObjekte) {
        if (messStellenObjekte == null) {
            throw new NullPointerException("Menge der Umfelddaten-Messstellen ist <<null>>");
        }
        INSTANZEN.clear();
        SENSORENMAP.clear();
        for (SystemObject mStObj : messStellenObjekte) {
            INSTANZEN.put(mStObj, new DUAUmfeldDatenMessStelle(dav, mStObj));
        }
    }

    public static Collection<DUAUmfeldDatenMessStelle> getInstanzen() {
        return INSTANZEN.values();
    }

    public static DUAUmfeldDatenMessStelle getInstanz(SystemObject messStellenObjekt) {
        if (INSTANZEN == null) {
            throw new RuntimeException("DUAUmfeldDatenMessStelle wurde noch nicht initialisiert");
        }
        return INSTANZEN.get(messStellenObjekt);
    }

    private DUAUmfeldDatenMessStelle(ClientDavInterface dav, SystemObject objekt) {
        if (objekt == null) {
            throw new NullPointerException("Systemobjekt der Umfelddaten-Messstelle ist <<null>>");
        }
        this.objekt = objekt;
        HashMap datenArtAufSensoren = new HashMap();
        for (UmfeldDatenArt datenArt : UmfeldDatenArt.getInstanzen()) {
            datenArtAufSensoren.put(datenArt, new HashSet());
        }
        NonMutableSet sensorenMenge = ((ConfigurationObject)objekt).getNonMutableSet("UmfeldDatenSensoren");
        for (SystemObject sensorObj : sensorenMenge.getElements()) {
            DUAUmfeldDatenSensor sensor;
            block6: {
                if (!sensorObj.isValid()) continue;
                try {
                    sensor = SENSORENMAP.get(sensorObj);
                    if (sensor != null) break block6;
                    sensor = new DUAUmfeldDatenSensor(dav, sensorObj);
                    SENSORENMAP.put(sensorObj, sensor);
                }
                catch (UmfeldDatenSensorUnbekannteDatenartException ex) {
                    Debug.getLogger().warning("UmfeldDatenMessStelle '" + this.getObjekt() + "': Umfelddatensensor wird nicht verarbeitet: " + ex.getMessage());
                    continue;
                }
            }
            Set sensorenMitDatenArt = (Set)datenArtAufSensoren.get((Object)sensor.getDatenArt());
            sensorenMitDatenArt.add(sensor);
        }
        for (UmfeldDatenArt datenArt : UmfeldDatenArt.getInstanzen()) {
            this.sensoren.put(datenArt, new DatenSensorMenge((Set)datenArtAufSensoren.get((Object)datenArt)));
        }
    }

    public Collection<DUAUmfeldDatenSensor> getSensoren() {
        HashSet<DUAUmfeldDatenSensor> alleSensoren = new HashSet<DUAUmfeldDatenSensor>();
        for (UmfeldDatenArt datenArt : UmfeldDatenArt.getInstanzen()) {
            alleSensoren.addAll(this.sensoren.get((Object)datenArt).getNebenSensoren());
            if (this.sensoren.get((Object)datenArt).getHauptSensor() == null) continue;
            alleSensoren.add(this.sensoren.get((Object)datenArt).getHauptSensor());
        }
        return alleSensoren;
    }

    public Collection<DUAUmfeldDatenSensor> getSensoren(UmfeldDatenArt datenArt) {
        HashSet<DUAUmfeldDatenSensor> alleSensorenDerDatenArt = new HashSet<DUAUmfeldDatenSensor>();
        alleSensorenDerDatenArt.addAll(this.sensoren.get((Object)datenArt).getNebenSensoren());
        if (this.sensoren.get((Object)datenArt).getHauptSensor() != null) {
            alleSensorenDerDatenArt.add(this.sensoren.get((Object)datenArt).getHauptSensor());
        }
        return alleSensorenDerDatenArt;
    }

    public DUAUmfeldDatenSensor getHauptSensor(UmfeldDatenArt datenArt) {
        return this.sensoren.get((Object)datenArt).getHauptSensor();
    }

    public Collection<DUAUmfeldDatenSensor> getNebenSensoren(UmfeldDatenArt datenArt) {
        return this.sensoren.get((Object)datenArt).getNebenSensoren();
    }

    public boolean equals(Object obj) {
        boolean ergebnis = false;
        if (obj != null && obj instanceof DUAUmfeldDatenMessStelle) {
            DUAUmfeldDatenMessStelle that = (DUAUmfeldDatenMessStelle)obj;
            ergebnis = this.objekt.equals(that.objekt);
        }
        return ergebnis;
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.objekt.toString()).append("\n");
        for (UmfeldDatenArt datenArt : UmfeldDatenArt.getInstanzen()) {
            if (this.sensoren.get((Object)datenArt).isEmpty()) continue;
            s.append("Datenart: ").append((Object)datenArt).append("\nHS: ").append(this.sensoren.get((Object)datenArt).getHauptSensor() == null ? "keiner" : this.sensoren.get((Object)datenArt).getHauptSensor());
            if (!this.sensoren.get((Object)datenArt).getNebenSensoren().isEmpty()) {
                for (DUAUmfeldDatenSensor nebenSensor : this.sensoren.get((Object)datenArt).getNebenSensoren()) {
                    s.append("\nNS: ").append(nebenSensor);
                }
                continue;
            }
            s.append("\nNS: keine");
        }
        return s.toString();
    }

    public SystemObject getObjekt() {
        return this.objekt;
    }

    public int hashCode() {
        return Objects.hash(this.objekt);
    }

    private class DatenSensorMenge {
        private DUAUmfeldDatenSensor hauptSensor;
        private final Collection<DUAUmfeldDatenSensor> nebenSensoren = new HashSet<DUAUmfeldDatenSensor>();

        protected DatenSensorMenge(Set<DUAUmfeldDatenSensor> alleSensoren) {
            for (DUAUmfeldDatenSensor sensor : alleSensoren) {
                if (sensor.isHauptSensor()) {
                    if (this.hauptSensor != null) {
                        throw new RuntimeException("Es darf nur ein Hauptsensor pro Messstelle konfiguriert sein " + DUAUmfeldDatenMessStelle.this.objekt + " Sensor: " + this.hauptSensor + "/" + sensor);
                    }
                    this.hauptSensor = sensor;
                    continue;
                }
                this.nebenSensoren.add(sensor);
            }
        }

        protected final DUAUmfeldDatenSensor getHauptSensor() {
            return this.hauptSensor;
        }

        protected final Collection<DUAUmfeldDatenSensor> getNebenSensoren() {
            return this.nebenSensoren;
        }

        protected final boolean isEmpty() {
            return this.hauptSensor == null && this.nebenSensoren.isEmpty();
        }
    }
}

