/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.ufd.modell;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.UmfeldDatenSensorUnbekannteDatenartException;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.typen.UmfeldDatenArt;
import java.util.Objects;

public class DUAUmfeldDatenSensor
implements ClientReceiverInterface {
    private final SystemObject objekt;
    private long maxZeitMessWertErsetzung = -1L;
    private long maxZeitMessWertFortschreibung = -1L;
    private SystemObject vorgaenger;
    private SystemObject nachfolger;
    private SystemObject ersatzSensor;
    private boolean hauptSensor;
    private final UmfeldDatenArt datenArt;

    DUAUmfeldDatenSensor(ClientDavInterface dav, SystemObject objekt) throws UmfeldDatenSensorUnbekannteDatenartException {
        if (objekt == null) {
            throw new NullPointerException("Als Umfelddatensensor wurde <<null>> uebergeben");
        }
        this.objekt = objekt;
        this.datenArt = UmfeldDatenArt.getUmfeldDatenArtVon(objekt);
        if (this.datenArt == null) {
            throw new UmfeldDatenSensorUnbekannteDatenartException("Datenart von Umfelddatensensor " + this.objekt + " (" + objekt.getType() + ") konnte nicht identifiziert werden");
        }
        ConfigurationObject konfigObjekt = (ConfigurationObject)objekt;
        Data konfigDaten = konfigObjekt.getConfigurationData(dav.getDataModel().getAttributeGroup("atg.umfeldDatenSensor"));
        if (konfigDaten != null) {
            if (konfigDaten.getReferenceValue("Vorg\u00e4nger") != null) {
                this.vorgaenger = konfigDaten.getReferenceValue("Vorg\u00e4nger").getSystemObject();
            }
            if (konfigDaten.getReferenceValue("Nachfolger") != null) {
                this.nachfolger = konfigDaten.getReferenceValue("Nachfolger").getSystemObject();
            }
            if (konfigDaten.getReferenceValue("ErsatzSensor") != null) {
                this.ersatzSensor = konfigDaten.getReferenceValue("ErsatzSensor").getSystemObject();
            }
            this.hauptSensor = konfigDaten.getUnscaledValue("Typ").intValue() == 0;
        }
        DataDescription parameterBeschreibung = new DataDescription(dav.getDataModel().getAttributeGroup("atg.ufdsMessWertErsetzung"), dav.getDataModel().getAspect("asp.parameterSoll"));
        dav.subscribeReceiver((ClientReceiverInterface)this, objekt, parameterBeschreibung, ReceiveOptions.normal(), ReceiverRole.receiver());
    }

    public final UmfeldDatenArt getDatenArt() {
        return this.datenArt;
    }

    public final SystemObject getVorgaenger() {
        return this.vorgaenger;
    }

    public final SystemObject getNachfolger() {
        return this.nachfolger;
    }

    public final SystemObject getErsatzSensor() {
        return this.ersatzSensor;
    }

    public final boolean isHauptSensor() {
        return this.hauptSensor;
    }

    public void update(ResultData[] resultate) {
        if (resultate != null) {
            for (ResultData resultat : resultate) {
                if (resultat == null || resultat.getData() == null) continue;
                Data ufdsMessWertErsetzungData = resultat.getData();
                this.maxZeitMessWertErsetzung = ufdsMessWertErsetzungData.getTimeValue("maxZeitMessWertErsetzung").getMillis();
                this.maxZeitMessWertFortschreibung = ufdsMessWertErsetzungData.getTimeValue("maxZeitMessWertFortschreibung").getMillis();
            }
        }
    }

    public final long getMaxZeitMessWertErsetzung() {
        return this.maxZeitMessWertErsetzung;
    }

    public final long getMaxZeitMessWertFortschreibung() {
        return this.maxZeitMessWertFortschreibung;
    }

    public final SystemObject getObjekt() {
        return this.objekt;
    }

    public boolean equals(Object obj) {
        boolean ergebnis = false;
        if (obj != null && obj instanceof DUAUmfeldDatenSensor) {
            DUAUmfeldDatenSensor that = (DUAUmfeldDatenSensor)obj;
            ergebnis = this.objekt.equals(that.objekt);
        }
        return ergebnis;
    }

    public String toString() {
        return this.objekt.toString();
    }

    public int hashCode() {
        return Objects.hash(this.objekt);
    }
}

