/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.ufd.typen;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.ufd.UmfeldDatenSensorUnbekannteDatenartException;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public enum UmfeldDatenArt {
    fbf("typ.ufdsFahrBahnFeuchte", "FBF", 0L),
    fbg("typ.ufdsFahrBahnGl\u00e4tte", "FBG", 0L),
    fbt("typ.ufdsFahrBahnOberFl\u00e4chenTemperatur", "FBT", -1000L),
    gas("typ.ufdsGl\u00e4tteAlarmStatus", "GAS", 0L),
    gt("typ.ufdsGefrierTemperatur", "GT", -1000L),
    hk("typ.ufdsHelligkeit", "HK", 0L),
    lt("typ.ufdsLuftTemperatur", "LT", -1000L),
    ns("typ.ufdsNiederschlagsArt", "NS", 0L),
    ni("typ.ufdsNiederschlagsIntensit\u00e4t", "NI", 0L),
    nm("typ.ufdsNiederschlagsMenge", "NM", 0L),
    rlf("typ.ufdsRelativeLuftFeuchte", "RLF", 0L),
    sh("typ.ufdsSchneeH\u00f6he", "SH", 0L),
    sw("typ.ufdsSichtWeite", "SW", 0L),
    tpt("typ.ufdsTaupunktTemperatur", "TPT", -1000L),
    tt1("typ.ufdsTemperaturInTiefe1", "TT1", -1000L),
    tt2("typ.ufdsTemperaturInTiefe2", "TT2", -1000L),
    tt3("typ.ufdsTemperaturInTiefe3", "TT3", -1000L),
    wfd("typ.ufdsWasserFilmDicke", "WFD", 0L),
    wr("typ.ufdsWindRichtung", "WR", 0L),
    fbz("typ.ufdsFahrBahnOberFl\u00e4chenZustand", "FBZ", 0L),
    ld("typ.ufdsLuftDruck", "LD", 0L),
    rs("typ.ufdsRestSalz", "RS", 0L),
    tsq("typ.ufdsTaustoffmenge", "TSQ", 0L),
    wgm("typ.ufdsWindGeschwindigkeitMittelWert", "WGM", 0L),
    wgs("typ.ufdsWindGeschwindigkeitSpitzenWert", "WGS", 0L),
    zrge("typ.ufdsZeitReserveEisGl\u00e4tte", "ZRGe", 0L),
    zrgr("typ.ufdsZeitReserveReifGl\u00e4tte", "ZRGr", 0L),
    zg("typ.ufdsZeitreserveGl\u00e4tteVaisala", "ZG", 0L),
    grip("typ.ufdsGriffigkeit", "GRIP", 0L);

    private static Map<SystemObjectType, UmfeldDatenArt> typAufArt;
    private final String typPid;
    private SystemObjectType type;
    private final String name;
    private final String abkuerzung;
    private double skalierung = 1.0;
    private final long statusOffset;

    public static UmfeldDatenArt getUmfeldDatenArtVon(SystemObject objekt) throws UmfeldDatenSensorUnbekannteDatenartException {
        if (typAufArt.isEmpty()) {
            throw new RuntimeException("Umfelddatenarten wurden noch nicht initialisiert");
        }
        UmfeldDatenArt umfeldDatenArt = null;
        if (objekt != null) {
            umfeldDatenArt = typAufArt.get(objekt.getType());
            if (umfeldDatenArt == null) {
                throw new UmfeldDatenSensorUnbekannteDatenartException("Datenart von Umfelddatensensor " + objekt + " (" + objekt.getType() + ") konnte nicht identifiziert werden");
            }
        } else {
            Debug.getLogger().error("Uebergebenes Systemobjekt ist <<null>>");
        }
        return umfeldDatenArt;
    }

    public static Collection<UmfeldDatenArt> getInstanzen() {
        if (typAufArt.isEmpty()) {
            throw new RuntimeException("Umfelddatenarten wurden noch nicht initialisiert");
        }
        return typAufArt.values();
    }

    public static void initialisiere(ClientDavInterface dav) throws DUAInitialisierungsException {
        if (!typAufArt.isEmpty()) {
            Debug.getLogger().error("Umfelddatenarten duerfen nur einmal initialisiert werden");
        }
        DataModel datenModell = dav.getDataModel();
        for (UmfeldDatenArt art : UmfeldDatenArt.values()) {
            SystemObjectType type = datenModell.getType(art.typPid);
            if (null == type) continue;
            art.init(type);
            typAufArt.put(type, art);
        }
    }

    private UmfeldDatenArt(String typPid, String abkuerzung, long statusOffset) {
        this.typPid = typPid;
        this.abkuerzung = abkuerzung;
        this.statusOffset = statusOffset;
        this.name = typPid.substring("typ.ufds".length());
    }

    private void init(SystemObjectType sysObjType) {
        IntegerValueRange range;
        this.type = sysObjType;
        IntegerAttributeType attType = (IntegerAttributeType)sysObjType.getDataModel().getAttributeType("att.ufds" + this.name);
        if (attType != null && (range = attType.getRange()) != null) {
            this.skalierung = range.getConversionFactor();
        }
    }

    public double getSkalierung() {
        return this.skalierung;
    }

    public String getName() {
        return this.name;
    }

    public String getAbkuerzung() {
        return this.abkuerzung;
    }

    public SystemObjectType getTyp() {
        return this.type;
    }

    public String toString() {
        return this.name + " (" + this.abkuerzung + ")";
    }

    public long getStatusOffset() {
        return this.statusOffset;
    }

    static {
        typAufArt = new LinkedHashMap<SystemObjectType, UmfeldDatenArt>();
    }
}

