/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.konfig;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.List;

public class KonfigZugriff {
    private static Debug m_debug = Debug.getLogger();
    private ClientDavInterface m_connection;
    private String m_pidTyp = null;

    public KonfigZugriff(ClientDavInterface connection, String pidTyp) {
        if (connection == null) {
            m_debug.error("Ung\u00fcltige Datenverteilerverbindung \u00fcbergeben.");
            throw new IllegalArgumentException("Ung\u00fcltige Datenverteilerverbindung \u00fcbergeben");
        }
        if (pidTyp == null) {
            m_debug.error("Ung\u00fcltiger ObjektTyp \u00fcbergeben (null).");
            throw new IllegalArgumentException("Ung\u00fcltiger ObjektTyp \u00fcbergeben (null)");
        }
        if (connection.getDataModel().getType(pidTyp) == null) {
            m_debug.error("Ung\u00fcltiger ObjektTyp \u00fcbergeben (kein ObjektTyp).");
            throw new IllegalArgumentException("Ung\u00fcltiger ObjektTyp \u00fcbergeben (kein ObjektTyp)");
        }
        this.m_connection = connection;
        this.m_pidTyp = pidTyp;
    }

    public KonfigZugriff(ClientDavInterface connection) {
        if (connection == null) {
            m_debug.error("Ung\u00fcltige Datenverteilerverbindung \u00fcbergeben.");
            throw new IllegalArgumentException("Ung\u00fcltige Datenverteilerverbindung \u00fcbergeben");
        }
        this.m_connection = connection;
    }

    public List<SystemObject> getObjects() {
        if (this.m_pidTyp == null) {
            m_debug.error("Fehlerhafte Verwendung der Methode getObjects(), da im Konstruktor kein ObjektTyp angegeben wurde.");
            throw new IllegalArgumentException("Fehlerhafte Verwendung der Methode getObjects(), da im Konstruktor kein ObjektTyp angegeben wurde");
        }
        return this.m_connection.getDataModel().getType(this.m_pidTyp).getElements();
    }

    public List<SystemObject> getObjects(String pidTyp) {
        if (this.m_pidTyp != null) {
            m_debug.error("Fehlerhafte Verwendung der Methode getObjects(String), da im Konstruktor schon ein ObjektTyp angegeben wurde.");
            throw new IllegalArgumentException("Fehlerhafte Verwendung der Methode getObjects(String), da im Konstruktor schon ein ObjektTyp angegeben wurde");
        }
        if (pidTyp == null) {
            m_debug.error("Ung\u00fcltiger ObjektTyp \u00fcbergeben (null).");
            throw new IllegalArgumentException("Ung\u00fcltiger ObjektTyp \u00fcbergeben (null)");
        }
        if (this.m_connection.getDataModel().getType(pidTyp) == null) {
            m_debug.error("Ung\u00fcltiger ObjektTyp \u00fcbergeben (kein ObjektTyp).");
            throw new IllegalArgumentException("Ung\u00fcltiger ObjektTyp \u00fcbergeben (kein ObjektTyp)");
        }
        return this.m_connection.getDataModel().getType(pidTyp).getElements();
    }
}

