/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6;

import java.math.BigInteger;
import java.util.Arrays;

public class BigIntegerUtils {
    public static String toHex(BigInteger bigint) {
        if (bigint == null) {
            return null;
        }
        return bigint.toString(16);
    }

    public static BigInteger fromHex(String hex) {
        if (hex == null) {
            return null;
        }
        try {
            return new BigInteger(hex, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static BigInteger bigIntegerFromBytes(byte[] bytes) {
        return new BigInteger(1, bytes);
    }

    public static byte[] bigIntegerToBytes(BigInteger bigInteger) {
        byte[] bytes = bigInteger.toByteArray();
        if (bytes[0] == 0) {
            return Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }

    private BigIntegerUtils() {
    }
}

