/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.dua.pufferlzzsnachfordern;

import de.inovat.dua.pufferlzzsnachfordern.Auftrag;
import de.inovat.dua.pufferlzzsnachfordern.VewDeLve255;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;

public class AuftragsListe {
    private static final AuftragsListe dieEinzigeInstanz = new AuftragsListe();
    private static final NavigableSet<Auftrag> _listeAuftraege = new ConcurrentSkipListSet<Auftrag>(Comparator.comparing(Auftrag::getAusfuehrungsZeitPunkt).thenComparing(Comparator.comparing(a -> a.getVewDeLve255().toString())));

    private AuftragsListe() {
    }

    public static AuftragsListe getInstanz() {
        return dieEinzigeInstanz;
    }

    public void addAuftrag(Auftrag auftrag) {
        if (!this.istAuftragBereitsVorhanden(auftrag)) {
            _listeAuftraege.add(auftrag);
        }
    }

    public String ausgabeGesamtListe() {
        StringBuilder sb = new StringBuilder();
        int m = 0;
        for (Auftrag auftrag : AuftragsListe.getInstanz().holeKopieAuftragsListe()) {
            sb.append(String.format("%06d: %s%n", ++m, auftrag.toString()));
        }
        return sb.toString();
    }

    public String ausgabeTeilListe(VewDeLve255 vewDeLve255) {
        StringBuilder sb = new StringBuilder();
        int m = 0;
        for (Auftrag auftrag : AuftragsListe.getInstanz().holeKopieAuftragsListe()) {
            if (!auftrag.getVewDeLve255()._deLve255.equals((Object)vewDeLve255._deLve255)) continue;
            sb.append(String.format("%05d: %s%n", ++m, auftrag));
        }
        return sb.toString();
    }

    public long ermittleSpaetestenAusfuehrungsZeitPunkt(VewDeLve255 vewDeLve255) {
        long letzterAusfuehrungsZeitPunkt = System.currentTimeMillis();
        for (Auftrag auftrag : _listeAuftraege) {
            if (!auftrag.getVewDeLve255()._deLve255.equals((Object)vewDeLve255._deLve255)) continue;
            letzterAusfuehrungsZeitPunkt = auftrag.getAusfuehrungsZeitPunkt();
        }
        return letzterAusfuehrungsZeitPunkt;
    }

    public boolean hatNochAuftraege() {
        return !_listeAuftraege.isEmpty();
    }

    public List<Auftrag> holeKopieAuftragsListe() {
        ArrayList<Auftrag> listeKopieAuftraege = new ArrayList<Auftrag>();
        listeKopieAuftraege.addAll(_listeAuftraege);
        return listeKopieAuftraege;
    }

    public Auftrag holeNaechstenAuftrag() {
        Auftrag naechsterAuftrag = null;
        if (!_listeAuftraege.isEmpty() && ((Auftrag)_listeAuftraege.first()).getAusfuehrungsZeitPunkt() < System.currentTimeMillis()) {
            naechsterAuftrag = _listeAuftraege.pollFirst();
        }
        return naechsterAuftrag;
    }

    public boolean istAuftragBereitsVorhanden(Auftrag auftrag) {
        for (Auftrag auftragInListe : _listeAuftraege) {
            if (!this.sindAuftraegeIdentisch(auftragInListe, auftrag)) continue;
            return true;
        }
        return false;
    }

    public boolean sindAuftraegeIdentisch(Auftrag a1, Auftrag a2) {
        return a1.getIntervallBeginn() == a2.getIntervallBeginn() && a1.getIntervallEnde() == a2.getIntervallEnde() && a1.getVewDeLve255()._deLve255.equals((Object)a2.getVewDeLve255()._deLve255);
    }
}

