/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.dua.plloglve.plloglve.ausfall;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dua.plloglve.plloglve.ausfall.AusfallDatumKomplett;
import de.bsvrz.dua.plloglve.plloglve.ausfall.AusfallPuffer;
import de.bsvrz.dua.plloglve.plloglve.standard.AtgVerkehrsDatenKurzZeitIntervallPlLogisch;
import de.bsvrz.dua.plloglve.plloglve.standard.PLFahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.dua.intpuf.IntervallPufferException;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageTemplate;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;
import de.bsvrz.sys.funclib.operatingMessage.OperatingMessage;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

public class AusfallFahrStreifen
implements ClientReceiverInterface {
    private static final Debug _debug = Debug.getLogger();
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.GERMAN);
    private IVerwaltung _verwaltung = null;
    private final SystemObject _mq;
    private final AusfallPuffer gleitenderTag = new AusfallPuffer();
    private final SystemObject _objekt;
    private AtgVerkehrsDatenKurzZeitIntervallPlLogisch _parameter;
    private Instant _lastCheckTime;
    private static final MessageTemplate TEMPLATE = new MessageTemplate(MessageGrade.WARNING, MessageType.APPLICATION_DOMAIN, new MessageTemplate.OperatingMessageParam[]{MessageTemplate.fixed((String)"Ausfallh\u00e4ufigkeit innerhalb der letzten 24 Stunden \u00fcberschritten. Im Zeitraum von "), MessageTemplate.variable((String)"from"), MessageTemplate.fixed((String)" bis "), MessageTemplate.variable((String)"to"), MessageTemplate.fixed((String)" (1 Tag) implausible Fahrstreifenwerte am Fahrstreifen "), MessageTemplate.object(), MessageTemplate.fixed((String)"("), MessageTemplate.variable((String)"mq"), MessageTemplate.fixed((String)") w\u00e4hrend "), MessageTemplate.variable((String)"duration"), MessageTemplate.fixed((String)" (> "), MessageTemplate.variable((String)"maxDuration"), MessageTemplate.fixed((String)"). "), MessageTemplate.ids()}).withIdFactory(message -> message.getObject().getPidOrId() + " [DUA-PP-AH]");

    protected AusfallFahrStreifen(IVerwaltung verwaltung, SystemObject obj, SystemObject mq) {
        this._objekt = obj;
        this._verwaltung = verwaltung;
        this._mq = mq;
        ClientDavInterface connection = verwaltung.getVerbindung();
        AttributeGroup parameterAtg = PLFahrStreifen.getParameterAtg(connection);
        if (parameterAtg != null) {
            connection.subscribeReceiver((ClientReceiverInterface)this, obj, new DataDescription(parameterAtg, connection.getDataModel().getAspect("asp.parameterSoll")), ReceiveOptions.normal(), ReceiverRole.receiver());
        } else {
            _debug.warning("Attributgruppe " + AtgVerkehrsDatenKurzZeitIntervallPlLogisch.getPid() + " ist nicht im Datenmodell vorhanden, die Grenzwerte werden nicht gepr\u00fcft");
        }
    }

    protected final synchronized void plausibilisiere(ResultData resultat) {
        AusfallDatumKomplett ausfallDatum = AusfallDatumKomplett.getAusfallDatumVon(resultat);
        if (this._parameter != null) {
            if (ausfallDatum != null) {
                try {
                    this.gleitenderTag.add(ausfallDatum);
                }
                catch (IntervallPufferException e) {
                    _debug.error("Fehler beim Intervallpuffer", (Throwable)e);
                }
                long startIntervall = ausfallDatum.getIntervallEnde() - 86400000L;
                try {
                    this.gleitenderTag.loescheAllesUnterhalbVon(startIntervall);
                }
                catch (IntervallPufferException e) {
                    _debug.error("Fehler beim Intervallpuffer", (Throwable)e);
                }
                Instant now = Instant.ofEpochMilli(ausfallDatum.getIntervallEnde());
                long pruefIntervallAusfall = this._parameter.getPruefIntervallAusfall();
                Instant nextCheckTime = this._lastCheckTime == null ? now : this._lastCheckTime.plusMillis(pruefIntervallAusfall);
                if (!now.isBefore(nextCheckTime)) {
                    this.pruefeAusfall(Instant.ofEpochMilli(startIntervall), now);
                    this._lastCheckTime = nextCheckTime;
                }
            }
        } else {
            Debug.getLogger().warning("Fuer Fahrstreifen " + this + " wurden noch keine Parameter f\u00fcr die Ausfallh\u00e4ufigkeit empfangen");
        }
    }

    private synchronized void pruefeAusfall(Instant fromTime, Instant checkTime) {
        if (this._parameter == null) {
            return;
        }
        long ausfallZeit = this.gleitenderTag.getAusfallZeit();
        long maxAusfallZeitProTag = this._parameter.getMaxAusfallZeitProTag();
        if (maxAusfallZeitProTag > 0L && ausfallZeit > maxAusfallZeitProTag) {
            OperatingMessage operatingMessage = TEMPLATE.newMessage(this._objekt);
            operatingMessage.put("mq", (Object)this._mq);
            operatingMessage.put("from", (Object)AusfallFahrStreifen.formatDate(fromTime));
            operatingMessage.put("to", (Object)AusfallFahrStreifen.formatDate(checkTime));
            operatingMessage.put("duration", (Object)AusfallFahrStreifen.formatDuration(ausfallZeit));
            operatingMessage.put("maxDuration", (Object)AusfallFahrStreifen.formatDuration(maxAusfallZeitProTag));
            operatingMessage.addId((Object)"[DUA-PP-AH01]");
            operatingMessage.send();
        }
    }

    public static String formatDate(Instant dateTime) {
        return DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(dateTime, ZoneId.systemDefault()));
    }

    public static String formatDuration(long tmp) {
        long ms = tmp % 1000L;
        long sec = (tmp /= 1000L) % 60L;
        long min = (tmp /= 60L) % 60L;
        long h = tmp /= 60L;
        StringBuilder stringBuilder = new StringBuilder();
        if (h >= 1L) {
            if (h == 1L) {
                stringBuilder.append("1 Stunde ");
            } else {
                stringBuilder.append(h).append(" Stunden ");
            }
        }
        if (min >= 1L) {
            if (min == 1L) {
                stringBuilder.append("1 Minute ");
            } else {
                stringBuilder.append(min).append(" Minuten ");
            }
        }
        if (sec >= 1L) {
            if (sec == 1L) {
                stringBuilder.append("1 Sekunde ");
            } else {
                stringBuilder.append(sec).append(" Sekunden ");
            }
        }
        if (ms >= 1L) {
            if (ms == 1L) {
                stringBuilder.append("1 Millisekunde ");
            } else {
                stringBuilder.append(ms).append(" Millisekunden ");
            }
        }
        if (stringBuilder.length() == 0) {
            return "0 Sekunden";
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ResultData[] parameterFeld) {
        if (parameterFeld != null) {
            for (ResultData parameter : parameterFeld) {
                if (parameter == null || parameter.getData() == null || !parameter.getDataDescription().getAttributeGroup().equals(PLFahrStreifen.getParameterAtg(this._verwaltung.getVerbindung()))) continue;
                AusfallFahrStreifen ausfallFahrStreifen = this;
                synchronized (ausfallFahrStreifen) {
                    this._parameter = AtgVerkehrsDatenKurzZeitIntervallPlLogisch.getInstance(parameter);
                }
            }
        }
    }

    public String toString() {
        return this._objekt.toString();
    }
}

