/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.dua.plloglve.plloglve.standard;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dua.plloglve.plloglve.typen.OptionenPlausibilitaetsPruefungLogischVerkehr;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AtgVerkehrsDatenKurzZeitIntervallPlLogisch {
    private static final String[] ATTR = new String[]{"qKfz", "qLkw", "vPkw", "vLkw", "vKfz", "vgKfz", "b"};
    private final Map<String, Long> _maxMap = new HashMap<String, Long>();
    private final long _VKfzGrenz;
    private final long _BGrenz;
    private final OptionenPlausibilitaetsPruefungLogischVerkehr _verhalten;
    private final boolean _messageTls;
    private final boolean _messageVerkehr;
    private final long _maxAusfallZeitProTag;
    private final long _pruefIntervallAusfall;
    private final long _vertrauensbereichBezugsZeitraum;
    private final long _pruefIntervallVertrauensbereich;
    private final long _maxAusfallProBezugszeitraumEin;
    private final long _maxAusfallProBezugszeitraumAus;

    public AtgVerkehrsDatenKurzZeitIntervallPlLogisch(Data data) {
        for (String attr : ATTR) {
            this._maxMap.put(attr, data.getUnscaledValue(attr + "Max").longValue());
        }
        this._verhalten = OptionenPlausibilitaetsPruefungLogischVerkehr.getZustand(data.getUnscaledValue("VerhaltenGrenzwertPr\u00fcfung").intValue());
        this._VKfzGrenz = data.getUnscaledValue("vKfzGrenz").longValue();
        this._BGrenz = data.getUnscaledValue("bGrenz").longValue();
        this._messageTls = data.getUnscaledValue("ErzeugeBetriebsmeldungPr\u00fcfungTLS").intValue() != 0;
        this._messageVerkehr = data.getUnscaledValue("ErzeugeBetriebsmeldungPr\u00fcfungVerkehr").intValue() != 0;
        this._maxAusfallZeitProTag = data.getTimeValue("MaxAusfallZeitProTag").getMillis();
        this._pruefIntervallAusfall = data.getTimeValue("Pr\u00fcfintervallAusfallH\u00e4ufigkeit").getMillis();
        this._vertrauensbereichBezugsZeitraum = data.getTimeValue("BezugszeitraumVertrauensbereich").getMillis();
        this._pruefIntervallVertrauensbereich = data.getTimeValue("Pr\u00fcfintervallVertrauensbereich").getMillis();
        this._maxAusfallProBezugszeitraumEin = data.getTimeValue("MaxAusfallzeitVertrauensbereichEin").getMillis();
        this._maxAusfallProBezugszeitraumAus = data.getTimeValue("MaxAusfallzeitVertrauensbereichAus").getMillis();
    }

    public static AtgVerkehrsDatenKurzZeitIntervallPlLogisch getInstance(ResultData resultat) {
        Data data = resultat.getData();
        if (data == null) {
            return null;
        }
        return new AtgVerkehrsDatenKurzZeitIntervallPlLogisch(data);
    }

    public final Long getMax(String attribut) {
        return this._maxMap.get(attribut);
    }

    public static String getPid() {
        return "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2";
    }

    public OptionenPlausibilitaetsPruefungLogischVerkehr getVerhalten() {
        return this._verhalten;
    }

    public long getVKfzGrenz() {
        return this._VKfzGrenz;
    }

    public long getBGrenz() {
        return this._BGrenz;
    }

    public boolean isMessageTls() {
        return this._messageTls;
    }

    public boolean isMessageVerkehr() {
        return this._messageVerkehr;
    }

    public long getMaxAusfallZeitProTag() {
        return this._maxAusfallZeitProTag;
    }

    public long getPruefIntervallAusfall() {
        return this._pruefIntervallAusfall;
    }

    public long getVertrauensbereichBezugsZeitraum() {
        return this._vertrauensbereichBezugsZeitraum;
    }

    public long getPruefIntervallVertrauensbereich() {
        return this._pruefIntervallVertrauensbereich;
    }

    public long getMaxAusfallProBezugszeitraumEin() {
        return this._maxAusfallProBezugszeitraumEin;
    }

    public long getMaxAusfallProBezugszeitraumAus() {
        return this._maxAusfallProBezugszeitraumAus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._BGrenz, this._VKfzGrenz, this._maxAusfallProBezugszeitraumAus, this._maxAusfallProBezugszeitraumEin, this._maxAusfallZeitProTag, this._maxMap, this._messageTls, this._messageVerkehr, this._pruefIntervallAusfall, this._pruefIntervallVertrauensbereich, this._verhalten, this._vertrauensbereichBezugsZeitraum});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtgVerkehrsDatenKurzZeitIntervallPlLogisch other = (AtgVerkehrsDatenKurzZeitIntervallPlLogisch)obj;
        if (this._BGrenz != other._BGrenz) {
            return false;
        }
        if (this._VKfzGrenz != other._VKfzGrenz) {
            return false;
        }
        if (this._maxAusfallProBezugszeitraumAus != other._maxAusfallProBezugszeitraumAus) {
            return false;
        }
        if (this._maxAusfallProBezugszeitraumEin != other._maxAusfallProBezugszeitraumEin) {
            return false;
        }
        if (this._maxAusfallZeitProTag != other._maxAusfallZeitProTag) {
            return false;
        }
        if (this._maxMap == null ? other._maxMap != null : !this._maxMap.equals(other._maxMap)) {
            return false;
        }
        if (this._messageTls != other._messageTls) {
            return false;
        }
        if (this._messageVerkehr != other._messageVerkehr) {
            return false;
        }
        if (this._pruefIntervallAusfall != other._pruefIntervallAusfall) {
            return false;
        }
        if (this._pruefIntervallVertrauensbereich != other._pruefIntervallVertrauensbereich) {
            return false;
        }
        if (this._verhalten == null ? other._verhalten != null : !this._verhalten.equals((Object)other._verhalten)) {
            return false;
        }
        return this._vertrauensbereichBezugsZeitraum == other._vertrauensbereichBezugsZeitraum;
    }
}

