/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.dua.plloglve.plloglve.standard;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dua.guete.GWert;
import de.bsvrz.dua.guete.GueteException;
import de.bsvrz.dua.guete.GueteVerfahren;
import de.bsvrz.dua.guete.vorschriften.IGuete;
import de.bsvrz.dua.plloglve.plloglve.standard.AtgVerkehrsDatenKurzZeitIntervallPlLogisch;
import de.bsvrz.dua.plloglve.plloglve.typen.OptionenPlausibilitaetsPruefungLogischVerkehr;
import de.bsvrz.sys.funclib.bitctrl.dua.GanzZahl;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageTemplate;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;
import de.bsvrz.sys.funclib.operatingMessage.OperatingMessage;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;

public final class PLFahrStreifen
implements ClientReceiverInterface {
    public static final GWert MAX_GUETE_WERT = GWert.getMaxGueteWert((GueteVerfahren)GueteVerfahren.STANDARD);
    protected static final IGuete G = GueteVerfahren.STANDARD.getBerechnungsVorschrift();
    public static final String[] ATTRIBUT_NAMEN = new String[]{"qKfz", "qLkw", "qPkw", "vPkw", "vLkw", "vKfz", "vgKfz", "tNetto", "b"};
    public static final long MILLIS_PER_HOUR = 3600000L;
    private final IVerwaltung dieVerwaltung;
    private final SystemObject _obj;
    private SystemObject _mq;
    private ResultData letztesKZDatum = null;
    private AtgVerkehrsDatenKurzZeitIntervallPlLogisch parameterAtgGrenz = null;
    private static final Debug _debug = Debug.getLogger();
    public static final MessageTemplate TEMPLATE_TLS = new MessageTemplate(MessageGrade.INFORMATION, MessageType.APPLICATION_DOMAIN, new MessageTemplate.OperatingMessageParam[]{MessageTemplate.fixed((String)"Attribute "), MessageTemplate.set((String)"attr", (String)" und "), MessageTemplate.fixed((String)" durch Pl-Pr\u00fcfung TLS auf fehlerhaft gesetzt am Fahrstreifen "), MessageTemplate.object(), MessageTemplate.fixed((String)"("), MessageTemplate.variable((String)"mq"), MessageTemplate.fixed((String)"), da "), MessageTemplate.set((String)"values", (String)", "), MessageTemplate.fixed((String)". "), MessageTemplate.ids()}).withIdFactory(message -> message.getObject().getPidOrId() + " [DUA-PP-VT]");
    public static final MessageTemplate TEMPLATE_VERKEHR = new MessageTemplate(MessageGrade.INFORMATION, MessageType.APPLICATION_DOMAIN, new MessageTemplate.OperatingMessageParam[]{MessageTemplate.set((String)"attr", (String)" und ", (String)"Attribut ", (String)"Attribute "), MessageTemplate.fixed((String)" durch Pl-Pr\u00fcfung Verkehr auf fehlerhaft gesetzt am Fahrstreifen "), MessageTemplate.object(), MessageTemplate.fixed((String)"("), MessageTemplate.variable((String)"mq"), MessageTemplate.fixed((String)"), da "), MessageTemplate.set((String)"values", (String)", "), MessageTemplate.fixed((String)". "), MessageTemplate.ids()}).withIdFactory(message -> message.getObject().getPidOrId() + " [DUA-PP-VV]");
    public static final MessageTemplate TEMPLATE_GRENZWERT = new MessageTemplate(MessageGrade.INFORMATION, MessageType.APPLICATION_DOMAIN, new MessageTemplate.OperatingMessageParam[]{MessageTemplate.set((String)"attr", (String)" und ", (String)"Attribut ", (String)"Attribute "), MessageTemplate.fixed((String)" durch Grenzwertpr\u00fcfung auf fehlerhaft gesetzt am Fahrstreifen "), MessageTemplate.fixed((String)"("), MessageTemplate.variable((String)"mq"), MessageTemplate.fixed((String)"), da "), MessageTemplate.set((String)"values", (String)", "), MessageTemplate.fixed((String)". "), MessageTemplate.ids()}).withIdFactory(message -> message.getObject().getPidOrId() + " [DUA-PP-VGW]");

    public String toString() {
        return this._obj.toString();
    }

    public PLFahrStreifen(IVerwaltung verwaltung, SystemObject obj, SystemObject mq) {
        this._mq = mq;
        this.dieVerwaltung = verwaltung;
        this._obj = obj;
        ClientDavInterface connection = this.dieVerwaltung.getVerbindung();
        AttributeGroup parameterAtg = PLFahrStreifen.getParameterAtg(connection);
        if (parameterAtg != null) {
            connection.subscribeReceiver((ClientReceiverInterface)this, obj, new DataDescription(parameterAtg, connection.getDataModel().getAspect("asp.parameterSoll")), ReceiveOptions.normal(), ReceiverRole.receiver());
        } else {
            _debug.warning("Attributgruppe " + AtgVerkehrsDatenKurzZeitIntervallPlLogisch.getPid() + " ist nicht im Datenmodell vorhanden, die Grenzwerte werden nicht gepr\u00fcft");
        }
    }

    public static MessageAttributeSet formatAttributes(Data data, String ... attributes) {
        LinkedHashSet param = Arrays.asList(attributes).stream().map(s -> PLFahrStreifen.formatAttribute(data, s)).collect(Collectors.toCollection(LinkedHashSet::new));
        return new MessageAttributeSet(param);
    }

    public static String formatAttribute(Data data, String s) {
        return PLFahrStreifen.formatAttributeValue(s, data.getItem(s).getItem("Wert"));
    }

    public static String formatAttributeValue(String name, Object value) {
        if (value instanceof Data) {
            Data data = (Data)value;
            return name + "=" + data.asTextValue().getText();
        }
        return name + "=" + value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ueberpruefe(Data data, ResultData resultat) {
        Data origDatum = data.createUnmodifiableCopy();
        long vgKfzLetztesIntervall = -4L;
        String vgKfzLetztesIntervallDisplay = "Unbekannt";
        if (this.letztesKZDatum != null && this.letztesKZDatum.getData() != null && data.getTimeValue("T").getMillis() == resultat.getDataTime() - this.letztesKZDatum.getDataTime()) {
            vgKfzLetztesIntervall = PLFahrStreifen.getValue(this.letztesKZDatum.getData(), "vgKfz");
            vgKfzLetztesIntervallDisplay = this.letztesKZDatum.getData().getItem("vgKfz").getItem("Wert");
        }
        OperatingMessage messageTls = TEMPLATE_TLS.newMessage(this._obj);
        OperatingMessage messageVerkehr = TEMPLATE_VERKEHR.newMessage(this._obj);
        OperatingMessage messageGrenzwert = TEMPLATE_GRENZWERT.newMessage(this._obj);
        messageTls.put("mq", (Object)(this._mq == null ? "Unbekannter MQ" : this._mq));
        messageVerkehr.put("mq", (Object)(this._mq == null ? "Unbekannter MQ" : this._mq));
        messageGrenzwert.put("mq", (Object)(this._mq == null ? "Unbekannter MQ" : this._mq));
        if (data.getUnscaledValue("ArtMittelwertbildung").longValue() == 1L) {
            if (PLFahrStreifen.getValue(origDatum, "qKfz") == 0L && PLFahrStreifen.getValue(origDatum, "vKfz") != -1L && PLFahrStreifen.getValue(origDatum, "vKfz") != -3L) {
                messageTls.add("attr", (Object)"v");
                messageTls.add("values", (Object)PLFahrStreifen.formatAttributes(origDatum, "qKfz", "vKfz"));
                messageTls.addId((Object)"[DUA-PP-VT01]");
                this.setzeFehlerhaft(data, "vKfz", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "vPkw", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "vLkw", MAX_GUETE_WERT);
            }
            if (PLFahrStreifen.getValue(origDatum, "qPkw") == 0L && PLFahrStreifen.getValue(origDatum, "vPkw") != -1L && PLFahrStreifen.getValue(origDatum, "vPkw") != -3L) {
                messageTls.add("attr", (Object)"v");
                messageTls.add("values", (Object)PLFahrStreifen.formatAttributes(origDatum, "qPkw", "vPkw"));
                messageTls.addId((Object)"[DUA-PP-VT02]");
                this.setzeFehlerhaft(data, "vKfz", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "vPkw", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "vLkw", MAX_GUETE_WERT);
            }
            if (PLFahrStreifen.getValue(origDatum, "qLkw") == 0L && PLFahrStreifen.getValue(origDatum, "vLkw") != -1L && PLFahrStreifen.getValue(origDatum, "vLkw") != -3L) {
                messageTls.add("attr", (Object)"v");
                messageTls.add("values", (Object)PLFahrStreifen.formatAttributes(origDatum, "qLkw", "vLkw"));
                messageTls.addId((Object)"[DUA-PP-VT03]");
                this.setzeFehlerhaft(data, "vKfz", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "vPkw", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "vLkw", MAX_GUETE_WERT);
            }
            if (PLFahrStreifen.getValue(origDatum, "vKfz") > 0L && PLFahrStreifen.getValue(origDatum, "qKfz") <= 0L) {
                messageTls.add("attr", (Object)"q");
                messageTls.add("values", (Object)PLFahrStreifen.formatAttributes(origDatum, "vKfz", "qKfz"));
                messageTls.addId((Object)"[DUA-PP-VT04]");
                this.setzeFehlerhaft(data, "qKfz", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "qPkw", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "qLkw", MAX_GUETE_WERT);
            }
            if (PLFahrStreifen.getValue(origDatum, "vPkw") > 0L && PLFahrStreifen.getValue(origDatum, "qPkw") <= 0L) {
                messageTls.add("attr", (Object)"q");
                messageTls.add("values", (Object)PLFahrStreifen.formatAttributes(origDatum, "vPkw", "qPkw"));
                messageTls.addId((Object)"[DUA-PP-VT05]");
                this.setzeFehlerhaft(data, "qKfz", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "qPkw", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "qLkw", MAX_GUETE_WERT);
            }
            if (PLFahrStreifen.getValue(origDatum, "vLkw") > 0L && PLFahrStreifen.getValue(origDatum, "qLkw") <= 0L) {
                messageTls.add("attr", (Object)"q");
                messageTls.add("values", (Object)PLFahrStreifen.formatAttributes(origDatum, "vLkw", "qLkw"));
                messageTls.addId((Object)"[DUA-PP-VT06]");
                this.setzeFehlerhaft(data, "qKfz", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "qPkw", MAX_GUETE_WERT);
                this.setzeFehlerhaft(data, "qLkw", MAX_GUETE_WERT);
            }
        }
        if (PLFahrStreifen.getValue(origDatum, "qKfz") == 0L && PLFahrStreifen.getValue(origDatum, "vgKfz") >= 0L && vgKfzLetztesIntervall >= 0L && PLFahrStreifen.getValue(origDatum, "vgKfz") != vgKfzLetztesIntervall) {
            messageVerkehr.add("attr", (Object)"vgKfz");
            messageVerkehr.add("values", (Object)PLFahrStreifen.formatAttributes(origDatum, "qKfz", "vgKfz").append(PLFahrStreifen.formatAttributeValue("vgKfzAlt", vgKfzLetztesIntervallDisplay)));
            messageVerkehr.addId((Object)"[DUA-PP-VV01]");
            this.setzeFehlerhaft(data, "vgKfz", MAX_GUETE_WERT);
        }
        if (this.parameterAtgGrenz != null) {
            AtgVerkehrsDatenKurzZeitIntervallPlLogisch atgVerkehrsDatenKurzZeitIntervallPlLogisch = this.parameterAtgGrenz;
            synchronized (atgVerkehrsDatenKurzZeitIntervallPlLogisch) {
                if (PLFahrStreifen.getValue(origDatum, "vKfz") >= 0L && this.parameterAtgGrenz.getVKfzGrenz() >= 0L && PLFahrStreifen.getValue(origDatum, "vKfz") > this.parameterAtgGrenz.getVKfzGrenz() && PLFahrStreifen.getValue(origDatum, "b") >= 0L && this.parameterAtgGrenz.getBGrenz() >= 0L && PLFahrStreifen.getValue(origDatum, "b") >= this.parameterAtgGrenz.getBGrenz()) {
                    messageVerkehr.add("attr", (Object)"b");
                    messageVerkehr.add("values", (Object)PLFahrStreifen.formatAttributes(origDatum, "b").append(PLFahrStreifen.formatAttributeValue("bGrenz", this.parameterAtgGrenz.getBGrenz() + " %")).append(PLFahrStreifen.formatAttributes(origDatum, "vKfz")).append(PLFahrStreifen.formatAttributeValue("vGrenz", this.parameterAtgGrenz.getVKfzGrenz() + " km/h")));
                    messageVerkehr.addId((Object)"[DUA-PP-VV02]");
                    this.setzeFehlerhaft(data, "b", MAX_GUETE_WERT);
                }
                this.untersucheAufMaxVerletzung(data, "qKfz", messageGrenzwert, "[DUA-PP-VGW01]");
                this.untersucheAufMaxVerletzung(data, "qLkw", messageGrenzwert, "[DUA-PP-VGW02]");
                this.untersucheQPkw(data);
                this.untersucheAufMaxVerletzung(data, "vKfz", messageGrenzwert, "[DUA-PP-VGW04]");
                this.untersucheAufMaxVerletzung(data, "vLkw", messageGrenzwert, "[DUA-PP-VGW05]");
                this.untersucheAufMaxVerletzung(data, "vPkw", messageGrenzwert, "[DUA-PP-VGW06]");
                this.untersucheAufMaxVerletzung(data, "vgKfz", messageGrenzwert, "[DUA-PP-VGW07]");
                this.untersucheAufMaxVerletzung(data, "b", messageGrenzwert, "[DUA-PP-VGW08]");
            }
            if (this.parameterAtgGrenz.isMessageTls()) {
                messageTls.send();
            }
            if (this.parameterAtgGrenz.isMessageVerkehr()) {
                messageVerkehr.send();
            }
            messageGrenzwert.send();
        }
    }

    private static long getValue(Data data, String name) {
        return data.getItem(name).getUnscaledValue("Wert").longValue();
    }

    public static AttributeGroup getParameterAtg(ClientDavInterface dav) {
        return dav.getDataModel().getAttributeGroup(AtgVerkehrsDatenKurzZeitIntervallPlLogisch.getPid());
    }

    protected String[] getAttributNamen() {
        return ATTRIBUT_NAMEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ResultData[] parameterFeld) {
        if (parameterFeld != null) {
            for (ResultData parameter : parameterFeld) {
                if (parameter == null || parameter.getData() == null || !parameter.getDataDescription().getAttributeGroup().equals(PLFahrStreifen.getParameterAtg(this.dieVerwaltung.getVerbindung()))) continue;
                PLFahrStreifen pLFahrStreifen = this;
                synchronized (pLFahrStreifen) {
                    this.parameterAtgGrenz = AtgVerkehrsDatenKurzZeitIntervallPlLogisch.getInstance(parameter);
                }
            }
        }
    }

    protected void untersucheAufMaxVerletzung(Data davDatum, String wertName, OperatingMessage messageText, String id) {
        GanzZahl sweGueteWert = GanzZahl.getGueteIndex();
        sweGueteWert.setSkaliertenWert(0.8);
        GWert sweGuete = new GWert(sweGueteWert, GueteVerfahren.STANDARD, false);
        if (this.parameterAtgGrenz != null) {
            long maxIntervall;
            long wertStunde;
            long maxStunde = this.parameterAtgGrenz.getMax(wertName);
            OptionenPlausibilitaetsPruefungLogischVerkehr verhalten = this.parameterAtgGrenz.getVerhalten();
            if (verhalten.equals((Object)OptionenPlausibilitaetsPruefungLogischVerkehr.KEINE_PRUEFUNG)) {
                return;
            }
            long wert = PLFahrStreifen.getValue(davDatum, wertName);
            long t = davDatum.getTimeValue("T").getMillis();
            if (wertName.startsWith("q")) {
                wertStunde = wert * 3600000L / t;
                maxIntervall = maxStunde * t / 3600000L;
            } else {
                wertStunde = wert;
                maxIntervall = maxStunde;
            }
            if (wert >= 0L && maxStunde >= 0L) {
                boolean maxVerletzt;
                boolean bl = maxVerletzt = wertStunde > maxStunde;
                if (maxVerletzt) {
                    if (verhalten.equals((Object)OptionenPlausibilitaetsPruefungLogischVerkehr.WERT_REDUZIEREN)) {
                        davDatum.getItem(wertName).getUnscaledValue("Wert").set(maxIntervall);
                        davDatum.getItem(wertName).getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMaxLogisch").set(1);
                    } else if (verhalten.equals((Object)OptionenPlausibilitaetsPruefungLogischVerkehr.AUF_FEHLERHAFT_SETZEN)) {
                        messageText.add("values", (Object)this.formatMax(wertName, wertStunde, maxStunde));
                        if (wertName.startsWith("v")) {
                            this.setzeFehlerhaft(davDatum, "vKfz", sweGuete, messageText, id);
                            this.setzeFehlerhaft(davDatum, "vPkw", sweGuete, messageText, id);
                            this.setzeFehlerhaft(davDatum, "vLkw", sweGuete, messageText, id);
                            this.setzeFehlerhaft(davDatum, "vgKfz", sweGuete, messageText, id);
                        } else if (wertName.startsWith("q")) {
                            this.setzeFehlerhaft(davDatum, "qKfz", sweGuete, messageText, id);
                            this.setzeFehlerhaft(davDatum, "qPkw", sweGuete, messageText, id);
                            this.setzeFehlerhaft(davDatum, "qLkw", sweGuete, messageText, id);
                        } else {
                            this.setzeFehlerhaft(davDatum, wertName, sweGuete, messageText, id);
                        }
                    }
                }
            }
        }
    }

    protected void untersucheQPkw(Data davDatum) {
        GanzZahl sweGueteWert = GanzZahl.getGueteIndex();
        sweGueteWert.setSkaliertenWert(0.8);
        if (this.parameterAtgGrenz != null) {
            boolean bedingungVerletzt;
            OptionenPlausibilitaetsPruefungLogischVerkehr verhalten = this.parameterAtgGrenz.getVerhalten();
            if (verhalten.equals((Object)OptionenPlausibilitaetsPruefungLogischVerkehr.KEINE_PRUEFUNG)) {
                return;
            }
            long qPkw = PLFahrStreifen.getValue(davDatum, "qPkw");
            long qLkw = PLFahrStreifen.getValue(davDatum, "qLkw");
            long qKfz = PLFahrStreifen.getValue(davDatum, "qKfz");
            boolean bl = bedingungVerletzt = qPkw >= 0L && qLkw >= 0L && qKfz >= 0L && qPkw + qLkw != qKfz;
            if (bedingungVerletzt) {
                davDatum.getItem("qPkw").getUnscaledValue("Wert").set(qKfz - qLkw);
                davDatum.getItem("qPkw").getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMaxLogisch").set(1);
            }
        }
    }

    private String formatMax(String attr, long wertStunde, long maxStunde) {
        if (attr.startsWith("q")) {
            return attr + "=" + wertStunde + " Fz/h > " + maxStunde + " Fz/h";
        }
        if (attr.startsWith("v")) {
            return attr + "=" + wertStunde + " km/h > " + maxStunde + " km/h";
        }
        if (attr.startsWith("b")) {
            return attr + "=" + wertStunde + " % > " + maxStunde + " %";
        }
        return attr + "=" + wertStunde + " > " + maxStunde;
    }

    private void setzeFehlerhaft(Data davDatum, String wertName, GWert sweGuete) {
        davDatum.getItem(wertName).getUnscaledValue("Wert").set(-2);
        davDatum.getItem(wertName).getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMaxLogisch").set(1);
        davDatum.getItem(wertName).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Implausibel").set(1);
        GWert guete = new GWert(davDatum, wertName);
        try {
            GWert produkt = GueteVerfahren.produkt((GWert[])new GWert[]{guete, sweGuete});
            produkt.exportiere(davDatum, wertName);
        }
        catch (GueteException e) {
            Debug.getLogger().warning("G\u00fcte nicht berechenbar", (Throwable)e);
        }
    }

    private void setzeFehlerhaft(Data davDatum, String wertName, GWert sweGuete, OperatingMessage messageText, String id) {
        this.setzeFehlerhaft(davDatum, wertName, sweGuete);
        messageText.add("attr", (Object)wertName);
        messageText.addId((Object)id);
    }

    protected Data plausibilisiere(ResultData resultat) {
        Data copy = null;
        if (resultat.getData() != null) {
            try {
                copy = resultat.getData().createModifiableCopy();
                this.ueberpruefe(copy, resultat);
            }
            catch (IllegalStateException e) {
                Debug.getLogger().error("Es konnte keine Kopie von Datensatz erzeugt werden:\n" + resultat, (Throwable)e);
            }
        }
        this.letztesKZDatum = resultat;
        return copy;
    }

    public static class MessageAttributeSet {
        private final LinkedHashSet<String> _param;

        public MessageAttributeSet(LinkedHashSet<String> param) {
            this._param = param;
        }

        public String toString() {
            return OperatingMessage.formatCollection(this._param, (String)" und ", (String)"", (String)"").toString();
        }

        public MessageAttributeSet append(MessageAttributeSet other) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(this._param.size() + other._param.size());
            set.addAll(this._param);
            set.addAll(other._param);
            return new MessageAttributeSet(set);
        }

        public MessageAttributeSet append(String other) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(this._param.size() + 1);
            set.addAll(this._param);
            set.add(other);
            return new MessageAttributeSet(set);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MessageAttributeSet)) {
                return false;
            }
            MessageAttributeSet that = (MessageAttributeSet)o;
            return this._param.equals(that._param);
        }

        public int hashCode() {
            return this._param.hashCode();
        }
    }
}

