/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.dua.plloglve.plloglve.standard;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dua.plloglve.plloglve.PlPruefungLogischLVE;
import de.bsvrz.dua.plloglve.plloglve.standard.PLFahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.adapter.AbstraktBearbeitungsKnotenAdapter;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.schnittstellen.IDatenFlussSteuerung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.typen.ModulTyp;
import de.bsvrz.sys.funclib.bitctrl.dua.lve.DuaVerkehrsNetz;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PlLogischLVEStandard
extends AbstraktBearbeitungsKnotenAdapter {
    private Map<SystemObject, PLFahrStreifen> _fahrStreifen = new HashMap<SystemObject, PLFahrStreifen>();

    public void initialisiere(IVerwaltung dieVerwaltung) throws DUAInitialisierungsException {
        super.initialisiere(dieVerwaltung);
        DuaVerkehrsNetz.initialisiere((ClientDavInterface)dieVerwaltung.getVerbindung());
        for (SystemObject obj : dieVerwaltung.getSystemObjekte()) {
            this._fahrStreifen.put(obj, new PLFahrStreifen(dieVerwaltung, obj, PlPruefungLogischLVE.getMq(obj)));
        }
    }

    public void aktualisiereDaten(ResultData[] resultate) {
        if (resultate != null) {
            ArrayList<ResultData> weiterzuleitendeResultate = new ArrayList<ResultData>();
            for (ResultData resultat : resultate) {
                if (resultat == null) continue;
                PLFahrStreifen fahrStreifen = null;
                if (resultat.getDataDescription().getAttributeGroup().getId() != PlPruefungLogischLVE.atgKzdId) {
                    weiterzuleitendeResultate.add(resultat);
                    continue;
                }
                fahrStreifen = this._fahrStreifen.get(resultat.getObject());
                Data pData = null;
                if (fahrStreifen != null) {
                    pData = fahrStreifen.plausibilisiere(resultat);
                } else {
                    Debug.getLogger().warning("Fahrstreifen " + resultat.getObject() + " konnte nicht identifiziert werden");
                }
                if (pData != null) {
                    ResultData ersetztesResultat = new ResultData(resultat.getObject(), resultat.getDataDescription(), resultat.getDataTime(), pData, resultat.isDelayedData());
                    weiterzuleitendeResultate.add(ersetztesResultat);
                    continue;
                }
                weiterzuleitendeResultate.add(resultat);
            }
            if (this.knoten != null && !weiterzuleitendeResultate.isEmpty()) {
                this.knoten.aktualisiereDaten(weiterzuleitendeResultate.toArray(new ResultData[0]));
            }
        }
    }

    public ModulTyp getModulTyp() {
        return null;
    }

    public void aktualisierePublikation(IDatenFlussSteuerung dfs) {
    }
}

