/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.dua.plloglve.plloglve.vb;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dua.plloglve.plloglve.ausfall.AusfallFahrStreifen;
import de.bsvrz.dua.plloglve.plloglve.standard.AtgVerkehrsDatenKurzZeitIntervallPlLogisch;
import de.bsvrz.dua.plloglve.plloglve.standard.PLFahrStreifen;
import de.bsvrz.dua.plloglve.plloglve.vb.VertrauensbereichDatumKomplett;
import de.bsvrz.dua.plloglve.plloglve.vb.VertrauensbereichPuffer;
import de.bsvrz.sys.funclib.bitctrl.dua.intpuf.IntervallPufferException;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageTemplate;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;
import de.bsvrz.sys.funclib.operatingMessage.OperatingMessage;
import de.bsvrz.sys.funclib.operatingMessage.OperatingMessageInterface;
import de.bsvrz.sys.funclib.operatingMessage.PersistentOperatingMessage;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Set;

public class VertrauensFahrStreifen
implements ClientReceiverInterface {
    private static final String[] ATTRIBUTE = new String[]{"qKfz", "qLkw", "qPkw", "vKfz", "vLkw", "vPkw", "b", "tNetto", "sKfz", "vgKfz"};
    private static final Debug _debug = Debug.getLogger();
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.GERMAN);
    private IVerwaltung _verwaltung = null;
    private final SystemObject _mq;
    private final VertrauensbereichPuffer gleitenderTag = new VertrauensbereichPuffer();
    private final SystemObject _objekt;
    private AtgVerkehrsDatenKurzZeitIntervallPlLogisch _parameter;
    private static final MessageTemplate TEMPLATE_EIN = new MessageTemplate(MessageGrade.INFORMATION, MessageType.APPLICATION_DOMAIN, new MessageTemplate.OperatingMessageParam[]{MessageTemplate.fixed((String)"Daten au\u00dferhalb des Vertrauensbereichs: im Zeitraum von "), MessageTemplate.variable((String)"from"), MessageTemplate.fixed((String)" bis "), MessageTemplate.variable((String)"to"), MessageTemplate.fixed((String)" ("), MessageTemplate.variable((String)"bezug"), MessageTemplate.fixed((String)") implausible Fahrstreifenwerte f\u00fcr"), MessageTemplate.set((String)"values", (String)" und ", (String)" den Wert ", (String)" die Werte "), MessageTemplate.fixed((String)" am Fahrstreifen "), MessageTemplate.object(), MessageTemplate.fixed((String)"("), MessageTemplate.variable((String)"mq"), MessageTemplate.fixed((String)") w\u00e4hrend "), MessageTemplate.variable((String)"duration"), MessageTemplate.fixed((String)" (> "), MessageTemplate.variable((String)"maxDuration"), MessageTemplate.fixed((String)"). Fahrstreifenwerte werden auf fehlerhaft gesetzt und als implausibel gekennzeichnet. "), MessageTemplate.ids()}).withIdFactory(message -> message.getObject().getPidOrId() + " [DUA-PP-VB]");
    private static final MessageTemplate TEMPLATE_AUS = new MessageTemplate(MessageGrade.INFORMATION, MessageType.APPLICATION_DOMAIN, new MessageTemplate.OperatingMessageParam[]{MessageTemplate.fixed((String)"Daten wieder innerhalb des Vertrauensbereichs: im Zeitraum von "), MessageTemplate.variable((String)"from"), MessageTemplate.fixed((String)" bis "), MessageTemplate.variable((String)"to"), MessageTemplate.fixed((String)" ("), MessageTemplate.variable((String)"bezug"), MessageTemplate.fixed((String)") implausible Fahrstreifenwerte am Fahrstreifen "), MessageTemplate.object(), MessageTemplate.fixed((String)"("), MessageTemplate.variable((String)"mq"), MessageTemplate.fixed((String)") w\u00e4hrend "), MessageTemplate.variable((String)"duration"), MessageTemplate.fixed((String)" (< "), MessageTemplate.variable((String)"maxDuration"), MessageTemplate.fixed((String)"). Fahrstreifenwerte werden wieder verarbeitet. "), MessageTemplate.ids()}).withIdFactory(message -> message.getObject().getPidOrId() + " [DUA-PP-VB]");
    private Instant _lastCheckTime;
    private PersistentOperatingMessage _meldung;

    protected VertrauensFahrStreifen(IVerwaltung verwaltung, SystemObject obj, SystemObject mq) {
        this._objekt = obj;
        this._verwaltung = verwaltung;
        this._mq = mq;
        ClientDavInterface connection = verwaltung.getVerbindung();
        AttributeGroup parameterAtg = PLFahrStreifen.getParameterAtg(connection);
        if (parameterAtg != null) {
            connection.subscribeReceiver((ClientReceiverInterface)this, obj, new DataDescription(parameterAtg, connection.getDataModel().getAspect("asp.parameterSoll")), ReceiveOptions.normal(), ReceiverRole.receiver());
        } else {
            _debug.warning("Attributgruppe " + AtgVerkehrsDatenKurzZeitIntervallPlLogisch.getPid() + " ist nicht im Datenmodell vorhanden, die Grenzwerte werden nicht gepr\u00fcft");
        }
    }

    protected final synchronized Data plausibilisiere(ResultData resultat) {
        Data copy = resultat.getData();
        VertrauensbereichDatumKomplett ausfallDatum = VertrauensbereichDatumKomplett.getAusfallDatumVon(resultat);
        if (this._parameter != null) {
            boolean verletztAktuell;
            if (ausfallDatum != null) {
                try {
                    this.gleitenderTag.add(ausfallDatum);
                }
                catch (IntervallPufferException e) {
                    _debug.error("Fehler beim Intervallpuffer", (Throwable)e);
                }
                long startIntervall = ausfallDatum.getIntervallEnde() - this._parameter.getVertrauensbereichBezugsZeitraum();
                try {
                    this.gleitenderTag.loescheAllesUnterhalbVon(startIntervall);
                }
                catch (IntervallPufferException e) {
                    _debug.error("Fehler beim Intervallpuffer", (Throwable)e);
                }
                Instant now = Instant.ofEpochMilli(ausfallDatum.getIntervallEnde());
                long pruefIntervallAusfall = this._parameter.getPruefIntervallVertrauensbereich();
                Instant nextCheckTime = this._lastCheckTime == null ? now : this._lastCheckTime.plusMillis(pruefIntervallAusfall);
                if (!now.isBefore(nextCheckTime)) {
                    this.pruefeAusfall(Instant.ofEpochMilli(startIntervall), now);
                    this._lastCheckTime = nextCheckTime;
                }
            }
            boolean bl = verletztAktuell = this._meldung != null;
            if (verletztAktuell && copy != null) {
                copy = copy.createModifiableCopy();
                for (String attribut : ATTRIBUTE) {
                    copy.getItem(attribut).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Implausibel").set(1);
                    copy.getItem(attribut).getItem("Wert").asUnscaledValue().set(-2);
                }
            }
        } else {
            Debug.getLogger().warning("Fuer Fahrstreifen " + this + " wurden noch keine Parameter f\u00fcr die Pr\u00fcfung des Vertrauensbereichs empfangen");
        }
        return copy;
    }

    public String toString() {
        return this._objekt.toString();
    }

    private synchronized void pruefeAusfall(Instant fromTime, Instant checkTime) {
        if (this._parameter == null) {
            return;
        }
        long ausfallZeit = this.gleitenderTag.getAusfallZeit();
        long maxAusfallZeitEin = this._parameter.getMaxAusfallProBezugszeitraumEin();
        long maxAusfallZeitAus = this._parameter.getMaxAusfallProBezugszeitraumAus();
        if (maxAusfallZeitEin <= 0L && maxAusfallZeitAus <= 0L) {
            return;
        }
        if (maxAusfallZeitAus > maxAusfallZeitEin) {
            _debug.warning("Ung\u00fcltige Vertrauensbereich-Parameter am Fahrstreifen " + this._objekt + ": MaxAusfallProBezugszeitraumAus > MaxAusfallProBezugszeitraumEin");
            return;
        }
        if (this._meldung != null && ausfallZeit < maxAusfallZeitAus) {
            this.sendeGutMeldung(fromTime, checkTime, ausfallZeit);
        } else if (this._meldung != null || ausfallZeit > maxAusfallZeitEin) {
            this.erzeugeMeldung(fromTime, checkTime, ausfallZeit, this.gleitenderTag.getAusfallAttribute());
        }
    }

    private void erzeugeMeldung(Instant fromTime, Instant checkTime, long ausfallZeit, Set<String> values) {
        OperatingMessage operatingMessage = TEMPLATE_EIN.newMessage(this._objekt);
        operatingMessage.put("mq", (Object)this._mq);
        operatingMessage.put("from", (Object)AusfallFahrStreifen.formatDate(fromTime));
        operatingMessage.put("to", (Object)AusfallFahrStreifen.formatDate(checkTime));
        operatingMessage.put("duration", (Object)AusfallFahrStreifen.formatDuration(ausfallZeit));
        operatingMessage.put("maxDuration", (Object)AusfallFahrStreifen.formatDuration(this._parameter.getMaxAusfallProBezugszeitraumEin()));
        operatingMessage.put("bezug", (Object)AusfallFahrStreifen.formatDuration(this._parameter.getVertrauensbereichBezugsZeitraum()));
        operatingMessage.put("values", values);
        operatingMessage.addId((Object)"[DUA-PP-VB01]");
        if (this._meldung == null) {
            this._meldung = operatingMessage.newPersistentMessage();
        } else {
            this._meldung.update((OperatingMessageInterface)operatingMessage);
        }
    }

    private void sendeGutMeldung(Instant fromTime, Instant checkTime, long ausfallZeit) {
        OperatingMessage operatingMessage = TEMPLATE_AUS.newMessage(this._objekt);
        operatingMessage.put("mq", (Object)this._mq);
        operatingMessage.put("from", (Object)AusfallFahrStreifen.formatDate(fromTime));
        operatingMessage.put("to", (Object)AusfallFahrStreifen.formatDate(checkTime));
        operatingMessage.put("duration", (Object)AusfallFahrStreifen.formatDuration(ausfallZeit));
        operatingMessage.put("maxDuration", (Object)AusfallFahrStreifen.formatDuration(this._parameter.getMaxAusfallProBezugszeitraumAus()));
        operatingMessage.put("bezug", (Object)AusfallFahrStreifen.formatDuration(this._parameter.getVertrauensbereichBezugsZeitraum()));
        operatingMessage.addId((Object)"[DUA-PP-VB02]");
        this._meldung.resolve((OperatingMessageInterface)operatingMessage);
        this._meldung = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ResultData[] parameterFeld) {
        if (parameterFeld != null) {
            for (ResultData parameter : parameterFeld) {
                if (parameter == null || parameter.getData() == null || !parameter.getDataDescription().getAttributeGroup().equals(PLFahrStreifen.getParameterAtg(this._verwaltung.getVerbindung()))) continue;
                VertrauensFahrStreifen vertrauensFahrStreifen = this;
                synchronized (vertrauensFahrStreifen) {
                    this._parameter = AtgVerkehrsDatenKurzZeitIntervallPlLogisch.getInstance(parameter);
                }
            }
        }
    }
}

