/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.dua.plloglve.plloglve.vb;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dua.plloglve.plloglve.PlPruefungLogischLVE;
import de.bsvrz.dua.plloglve.plloglve.vb.VertrauensFahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.adapter.AbstraktBearbeitungsKnotenAdapter;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.schnittstellen.IDatenFlussSteuerung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.typen.ModulTyp;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IStandardAspekte;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Vertrauensbereich
extends AbstraktBearbeitungsKnotenAdapter {
    private Map<SystemObject, VertrauensFahrStreifen> fahrStreifenMap = new HashMap<SystemObject, VertrauensFahrStreifen>();

    public Vertrauensbereich(IStandardAspekte stdAspekte) {
        this.standardAspekte = stdAspekte;
    }

    public void initialisiere(IVerwaltung dieVerwaltung) throws DUAInitialisierungsException {
        super.initialisiere(dieVerwaltung);
        if (this.publizieren) {
            this.publikationsAnmeldungen.modifiziereObjektAnmeldung(this.standardAspekte.getStandardAnmeldungen(this.verwaltung.getSystemObjekte()));
        }
        for (SystemObject fsObj : dieVerwaltung.getSystemObjekte()) {
            this.fahrStreifenMap.put(fsObj, new VertrauensFahrStreifen(dieVerwaltung, fsObj, PlPruefungLogischLVE.getMq(fsObj)));
        }
    }

    public void aktualisiereDaten(ResultData[] resultate) {
        if (resultate != null) {
            ArrayList<ResultData> weiterzuleitendeResultate = new ArrayList<ResultData>();
            for (ResultData resultat : resultate) {
                if (resultat == null) continue;
                Data datum = null;
                if (resultat.getDataDescription().getAttributeGroup().getId() == PlPruefungLogischLVE.atgKzdId) {
                    if (resultat.getData() != null) {
                        VertrauensFahrStreifen fs = this.fahrStreifenMap.get(resultat.getObject());
                        if (fs != null) {
                            datum = fs.plausibilisiere(resultat);
                        } else {
                            Debug.getLogger().warning("Datum fuer nicht identifizierbaren Fahrstreifen empfangen: " + resultat.getObject());
                        }
                    }
                } else {
                    datum = resultat.getData();
                }
                ResultData publikationsDatum = new ResultData(resultat.getObject(), new DataDescription(resultat.getDataDescription().getAttributeGroup(), this.standardAspekte.getStandardAspekt(resultat)), resultat.getDataTime(), datum, resultat.isDelayedData());
                ResultData weiterzuleitendesDatum = new ResultData(resultat.getObject(), resultat.getDataDescription(), resultat.getDataTime(), datum, resultat.isDelayedData());
                if (this.publizieren) {
                    this.publikationsAnmeldungen.sende(publikationsDatum);
                }
                weiterzuleitendeResultate.add(weiterzuleitendesDatum);
            }
            if (this.knoten != null && !weiterzuleitendeResultate.isEmpty()) {
                this.knoten.aktualisiereDaten(weiterzuleitendeResultate.toArray(new ResultData[0]));
            }
        }
    }

    public ModulTyp getModulTyp() {
        return null;
    }

    public void aktualisierePublikation(IDatenFlussSteuerung dfs) {
    }
}

