/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.dua.plloglve.tests;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dua.plloglve.tests.DuAPlLogLveTestBase;
import de.bsvrz.dua.tests.ColumnLayout;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.Before;
import org.junit.Test;

public class TestDuAPlLogLve
extends DuAPlLogLveTestBase {
    private DataDescription _ddIn;
    private DataDescription _ddOut;
    private SystemObject[] _testFs;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        for (SystemObject obj : this._testFs = new SystemObject[]{_dataModel.getObject("fs.mq.1.hfs")}) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitAnalyseFs", "{kKfz:{Grenz:'48',Max:'68'},kLkw:{Grenz:'28',Max:'38'},kPkw:{Grenz:'48',Max:'68'},kB:{Grenz:'58',Max:'77'},fl:{k1:'2,2',k2:'0,02'}}");
            TestDuAPlLogLve.publishPrognoseParamsFs(obj);
        }
        AttributeGroup atg = _dataModel.getAttributeGroup("atg.verkehrsDatenKurzZeitIntervall");
        Aspect aspInput = _dataModel.getAspect("asp.externeErfassung");
        Aspect aspOutput = _dataModel.getAspect("asp.plausibilit\u00e4tsPr\u00fcfungLogisch");
        this._ddIn = new DataDescription(atg, aspInput);
        this._ddOut = new DataDescription(atg, aspOutput);
        Thread.sleep(1000L);
    }

    @Test
    public void testDua13() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Ja',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Ja',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA13.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlColumnLayout(){

            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                if (fullRow.get(22).equals("X")) {
                    return "[DUA-PP-VT01]";
                }
                if (fullRow.get(23).equals("X")) {
                    return "[DUA-PP-VT02]";
                }
                if (fullRow.get(24).equals("X")) {
                    return "[DUA-PP-VT03]";
                }
                if (fullRow.get(25).equals("X")) {
                    return "[DUA-PP-VT04]";
                }
                if (fullRow.get(26).equals("X")) {
                    return "[DUA-PP-VT05]";
                }
                if (fullRow.get(27).equals("X")) {
                    return "[DUA-PP-VT06]";
                }
                if (fullRow.get(28).equals("X")) {
                    return "[DUA-PP-VT07]";
                }
                return null;
            }
        });
    }

    @Test
    public void testDua13Nomessage() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Ja',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA13.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlColumnLayout());
    }

    @Test
    public void testDua14() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Ja',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Ja',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA14-1.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlColumnLayout(){

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"b", (Object)"tNetto", (Object)"sKfz", (Object)"NichtErfasst", (Object)"WertMaxLogisch", (Object[])new String[]{"vKfz", "qLkw", "vLkw", "qPkw", "vPkw"});
            }

            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                if (fullRow.get(22).equals("X")) {
                    return "[DUA-PP-VV01]";
                }
                return null;
            }
        });
    }

    @Test
    public void testDua14B() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Ja',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Ja',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA14-2.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlColumnLayout(){

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"tNetto", (Object)"sKfz", (Object)"vgKfz", (Object)"NichtErfasst", (Object)"WertMaxLogisch", (Object[])new String[]{"qKfz", "qLkw", "vLkw", "qPkw", "vPkw"});
            }

            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                if (fullRow.get(22).equals("X")) {
                    return "[DUA-PP-VV02]";
                }
                return null;
            }
        });
    }

    @Test
    public void testDua14NoMessage() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Ja',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA14-1.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlColumnLayout(){

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"b", (Object)"tNetto", (Object)"sKfz", (Object)"NichtErfasst", (Object)"WertMaxLogisch", (Object[])new String[]{"vKfz", "qLkw", "vLkw", "qPkw", "vPkw"});
            }

            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                return null;
            }
        });
    }

    @Test
    public void testDua14NoMessageB() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Ja',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA14-2.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlColumnLayout(){

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"tNetto", (Object)"sKfz", (Object)"vgKfz", (Object)"NichtErfasst", (Object)"WertMaxLogisch", (Object[])new String[]{"qKfz", "qLkw", "vLkw", "qPkw", "vPkw", "Wert", "Implausibel"});
            }

            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                return null;
            }
        });
    }

    @Test
    public void testDua1516a() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Wert reduzieren',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'100 %',qKfzMax:'1800',qLkwMax:'180',vKfzMax:'115',vLkwMax:'90',vPkwMax:'120',vgKfzMax:'113',bMax:'80'}");
        }
        this.startTestCase("DUA15-1.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout(){

            @Override
            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                return null;
            }
        });
    }

    @Test
    public void testDua1516b() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Auf fehlerhaft setzen',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'100 %',qKfzMax:'1800',qLkwMax:'180',vKfzMax:'115',vLkwMax:'90',vPkwMax:'120',vgKfzMax:'113',bMax:'80'}");
        }
        this.startTestCase("DUA15-2.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout());
    }

    @Test
    public void testDua1516c() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'100 %',qKfzMax:'30',qLkwMax:'3',vKfzMax:'115',vLkwMax:'90',vPkwMax:'120',vgKfzMax:'113',bMax:'80'}");
        }
        this.startTestCase("DUA15-3.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout(){

            @Override
            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                return null;
            }
        });
    }

    @Test
    public void testDua51() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenDifferenzialKontrolleFs2", "{maxAnzKonstanzVerkehrsmenge:'6',maxAnzKonstanzGeschwindigkeit:'4',maxAnzKonstanzStreung:'7',maxAnzKonstanzBelegung:'4'}");
        }
        this.startTestCase("DUA51.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout2());
    }

    @Test
    public void testDua51B() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenDifferenzialKontrolleFs2", "{maxAnzKonstanzVerkehrsmenge:'0',maxAnzKonstanzGeschwindigkeit:'4',maxAnzKonstanzStreung:'0',maxAnzKonstanzBelegung:'4'}");
        }
        this.startTestCase("DUA51.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout2(){

            @Override
            public LinkedHashSet<String> adjustAttributes(LinkedHashSet<String> set) {
                set.remove("s");
                set.remove("q");
                return set;
            }

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"Wert", (Object)"Implausibel", (Object)"NichtErfasst", (Object)"WertMaxLogisch");
            }
        });
    }

    @Test
    public void testDua51C() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenDifferenzialKontrolleFs2", "{maxAnzKonstanzVerkehrsmenge:'6',maxAnzKonstanzGeschwindigkeit:'0',maxAnzKonstanzStreung:'7',maxAnzKonstanzBelegung:'0'}");
        }
        this.startTestCase("DUA51.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout2(){

            @Override
            public LinkedHashSet<String> adjustAttributes(LinkedHashSet<String> set) {
                set.remove("v");
                set.remove("b");
                return set;
            }

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"Wert", (Object)"Implausibel", (Object)"NichtErfasst", (Object)"WertMaxLogisch");
            }
        });
    }

    @Test
    public void testDua51D() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'15 Minuten',MaxAusfallZeitProTag:'2 Stunden',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenDifferenzialKontrolleFs2", "{maxAnzKonstanzVerkehrsmenge:'0',maxAnzKonstanzGeschwindigkeit:'0',maxAnzKonstanzStreung:'0',maxAnzKonstanzBelegung:'0'}");
        }
        this.startTestCase("DUA51.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout2(){

            @Override
            public LinkedHashSet<String> adjustAttributes(LinkedHashSet<String> set) {
                set.remove("q");
                set.remove("v");
                set.remove("s");
                set.remove("b");
                return set;
            }

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"Wert", (Object)"Implausibel", (Object)"NichtErfasst", (Object)"WertMaxLogisch");
            }
        });
    }

    @Test
    public void testDua52() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'10 Minuten',MaxAusfallZeitProTag:'93 Minuten',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA52.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new Pl52Layout());
    }

    @Test
    public void testDua52B() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'10 Minuten',MaxAusfallZeitProTag:'0 Minuten',BezugszeitraumVertrauensbereich:'0 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',Pr\u00fcfintervallVertrauensbereich:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA52.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new Pl52Layout(){

            @Override
            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                return null;
            }

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"Wert", (Object)"Implausibel", (Object)"Index", (Object)"NichtErfasst", (Object)"WertMaxLogisch", (Object[])new String[0]);
            }
        });
    }

    @Test
    public void testDua53() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'10 Minuten',MaxAusfallZeitProTag:'95 Minuten',BezugszeitraumVertrauensbereich:'50 Minuten',Pr\u00fcfintervallVertrauensbereich:'10 Minuten',MaxAusfallzeitVertrauensbereichEin:'15 Minuten',MaxAusfallzeitVertrauensbereichAus:'13 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA53.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout3());
    }

    @Test
    public void testDua53B() throws Exception {
        for (SystemObject obj : this._testFs) {
            fakeParamApp.publishParam(obj.getPid(), "atg.verkehrsDatenKurzZeitIntervallPlausibilit\u00e4tsPr\u00fcfungLogisch2", "{ErzeugeBetriebsmeldungPr\u00fcfungTLS:'Nein',ErzeugeBetriebsmeldungPr\u00fcfungVerkehr:'Nein',VerhaltenGrenzwertPr\u00fcfung:'Keine Pr\u00fcfung',Pr\u00fcfintervallAusfallH\u00e4ufigkeit:'10 Minuten',MaxAusfallZeitProTag:'95 Minuten',BezugszeitraumVertrauensbereich:'50 Minuten',Pr\u00fcfintervallVertrauensbereich:'10 Minuten',MaxAusfallzeitVertrauensbereichEin:'0 Minuten',MaxAusfallzeitVertrauensbereichAus:'0 Minuten',vKfzGrenz:'100 km/h',bGrenz:'80 %',qKfzMax:'4000',qLkwMax:'4000',vKfzMax:'254',vLkwMax:'254',vPkwMax:'254',vgKfzMax:'254',bMax:'100'}");
        }
        this.startTestCase("DUA53.csv", this._testFs, this._testFs, this._ddIn, this._ddOut, new PlLongColumnLayout3(){

            @Override
            public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
                return null;
            }

            @Override
            public Collection<String> getIgnored() {
                return ImmutableSet.of((Object)"T", (Object)"Wert", (Object)"Implausibel", (Object)"NichtErfasst", (Object)"WertMaxLogisch");
            }
        });
    }

    public void sendData(ResultData ... resultDatas) throws SendSubscriptionNotConfirmed {
        this._pruefungLogischLVE.update(resultDatas);
    }

    private static class Pl52Layout
    extends PlColumnLayout {
        private Pl52Layout() {
        }

        @Override
        public Collection<String> getIgnored() {
            return ImmutableSet.of((Object)"T", (Object)"b", (Object)"tNetto", (Object)"sKfz", (Object)"NichtErfasst", (Object)"WertMaxLogisch", (Object[])new String[]{"qKfz", "vKfz", "qLkw", "vLkw", "qPkw", "vPkw", "vgKfz"});
        }

        @Override
        public void setValues(SystemObject testObject, Data item, List<String> row, int realCol, String type, boolean in) {
            if (in) {
                item.getTextValue("Wert").setText(row.get(realCol));
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(10000);
                item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText(row.get(realCol).equals("-2") ? "Ja" : "Nein");
            }
        }

        @Override
        public boolean groupingEnabled() {
            return false;
        }

        public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
            String s = fullRow.get(15);
            if (s.equals("-") || s.isEmpty()) {
                return null;
            }
            return "[DUA-PP-AH01]";
        }
    }

    private static class PlLongColumnLayout3
    extends PlColumnLayout {
        private PlLongColumnLayout3() {
        }

        @Override
        public Collection<String> getIgnored() {
            return ImmutableSet.of((Object)"T", (Object)"NichtErfasst", (Object)"WertMaxLogisch");
        }

        @Override
        public void setValues(SystemObject testObject, Data item, List<String> row, int realCol, String type, boolean in) {
            item.getTextValue("Wert").setText(row.get(realCol));
            if (!in) {
                String percent;
                item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText(row.get(realCol + 11));
                if (row.get(realCol).equals("-2")) {
                    item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText("Ja");
                }
                if ((percent = row.get(realCol + 22)).endsWith("%")) {
                    percent = percent.substring(0, percent.length() - 1);
                }
                percent = percent.replace(',', '.');
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(Double.parseDouble(percent) * 100.0);
            } else {
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(10000);
                item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText(row.get(realCol).equals("-2") ? "Ja" : "Nein");
            }
        }

        public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
            String s = fullRow.get(18);
            if (s.equals("-") || s.isEmpty()) {
                return null;
            }
            if (s.equals("Gutmeldung")) {
                return "[DUA-PP-VB02]";
            }
            return "[DUA-PP-VB01]";
        }

        @Override
        public boolean groupingEnabled() {
            return false;
        }
    }

    private static class PlLongColumnLayout2
    extends PlColumnLayout {
        private PlLongColumnLayout2() {
        }

        @Override
        public Collection<String> getIgnored() {
            return ImmutableSet.of((Object)"T", (Object)"NichtErfasst", (Object)"WertMaxLogisch");
        }

        @Override
        public void setValues(SystemObject testObject, Data item, List<String> row, int realCol, String type, boolean in) {
            item.getTextValue("Wert").setText(row.get(realCol));
            if (!in) {
                item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText(row.get(realCol + 11));
                String percent = row.get(realCol + 22);
                if (percent.endsWith("%")) {
                    percent = percent.substring(0, percent.length() - 1);
                }
                percent = percent.replace(',', '.');
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(Double.parseDouble(percent) * 100.0);
            } else {
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(10000);
                item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText(row.get(realCol).equals("-2") ? "Ja" : "Nein");
            }
        }

        public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
            String s = fullRow.get(15);
            if (s.equals("keine Betriebsmeldung") || s.isEmpty()) {
                return null;
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>(Splitter.on((String)",").trimResults().splitToList((CharSequence)s.replaceAll("^Betriebsmeldung(en)? ", "")));
            if ((set = this.adjustAttributes(set)).isEmpty()) {
                return null;
            }
            return Joiner.on((String)" und ").join(set) + " \u00fcberschritten";
        }

        public LinkedHashSet<String> adjustAttributes(LinkedHashSet<String> set) {
            return set;
        }

        @Override
        public boolean groupingEnabled() {
            return false;
        }
    }

    private static class PlLongColumnLayout
    extends PlColumnLayout {
        private PlLongColumnLayout() {
        }

        @Override
        public Collection<String> getIgnored() {
            return ImmutableSet.of((Object)"T", (Object)"NichtErfasst", (Object)"WertMaxLogisch");
        }

        @Override
        public void setValues(SystemObject testObject, Data item, List<String> row, int realCol, String type, boolean in) {
            item.getTextValue("Wert").setText(row.get(realCol));
            if (!in) {
                item.getItem("Status").getItem("PlLogisch").getTextValue("WertMaxLogisch").setText(row.get(realCol + 13));
                item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText(row.get(realCol + 24));
                String percent = row.get(realCol + 35);
                if (percent.endsWith("%")) {
                    percent = percent.substring(0, percent.length() - 1);
                }
                percent = percent.replace(',', '.');
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(Double.parseDouble(percent) * 100.0);
            } else {
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(10000);
                item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText(row.get(realCol).equals("-2") ? "Ja" : "Nein");
            }
        }

        public String getExpectedMessageText(List<String> fullRow, DataDescription dataDescription, List<List<String>> header, long timestamp) {
            if (fullRow.get(15).equals("X")) {
                return "[DUA-PP-VGW01]";
            }
            if (fullRow.get(16).equals("X")) {
                return "[DUA-PP-VGW02]";
            }
            if (fullRow.get(17).equals("X")) {
                return "[DUA-PP-VGW03]";
            }
            if (fullRow.get(18).equals("X")) {
                return "[DUA-PP-VGW04]";
            }
            if (fullRow.get(19).equals("X")) {
                return "[DUA-PP-VGW05]";
            }
            if (fullRow.get(20).equals("X")) {
                return "[DUA-PP-VGW06]";
            }
            if (fullRow.get(21).equals("X")) {
                return "[DUA-PP-VGW07]";
            }
            if (fullRow.get(22).equals("X")) {
                return "[DUA-PP-VGW08]";
            }
            return null;
        }

        @Override
        public boolean groupingEnabled() {
            return false;
        }
    }

    private static class PlColumnLayout
    extends ColumnLayout {
        private PlColumnLayout() {
        }

        public int getColumnCount(boolean in) {
            return 1;
        }

        public void setValues(SystemObject testObject, Data item, List<String> row, int realCol, String type, boolean in) {
            item.getTextValue("Wert").setText(row.get(realCol));
            if (!in) {
                item.getItem("Status").getItem("MessWertErsetzung").getTextValue("Implausibel").setText(row.get(realCol + 7));
                String percent = row.get(realCol + 14);
                if (percent.endsWith("%")) {
                    percent = percent.substring(0, percent.length() - 1);
                }
                percent = percent.replace(',', '.');
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(Double.parseDouble(percent) * 100.0);
            } else {
                item.getItem("G\u00fcte").getUnscaledValue("Index").set(10000);
            }
        }

        public Collection<String> getIgnored() {
            return ImmutableSet.of((Object)"T", (Object)"b", (Object)"tNetto", (Object)"sKfz", (Object)"vgKfz", (Object)"NichtErfasst", (Object[])new String[]{"WertMaxLogisch"});
        }

        public boolean groupingEnabled() {
            return false;
        }
    }
}

