/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import com.bitctrl.resource.Configuration;
import com.bitctrl.util.logging.LoggerTools;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.MutableSetChangeListener;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BaustellenLoeschen
implements MutableSetChangeListener,
ClientSenderInterface {
    private static Logger log = Logger.getLogger(BaustellenLoeschen.class.getName());
    private static ClientDavConnection verbindung;
    private static String netz;
    private Object _myLock;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration konfig = Configuration.getConfiguration();
        Level level = Level.parse(konfig.getString("debug.level"));
        LoggerTools.setLogggerLevel((Level)level);
        log.setLevel(level);
        log.info("Stelle Verbindung zum Datenverteiler her ...");
        verbindung = new ClientDavConnection();
        verbindung.getClientDavParameters().setDavCommunicationAddress(konfig.getString("dav.host"));
        verbindung.getClientDavParameters().setDavCommunicationSubAddress(konfig.getInt("dav.port"));
        verbindung.connect();
        verbindung.login(konfig.getString("dav.benutzer"), konfig.getString("dav.kennwort"));
        ObjektFactory factory = ObjektFactory.getInstanz();
        factory.setVerbindung((ClientDavInterface)verbindung);
        factory.registerStandardFactories();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return false;
    }

    @Test
    public void loescheBaustellen() {
        try {
            SystemObject _netz = verbindung.getDataModel().getObject(netz);
            if (_netz == null) {
                throw new BisInterfaceException("Das Netz '" + netz + "' kann nicht initialisiert werden");
            }
            MutableSet baustellenmenge = ((ConfigurationObject)_netz).getMutableSet("Baustellen");
            System.out.println("Anzahl der Baustellen im Netz '" + netz + "': " + baustellenmenge.getElements().size());
            List baustellen = baustellenmenge.getElements();
            if (baustellen.size() != 0) {
                for (SystemObject object : baustellen) {
                    System.out.println("Baustelle " + object + " wird gel\u00f6scht!");
                    baustellenmenge.remove(object);
                }
            } else {
                System.out.println("keine Meldungen aus der Menge zu l\u00f6schen");
            }
            List robjekte = verbindung.getDataModel().getType("typ.baustelle").getElements();
            System.out.println("l\u00f6sche weitere " + robjekte.size() + " Baustellen");
            for (SystemObject so : robjekte) {
                System.out.println("Baustelle " + so + " wird gel\u00f6scht!");
                so.invalidate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public void update(MutableSet set, SystemObject[] addedObjects, SystemObject[] removedObjects) {
        System.out.println("gel\u00f6schte Objekte: " + removedObjects);
    }

    static {
        netz = "RDSNetz";
    }
}

