/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.CommunicationError;
import de.bsvrz.dav.daf.main.ConnectionException;
import de.bsvrz.dav.daf.main.InconsistentLoginException;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;
import de.bsvrz.sys.funclib.bitctrl.kalender.Ereigniskalender;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.EreignisTyp;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EreignisTypLoeschen
extends AbstractBIS {
    public static void main(String[] args) {
        EreignisTypLoeschen el = new EreignisTypLoeschen();
        el.loeschen();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    private ClientDavInterface connect(String davHost, String davUsername, String davPassword) throws MissingParameterException, CommunicationError, ConnectionException, InconsistentLoginException {
        ClientDavConnection dav = null;
        ArgumentList argList = new ArgumentList(new String[]{"-datenverteiler=" + davHost});
        ClientDavParameters cdp = new ClientDavParameters(argList);
        cdp.setApplicationName("BIS");
        dav = new ClientDavConnection(cdp);
        dav.connect();
        dav.login(davUsername, davPassword);
        return dav;
    }

    @Test
    public void loeschen() {
        try {
            ClientDavConnection _dav = (ClientDavConnection)this.connect("192.168.1.136:8083", "Tester", "geheim");
            DataModel _config = _dav.getDataModel();
            SystemObject _kv = _config.getObject("kv.bitctrl.isis");
            if (_kv == null) {
                throw new BisInterfaceException("Der Konfigurationsverantwortliche 'kv.bitctrl.isis' kann nicht initialisiert werden");
            }
            if (!_kv.getType().getPid().equals("typ.isis")) {
                throw new BisInterfaceException("Der Konfigurationsverantwortliche 'kv.bitctrl.isis' ist nicht vom Typ 'typ.isis'!");
            }
            ObjektFactory.getInstanz().setVerbindung((ClientDavInterface)_dav);
            ObjektFactory.getInstanz().registerStandardFactories();
            SystemObject etdav = _config.getObject("ereignisTyp.Baustelle");
            if (etdav == null) {
                System.out.println("Der EreignisTyp 'ereignisTyp.Baustelle' existiert nicht");
            } else {
                EreignisTyp ereignisTyp = (EreignisTyp)ObjektFactory.getInstanz().getModellobjekt(etdav);
                Ereigniskalender.getInstanz().loeschen(ereignisTyp);
                System.out.println("Der EreignisTyp 'ereignisTyp.Baustelle' wurde gel\u00f6scht");
            }
        }
        catch (BisInterfaceException e) {
            System.err.println(e.getMessage());
        }
        catch (MissingParameterException e) {
            e.printStackTrace();
        }
        catch (CommunicationError e) {
            e.printStackTrace();
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        catch (InconsistentLoginException e) {
            e.printStackTrace();
        }
        catch (ConfigurationChangeException e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }
}

