/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import com.bitctrl.resource.Configuration;
import com.bitctrl.util.logging.LoggerTools;
import de.bsvrz.kex.isis.isis.AbstraktBisImpl;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.TestBaustellenGueltigkeit;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IsisTests {
    private static Logger log = Logger.getLogger(TestBaustellenGueltigkeit.class.getName());
    public static Configuration konfig = null;
    public static AbstraktBisImpl bisTest = null;
    public static long baustelle1;
    public static long baustelle2;
    public static long baustelle3;
    public static long baustelle4;

    static void init() throws FileNotFoundException, IOException, BisInterfaceException {
        konfig = Configuration.getConfiguration();
        Level level = Level.parse(konfig.getString("debug.level"));
        LoggerTools.setLogggerLevel((Level)level);
        log.setLevel(level);
        ArgumentList al = new ArgumentList(new String[]{"-debugLevelStdErrText=" + level});
        Debug.init((String)TestBaustellenGueltigkeit.class.getName(), (ArgumentList)al);
        bisTest = new AbstraktBisImpl();
        String propfilename = konfig.getString("BisPropertyDatei");
        File propfile = new File(propfilename);
        bisTest.init(propfile.getAbsolutePath());
    }

    static void disconnect() {
        bisTest.disconnect();
    }

    private static void liesIds(String dateiname) {
        Properties props = new Properties();
        try {
            FileInputStream input = new FileInputStream(new File(dateiname));
            props.load(input);
            baustelle1 = Long.parseLong(props.getProperty("Baustelle1"));
            baustelle2 = Long.parseLong(props.getProperty("Baustelle2"));
            baustelle3 = Long.parseLong(props.getProperty("Baustelle3"));
            baustelle4 = Long.parseLong(props.getProperty("Baustelle4"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void liesTestbaustellenIds() {
        IsisTests.liesIds(konfig.getString("IdDatei"));
    }

    public static long naechsterTag() {
        GregorianCalendar naechsterTag = new GregorianCalendar();
        naechsterTag.add(5, 1);
        naechsterTag.set(11, 0);
        naechsterTag.set(12, 0);
        naechsterTag.set(13, 0);
        naechsterTag.set(14, 0);
        return naechsterTag.getTimeInMillis();
    }

    public static void sichereBaustellenIds() {
        PrintStream ps;
        try {
            File datei = new File(konfig.getString("IdDatei"));
            ps = new PrintStream(datei);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        ps.println("# gespeicherte Baustellen-IDs der ISIS-Testumgebung");
        ps.println("Baustelle1=" + baustelle1);
        ps.println("Baustelle2=" + baustelle2);
        ps.println("Baustelle3=" + baustelle3);
        ps.println("Baustelle4=" + baustelle4);
        ps.close();
    }

    private IsisTests() {
    }
}

