/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import com.bitctrl.resource.Configuration;
import com.bitctrl.util.logging.LoggerTools;
import de.bsvrz.kex.isis.isis.AbstraktBisImpl;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestASBinSBK {
    private static Logger log = Logger.getLogger(TestASBinSBK.class.getName());
    private static Configuration konfig = null;
    static AbstraktBisImpl bisTest = null;
    private static long baustelle1;

    @BeforeClass
    public static void beforeClass() throws Exception {
        konfig = Configuration.getConfiguration();
        Level level = Level.parse(konfig.getString("debug.level"));
        LoggerTools.setLogggerLevel((Level)level);
        log.setLevel(level);
        ArgumentList al = new ArgumentList(new String[]{"-debugLevelStdErrText=" + level});
        Debug.init((String)TestASBinSBK.class.getName(), (ArgumentList)al);
        bisTest = new AbstraktBisImpl();
        String propfilename = konfig.getString("BisPropertyDatei");
        File propfile = new File(propfilename);
        bisTest.init(propfile.getAbsolutePath());
    }

    public static void liesIds(String dateiname) {
        Properties props = new Properties();
        try {
            FileInputStream input = new FileInputStream(new File(dateiname));
            props.load(input);
            baustelle1 = Long.parseLong(props.getProperty("Baustelle1"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen");
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testUmrechnung() {
        try {
            String Anfangsknoten = konfig.getString("Anfangsknoten");
            String Endknoten = konfig.getString("Endknoten");
            long stationierung = Long.parseLong(konfig.getString("Stationierung"));
            System.out.println("Test Referenzierungsumrechnung in Strasse und Betriebskilometer");
            System.out.println("Anfangsknoten: " + Anfangsknoten);
            System.out.println("Endknoten:     " + Endknoten);
            System.out.println("Stationierung: " + stationierung);
            OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(Anfangsknoten, Endknoten, NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, stationierung);
            Assert.assertNotNull((Object)asbref);
            List soref = asbref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
            Assert.assertNotNull((Object)soref);
            for (OrtsReferenzStrasseUndBetriebsKilometerInterface ref : soref) {
                System.out.println("ermittelte Ortsreferenz:");
                System.out.println("Strasse:            " + ref.getStrasse().getPid());
                System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
                System.out.println("Blocknummer:        " + ref.getBlockNummer());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }
}

