/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestASBinSSO {
    private static long baustelle1;

    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
    }

    public static void liesIds(String dateiname) {
        Properties props = new Properties();
        try {
            FileInputStream input = new FileInputStream(new File(dateiname));
            props.load(input);
            baustelle1 = Long.parseLong(props.getProperty("Baustelle1"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen");
    }

    private void printGanglinie(String name, int[] ganglinie) {
        String glstring = name + ": ";
        for (int i = 0; i < ganglinie.length; ++i) {
            if (i > 0) {
                glstring = glstring + ", ";
            }
            glstring = glstring + String.valueOf(ganglinie[i]);
        }
        System.out.println(glstring);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testUmrechnung() {
        try {
            String Anfangsknoten = IsisTests.konfig.getString("Anfangsknoten");
            String Endknoten = IsisTests.konfig.getString("Endknoten");
            long stationierung = Long.parseLong(IsisTests.konfig.getString("Stationierung"));
            String richtung = IsisTests.konfig.getString("StationierungsRichtung");
            NetzInterface.ASBStationierungsRichtung asbRichtung = null;
            if (richtung.equalsIgnoreCase("IN_STATIONIERUNGSRICHTUNG")) {
                asbRichtung = NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG;
            } else if (richtung.equalsIgnoreCase("GEGEN_STATIONIERUNGSRICHTUNG")) {
                asbRichtung = NetzInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG;
            } else {
                Assert.fail((String)("Die ASB-Stationierungsrichtung '" + richtung + "' ist nicht zul\u00e4ssig"));
            }
            System.out.println("Test Referenzierungsumrechnung ASB in Segment und Offset");
            System.out.println("Anfangsknoten: " + Anfangsknoten);
            System.out.println("Endknoten:     " + Endknoten);
            System.out.println("Stationierung: " + stationierung);
            System.out.println("Richtung:      " + asbRichtung);
            OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(Anfangsknoten, Endknoten, asbRichtung, stationierung);
            Assert.assertNotNull((Object)asbref);
            List soref = asbref.ermittleOrtsReferenzStrassenSegmentUndOffset();
            Assert.assertNotNull((Object)soref);
            for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : soref) {
                System.out.println("Ortsreferenz:");
                System.out.println("Segment: " + ref.getStrassenSegment().getPid());
                System.out.println("Offset:  " + ref.getStartOffset());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }
}

