/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface;
import de.bsvrz.kex.isis.isis.BisInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBaustellenAnlegen {
    private static final String PIDPREFIX = "Test";

    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen, Pr\u00fcffall 3");
    }

    @Test
    public void testBaustelleAnlegen() {
        try {
            String baustellenverantwortlichername = "TestBaustellenVerantwortlicher";
            BaustellenVerantwortlicherInterface v = IsisTests.bisTest.erzeugeBaustellenVerantwortlichen(baustellenverantwortlichername + " firma", baustellenverantwortlichername + " name", baustellenverantwortlichername + " telefon", baustellenverantwortlichername + " telefonFirma", baustellenverantwortlichername + " telefonMobil");
            OrtsReferenzStrassenSegmentUndOffsetInterface oref = IsisTests.bisTest.erzeugeOrtsReferenz(IsisTests.konfig.getString("AnlegenSegment"), Long.parseLong(IsisTests.konfig.getString("AnlegenOffset")));
            Assert.assertNotNull((Object)oref);
            System.out.println();
            System.out.println("Die Baustelle 'Test1.1.1970' wird angelegt");
            IsisTests.baustelle1 = IsisTests.bisTest.erzeugeBaustelle("Test1.1.1970", "TestName 1.1.1970", "Info 1.1.1970", 1L, 0L, oref, 0L, BisInterface.BaustellenZustand.ENTWORFEN, 0, v);
            System.out.println("Die Baustelle 'Testjetzt' wird angelegt");
            IsisTests.baustelle2 = IsisTests.bisTest.erzeugeBaustelle("Testjetzt", "TestName jetzt", "Info jetzt", System.currentTimeMillis(), 86400000L, oref, Long.MAX_VALUE, BisInterface.BaustellenZustand.GEPLANT, 100000000, v);
            System.out.println("Die Baustelle 'Testn\u00e4chster_Tag' wird angelegt");
            IsisTests.baustelle3 = IsisTests.bisTest.erzeugeBaustelle("Testn\u00e4chster_Tag", "TestName n\u00e4chster Tag", "Info n\u00e4chster Tag", IsisTests.naechsterTag(), 604800000L, oref, 0L, BisInterface.BaustellenZustand.GUELTIG, 0, v);
            System.out.println("Die Baustelle 'Test1.1.1970+MAX_LONG' wird angelegt");
            IsisTests.baustelle4 = IsisTests.bisTest.erzeugeBaustelle("Test1.1.1970+MAX_LONG", "TestName 1.1.1970+MAX_LONG", "Info 1.1.1970+MAX_LONG", Long.MAX_VALUE, 2678400000L, oref, 1000L, BisInterface.BaustellenZustand.STORNIERT, 19, v);
            System.out.println("Baustellen angelegt");
            IsisTests.sichereBaustellenIds();
        }
        catch (BisInterfaceException e) {
            System.err.println((Object)e);
            Assert.fail();
        }
    }
}

