/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.BaustelleInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBaustellenOrt {
    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
        IsisTests.liesTestbaustellenIds();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen, Pr\u00fcffall 3");
    }

    @Test
    public void testBaustellenOrt() {
        try {
            System.out.println();
            System.out.println("Die Orte der Baustellen werden ge\u00e4ndert");
            String neuesSegment = IsisTests.konfig.getString("NeuesSegment");
            OrtsReferenzStrassenSegmentUndOffsetInterface oref = IsisTests.bisTest.erzeugeOrtsReferenz(neuesSegment, 2000L);
            Assert.assertNotNull((Object)oref);
            BaustelleInterface baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle1);
            System.out.println("Der Ort der Baustelle " + baustelle.getPid() + " wird auf " + oref.getStrassenSegment().getPid() + ", Offset: " + oref.getStartOffset() + " ge\u00e4ndert");
            baustelle.aendereBaustellenOrt(oref);
            oref = IsisTests.bisTest.erzeugeOrtsReferenz(neuesSegment, 0L);
            Assert.assertNotNull((Object)oref);
            System.out.println("Der Ort der Baustelle " + IsisTests.bisTest.getBaustelle(IsisTests.baustelle2).getPid() + " wird auf " + oref.getStrassenSegment().getPid() + ", Offset: " + oref.getStartOffset() + " ge\u00e4ndert");
            IsisTests.bisTest.getBaustelle(IsisTests.baustelle2).aendereBaustellenOrt(oref);
            System.out.println("Baustellenorte ge\u00e4ndert");
        }
        catch (BisInterfaceException e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }

    @Test(expected=BisInterfaceException.class)
    public void testBaustellenOrtUngueltig() throws BisInterfaceException {
        System.out.println();
        System.out.println("Die Orte der Baustellen werden auf ung\u00fcltige Werte ge\u00e4ndert");
        String neuesSegment = IsisTests.konfig.getString("NeuesSegment");
        OrtsReferenzStrassenSegmentUndOffsetInterface oref = IsisTests.bisTest.erzeugeOrtsReferenz(neuesSegment, 3000L);
        Assert.assertNotNull((Object)oref);
        oref = IsisTests.bisTest.erzeugeOrtsReferenz(neuesSegment, Long.MAX_VALUE);
        Assert.assertNotNull((Object)oref);
        System.out.println("Der Ort der Baustelle " + IsisTests.bisTest.getBaustelle(IsisTests.baustelle3).getPid() + " wird auf " + oref.getStrassenSegment().getPid() + ", Offset: " + oref.getStartOffset() + " ge\u00e4ndert");
        IsisTests.bisTest.getBaustelle(IsisTests.baustelle3).aendereBaustellenOrt(oref);
        oref = IsisTests.bisTest.erzeugeOrtsReferenz(neuesSegment, Long.MIN_VALUE);
        Assert.assertNotNull((Object)oref);
        System.out.println("Der Ort der Baustelle " + IsisTests.bisTest.getBaustelle(IsisTests.baustelle4).getPid() + " wird auf " + oref.getStrassenSegment().getPid() + ", Offset: " + oref.getStartOffset() + " ge\u00e4ndert");
        IsisTests.bisTest.getBaustelle(IsisTests.baustelle4).aendereBaustellenOrt(oref);
    }
}

