/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.BaustelleInterface;
import de.bsvrz.kex.isis.isis.BaustellenPrognoseInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.impl.Baustelle;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.Datum;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.onlinedaten.OdBaustellenSimulation;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.onlinedaten.OdBaustellenSimulationStarten;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBaustellenSimulation
implements DatensatzUpdateListener {
    private static final long MAX_LAENGE_STAU = 10000L;

    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
        IsisTests.liesTestbaustellenIds();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen, Pr\u00fcffall 3");
    }

    public void datensatzAktualisiert(DatensatzUpdateEvent event) {
        de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle baustelle = (de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle)event.getObjekt();
        OdBaustellenSimulation simuerg = (OdBaustellenSimulation)baustelle.getOnlineDatensatz(OdBaustellenSimulation.class);
        OdBaustellenSimulation.Daten daten = simuerg.erzeugeDatum();
        OdBaustellenSimulation.Daten.StauEintrag eintrag = new OdBaustellenSimulation.Daten.StauEintrag();
        eintrag.setMaxLaenge(10000L);
        eintrag.setMaxLaengeZeit(System.currentTimeMillis() + 60000L);
        eintrag.setStartZeit(System.currentTimeMillis());
        eintrag.setVerlustZeit(10000L);
        eintrag.setDauer(1000L);
        daten.addSchritte(new OdBaustellenSimulation.Daten.StauEintrag[]{eintrag});
        try {
            simuerg.sendeDaten(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt(), (Datum)daten);
        }
        catch (DatensendeException e) {
            Assert.fail();
        }
    }

    private void simulationAnmelden(Baustelle baustelle) throws AnmeldeException {
        OdBaustellenSimulation simu = (OdBaustellenSimulation)baustelle.getModellBaustelle().getOnlineDatensatz(OdBaustellenSimulation.class);
        simu.setQuelle(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt(), true);
        simu.anmeldenSender(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt());
        ((OdBaustellenSimulation)baustelle.getModellBaustelle().getOnlineDatensatz(OdBaustellenSimulation.class)).addUpdateListener(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt(), (DatensatzUpdateListener)this);
        OdBaustellenSimulationStarten simustart = (OdBaustellenSimulationStarten)baustelle.getModellBaustelle().getOnlineDatensatz(OdBaustellenSimulationStarten.class);
        simustart.setSenke(OdBaustellenSimulationStarten.Aspekte.Senden.getAspekt(), true);
        ((OdBaustellenSimulationStarten)baustelle.getModellBaustelle().getOnlineDatensatz(OdBaustellenSimulationStarten.class)).addUpdateListener(OdBaustellenSimulationStarten.Aspekte.Senden.getAspekt(), (DatensatzUpdateListener)this);
    }

    @Test
    public void testBaustellenSimulation() {
        try {
            BaustelleInterface baustelle = IsisTests.bisTest.getBaustelle(IsisTests.baustelle1);
            if (baustelle == null) {
                System.err.println("Die Testbaustelle kann nicht initialisiert werden!");
                Assert.fail();
            }
            System.out.println("F\u00fcr die Baustelle " + baustelle.getPid() + " wird eine Prognose durchgef\u00fchrt");
            this.simulationAnmelden((Baustelle)baustelle);
            Thread.sleep(1000L);
            BaustellenPrognoseInterface prognose = baustelle.startePrognose("TEST", "Testsimulation");
            int anzahl = prognose.getMaximaleStauLaengen().length;
            SimpleDateFormat formatter = new SimpleDateFormat();
            for (int i = 0; i < anzahl; ++i) {
                GregorianCalendar cala = new GregorianCalendar();
                GregorianCalendar cale = new GregorianCalendar();
                cala.setTimeInMillis(prognose.getStauBeginn()[i]);
                cale.setTimeInMillis(prognose.getZeitpunkteDerMaximalenStauLaengen()[i]);
                System.out.println("Ergebnis: ");
                System.out.println("Staubeginn:       " + formatter.format(cala.getTime()));
                System.out.println("Dauer:            " + prognose.getStauDauern()[i]);
                System.out.println("max. L\u00e4nge:       " + prognose.getMaximaleStauLaengen()[i]);
                System.out.println("max. Verlustzeit: " + prognose.getMaximaleVerlustzeiten()[i]);
                System.out.println("Zeit max. L\u00e4nge:  " + formatter.format(cale.getTime()));
            }
            Assert.assertEquals((Object)1, (Object)anzahl);
            Assert.assertEquals((Object)10000L, (Object)prognose.getMaximaleStauLaengen()[0]);
            System.out.println("Baustellensimulation abgeschlossen");
        }
        catch (BisInterfaceException e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
        catch (AnmeldeException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

