/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import com.bitctrl.util.Interval;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.iav.gllib.gllib.Stuetzstelle;
import de.bsvrz.iav.gllib.gllib.dav.GanglinieMQ;
import de.bsvrz.iav.gllib.gllib.dav.Ganglinienprognose;
import de.bsvrz.iav.gllib.gllib.dav.Messwerte;
import de.bsvrz.iav.gllib.gllib.modell.parameter.PdGanglinie;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.GanglinienInterface;
import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.MessQuerschnittInterface;
import de.bsvrz.kex.isis.isis.impl.MessQuerschnitt;
import de.bsvrz.sys.funclib.bitctrl.kalender.Ereigniskalender;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.Datum;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.Ereignis;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.EreignisTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.MessQuerschnittAllgemein;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGanglinien {
    private Ereignis ereignis;
    MessQuerschnittAllgemein mq;

    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
        if (!Ganglinienprognose.getInstanz().isBereit()) {
            Assert.fail((String)"Die Ganglinienprognose ist nicht bereit");
        }
        if (!Ereigniskalender.getInstanz().isBereit()) {
            Assert.fail((String)"Der Ereigniskalender ist nicht bereit");
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen, Pr\u00fcffall 3");
    }

    private Ereignis anlegenEreignis(GregorianCalendar start, GregorianCalendar ende) throws ConfigurationChangeException, AnmeldeException, DatensendeException, BisInterfaceException, FileNotFoundException, IOException {
        String pid = "Testereignis" + System.currentTimeMillis();
        String name = "Testereignis Name";
        String beschreibung = "Angelegt zum Ganglinientest";
        String quelle = "ISIS-Test";
        EreignisTyp ereignisTyp = (EreignisTyp)ObjektFactory.getInstanz().getModellobjekt("ereignisTyp.Baustelle");
        Interval intervall = new Interval(start.getTimeInMillis(), ende.getTimeInMillis());
        this.ereignis = Ereigniskalender.getInstanz().anlegenEreignis(pid, name, beschreibung, ereignisTyp, intervall, quelle);
        return this.ereignis;
    }

    private void gangLinieAnlegen(MessQuerschnittInterface mqi) {
        this.mq = ((MessQuerschnitt)mqi).getMessQuerschnitt();
        PdGanglinie param = (PdGanglinie)this.mq.getParameterDatensatz(PdGanglinie.class);
        try {
            param.anmeldenSender();
            PdGanglinie.Daten datum = param.erzeugeDatum();
            GanglinieMQ g = new GanglinieMQ();
            g.setMessQuerschnitt(this.mq);
            g.setApproximationDaK(3);
            g.setEreignisTyp((EreignisTyp)ObjektFactory.getInstanz().getModellobjekt("ereignisTyp.Baustelle"));
            g.setReferenz(true);
            Integer qKfz = 1000;
            Integer qLkw = 500;
            Integer vPkw = 100;
            Integer vLkw = 80;
            Messwerte messwerte = new Messwerte(qKfz != null ? Double.valueOf(((Number)qKfz).doubleValue()) : null, qLkw != null ? Double.valueOf(((Number)qLkw).doubleValue()) : null, vPkw != null ? Double.valueOf(((Number)vPkw).doubleValue()) : null, vLkw != null ? Double.valueOf(((Number)vLkw).doubleValue()) : null);
            g.setStuetzstelle(new Stuetzstelle(0L, (Object)messwerte));
            g.setStuetzstelle(new Stuetzstelle(86400000L, (Object)messwerte));
            datum.add(g);
            param.sendeDaten((Datum)datum, 60000L);
            System.out.println("Ganglinien f\u00fcr " + this.mq + " gesendet.");
        }
        catch (AnmeldeException ex) {
            System.err.println("Kann mich nicht zum Senden der Ganglinien f\u00fcr " + this.mq + " anmelden.");
        }
        catch (DatensendeException ex) {
            System.err.println("Kann Ganglinien f\u00fcr " + this.mq + " nicht senden.");
        }
        param.abmeldenSender();
    }

    private void printGanglinien(GanglinienInterface[] gli) {
        if (gli.length == 0) {
            System.out.println("Keine Ganglinien");
        } else {
            for (GanglinienInterface g : gli) {
                System.out.println("Ganglinie Datum: " + DateFormat.getDateTimeInstance().format(new Date(g.getDatum())) + ", " + g.getQKfz().length + " St\u00fctzstellen");
                this.printGanglinienWerte("QKfz", g.getQKfz());
                this.printGanglinienWerte("QLkw", g.getQLkw());
                this.printGanglinienWerte("QPkw", g.getQPkw());
                this.printGanglinienWerte("VKfz", g.getVKfz());
                this.printGanglinienWerte("VLkw", g.getVLkw());
                this.printGanglinienWerte("VPkw", g.getVPkw());
            }
        }
    }

    private void printGanglinienWerte(String name, int[] ganglinie) {
        String glstring = name + ": ";
        for (int i = 0; i < ganglinie.length; ++i) {
            if (i > 0) {
                glstring = glstring + ", ";
            }
            glstring = glstring + String.valueOf(ganglinie[i]);
        }
        System.out.println(glstring);
    }

    @Test
    public void testGanglinien1() {
        try {
            System.out.println("Die Ganglinien der Baustellen werden abgefragt!");
            MessQuerschnittAllgemein mqa = (MessQuerschnittAllgemein)ObjektFactory.getInstanz().getModellobjekt(IsisTests.konfig.getString("GanglinieMQ"));
            Assert.assertNotNull((Object)mqa);
            MessQuerschnitt mq = new MessQuerschnitt(mqa);
            Assert.assertNotNull((Object)mq);
            System.out.println("TEST-MQ: " + mq.getPid());
            GregorianCalendar start = new GregorianCalendar();
            start.set(5, 1);
            start.set(2, 0);
            start.set(1, 1970);
            start.set(11, 1);
            start.set(12, 0);
            start.set(13, 0);
            start.set(14, 0);
            GregorianCalendar ende = (GregorianCalendar)start.clone();
            ende.add(5, 2);
            System.out.println("Start: " + DateFormat.getDateTimeInstance().format(new Date(start.getTimeInMillis())));
            System.out.println("Ende:  " + DateFormat.getDateTimeInstance().format(new Date(ende.getTimeInMillis())));
            GanglinienInterface[] gli = mq.getGanglinien(start.getTimeInMillis(), ende.getTimeInMillis());
            this.printGanglinien(gli);
            System.out.println("Die Ganglinien wurden abgefragt");
        }
        catch (BisInterfaceException e) {
            System.err.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGanglinien2() {
        try {
            System.out.println("Die Ganglinien der Baustellen werden abgefragt!");
            MessQuerschnittAllgemein mqa = (MessQuerschnittAllgemein)ObjektFactory.getInstanz().getModellobjekt(IsisTests.konfig.getString("GanglinieMQ"));
            Assert.assertNotNull((Object)mqa);
            MessQuerschnitt mq = new MessQuerschnitt(mqa);
            Assert.assertNotNull((Object)mq);
            System.out.println("TEST-MQ: " + mq.getPid());
            GregorianCalendar start = new GregorianCalendar();
            start.add(5, -2);
            start.set(11, 0);
            start.set(12, 0);
            start.set(13, 0);
            start.set(14, 0);
            GregorianCalendar ende = new GregorianCalendar();
            ende.add(5, 2);
            ende.set(11, 24);
            ende.set(12, 0);
            ende.set(13, 0);
            ende.set(14, 0);
            this.anlegenEreignis(start, ende);
            this.gangLinieAnlegen((MessQuerschnittInterface)mq);
            System.out.println("Start: " + DateFormat.getDateTimeInstance().format(new Date(start.getTimeInMillis())));
            System.out.println("Ende:  " + DateFormat.getDateTimeInstance().format(new Date(ende.getTimeInMillis())));
            GanglinienInterface[] gli = mq.getGanglinien(start.getTimeInMillis(), ende.getTimeInMillis());
            this.printGanglinien(gli);
            System.out.println("Die Ganglinien wurden abgefragt");
        }
        catch (BisInterfaceException e) {
            System.err.println(e.getMessage());
        }
        catch (ConfigurationChangeException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (AnmeldeException e) {
            e.printStackTrace();
        }
        catch (DatensendeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.ereignis != null) {
                try {
                    PdGanglinie g = (PdGanglinie)this.mq.getParameterDatensatz(PdGanglinie.class);
                    PdGanglinie.Daten gd = (PdGanglinie.Daten)g.abrufenDatum();
                    Iterator git = gd.iterator();
                    while (git.hasNext()) {
                        GanglinieMQ gmq = (GanglinieMQ)git.next();
                        if (!this.ereignis.getEreignisTyp().equals((Object)gmq.getEreignisTyp())) continue;
                        git.remove();
                    }
                    Ereigniskalender.getInstanz().loeschen(this.ereignis);
                }
                catch (ConfigurationChangeException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

