/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.MessQuerschnittInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestISB1 {
    String anfangsKnoten = "7912009K";
    String endKnoten = "7912009J";
    double maxStationierung = 284.0;

    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen, Testfall ISB 1");
    }

    public void testISB_ASB(String anfangsKnoten, String endKnoten, long stationierung, NetzInterface.ASBStationierungsRichtung asbRichtung) throws BisInterfaceException {
        System.out.println("Test Referenzierungsumrechnung ASB in Segment und Offset");
        System.out.println("Anfangsknoten: " + anfangsKnoten);
        System.out.println("Endknoten:     " + endKnoten);
        System.out.println("Stationierung: " + stationierung);
        System.out.println("Richtung:      " + asbRichtung);
        OrtsReferenzAsbStationierung oref = new OrtsReferenzAsbStationierung(anfangsKnoten, endKnoten, asbRichtung, stationierung);
        Assert.assertNotNull((Object)oref);
        List orefkonv = oref.ermittleOrtsReferenzStrassenSegmentUndOffset();
        int i = 0;
        for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : orefkonv) {
            System.out.println("Ortsreferenz " + ++i + ":");
            System.out.println("Segment: " + ref.getStrassenSegment().getPid());
            System.out.println("Offset:  " + ref.getStartOffset());
            MessQuerschnittInterface mq = ref.getZuflussMessQuerschnitt();
            if (mq != null) {
                System.out.println("Zufluss-MQ: " + mq.getPid() + " (" + mq.getName() + ")");
                continue;
            }
            System.out.println("Kein Zufluss-MQ!");
        }
        System.out.println();
    }

    @Test
    public void testISB1() {
        try {
            this.testISB_ASB(this.anfangsKnoten, this.endKnoten, 0L, NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG);
        }
        catch (BisInterfaceException e) {
            System.out.println(e.getMessage());
        }
        try {
            this.testISB_ASB(this.anfangsKnoten, this.endKnoten, (long)this.maxStationierung, NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG);
        }
        catch (BisInterfaceException e) {
            System.out.println(e.getMessage());
        }
        try {
            this.testISB_ASB(this.anfangsKnoten, this.endKnoten, 0L, NetzInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG);
        }
        catch (BisInterfaceException e) {
            System.out.println(e.getMessage());
        }
        try {
            this.testISB_ASB(this.anfangsKnoten, this.endKnoten, (long)this.maxStationierung, NetzInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG);
        }
        catch (BisInterfaceException e) {
            System.out.println(e.getMessage());
        }
    }
}

