/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface;
import de.bsvrz.kex.isis.isis.BisInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestISB2 {
    OrtsReferenzAsbStationierung isbAsbFehler1 = new OrtsReferenzAsbStationierung("6417028", "6517065", NetzInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG, 0L);
    int isbAsbFehler1Laenge = 1100;
    OrtsReferenzAsbStationierung isbAsbFehler2 = new OrtsReferenzAsbStationierung("6724061", "6824069", NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, 3690L);
    int isbAsbFehler2Laenge = 3300;
    OrtsReferenzAsbStationierung isbAsbFehler4 = new OrtsReferenzAsbStationierung("6417061", "6517059", NetzInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG, 0L);
    int isbAsbFehler4Laenge = 7000;
    OrtsReferenzAsbStationierung isbAsbFehler5 = new OrtsReferenzAsbStationierung("6824069", "6825049", NetzInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG, 0L);
    int isbAsbFehler5Laenge = 3300;

    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen, Testfall ISB 2");
    }

    public void testIsbBaustelle(OrtsReferenzAsbStationierung asbref, int laenge, String name, BaustellenVerantwortlicherInterface verantw) throws BisInterfaceException {
        System.out.println("Test Referenzierungsumrechnung ASB in Segment und Offset");
        System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
        System.out.println("Endknoten:     " + asbref.getEndKnoten());
        System.out.println("Stationierung: " + asbref.getStationierung());
        System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
        List oref = null;
        try {
            oref = asbref.ermittleOrtsReferenzStrassenSegmentUndOffset();
        }
        catch (BisInterfaceException e) {
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)oref);
        int i = 0;
        for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : oref) {
            String bname = name + ++i;
            System.out.println("Ortsreferenz " + i + ":");
            System.out.println("Segment: " + ref.getStrassenSegment().getPid());
            System.out.println("Offset:  " + ref.getStartOffset());
            IsisTests.bisTest.erzeugeBaustelle(bname, bname, bname, System.currentTimeMillis(), 0L, ref, laenge, BisInterface.BaustellenZustand.GUELTIG, 0, verantw);
            System.out.println("Baustelle: " + bname + " angelegt!");
        }
        System.out.println();
    }

    @Test
    public void testISB1() {
        BaustellenVerantwortlicherInterface v = IsisTests.bisTest.erzeugeBaustellenVerantwortlichen("firma", "verantwortlicher", "tel", "telf", "telmob");
        try {
            this.testIsbBaustelle(this.isbAsbFehler5, this.isbAsbFehler5Laenge, "Fehler_5_", v);
        }
        catch (BisInterfaceException e) {
            System.out.println(e.getMessage());
        }
    }
}

