/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.StrasseInterface;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrasseUndBetriebsKilometer;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOrtsReferenzen {
    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("BW-ISIS-Pr\u00fcfungen, Testfall Umrechung Ortsreferenzen");
    }

    @Test
    public void testErmittleOrtsReferenzStrassenSegmentUndOffsetAusSBK() {
        try {
            String strassenPid = IsisTests.konfig.getString("Strasse");
            long bkm = Long.parseLong(IsisTests.konfig.getString("Betriebskilometer"));
            int blocknummer = Integer.parseInt(IsisTests.konfig.getString("Blocknummer"));
            String richtung = IsisTests.konfig.getString("Fahrtrichtung");
            NetzInterface.FahrtRichtung fahrtRichtung = null;
            if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
                fahrtRichtung = NetzInterface.FahrtRichtung.IN_RICHTUNG;
            } else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
                fahrtRichtung = NetzInterface.FahrtRichtung.GEGEN_RICHTUNG;
            } else {
                Assert.fail((String)("Die Fahrtrichtungsangabe '" + richtung + "' ist nicht zul\u00e4ssig"));
            }
            StrasseInterface strasse = IsisTests.bisTest.getStrasse(strassenPid);
            Assert.assertNotNull((Object)strasse);
            OrtsReferenzStrasseUndBetriebsKilometer oref = new OrtsReferenzStrasseUndBetriebsKilometer(strasse, fahrtRichtung, bkm, blocknummer);
            Assert.assertNotNull((Object)oref);
            OrtsReferenzStrassenSegmentUndOffsetInterface orefkonv = oref.ermittleOrtsReferenzStrassenSegmentUndOffset();
            String segment = IsisTests.konfig.getString("Segment");
            long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
            Assert.assertEquals((Object)segment, (Object)orefkonv.getStrassenSegment().getPid());
            Assert.assertEquals((Object)159L, (Object)orefkonv.getStartOffset());
        }
        catch (BisInterfaceException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=BisInterfaceException.class)
    public void testErmittleOrtsReferenzStrassenSegmentUndOffsetAusSBK_FehlerStrasse() throws BisInterfaceException {
        System.out.println();
        System.out.println("Die Orte der Baustellen werden auf ung\u00fcltige Werte ge\u00e4ndert");
        String strassenPid = "A999";
        long bkm = Long.parseLong(IsisTests.konfig.getString("Betriebskilometer"));
        int blocknummer = Integer.parseInt(IsisTests.konfig.getString("Blocknummer"));
        String richtung = IsisTests.konfig.getString("Fahrtrichtung");
        NetzInterface.FahrtRichtung fahrtRichtung = null;
        if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
            fahrtRichtung = NetzInterface.FahrtRichtung.IN_RICHTUNG;
        } else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
            fahrtRichtung = NetzInterface.FahrtRichtung.GEGEN_RICHTUNG;
        } else {
            Assert.fail((String)("Die Fahrtrichtungsangabe '" + richtung + "' ist nicht zul\u00e4ssig"));
        }
        StrasseInterface strasse = IsisTests.bisTest.getStrasse(strassenPid);
        Assert.assertNotNull((Object)strasse);
    }

    @Test(expected=BisInterfaceException.class)
    public void testErmittleOrtsReferenzStrassenSegmentUndOffsetAusSBK_FehlerBetriebskilometer() throws BisInterfaceException {
        String strassenPid = IsisTests.konfig.getString("Strasse");
        long bkm = 1L;
        int blocknummer = Integer.parseInt(IsisTests.konfig.getString("Blocknummer"));
        String richtung = IsisTests.konfig.getString("Fahrtrichtung");
        NetzInterface.FahrtRichtung fahrtRichtung = null;
        if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
            fahrtRichtung = NetzInterface.FahrtRichtung.IN_RICHTUNG;
        } else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
            fahrtRichtung = NetzInterface.FahrtRichtung.GEGEN_RICHTUNG;
        } else {
            Assert.fail((String)("Die Fahrtrichtungsangabe '" + richtung + "' ist nicht zul\u00e4ssig"));
        }
        StrasseInterface strasse = IsisTests.bisTest.getStrasse(strassenPid);
        Assert.assertNotNull((Object)strasse);
        OrtsReferenzStrasseUndBetriebsKilometer oref = new OrtsReferenzStrasseUndBetriebsKilometer(strasse, fahrtRichtung, bkm, blocknummer);
        Assert.assertNotNull((Object)oref);
        OrtsReferenzStrassenSegmentUndOffsetInterface orefkonv = oref.ermittleOrtsReferenzStrassenSegmentUndOffset();
        String segment = IsisTests.konfig.getString("Segment");
        long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
        Assert.assertEquals((Object)segment, (Object)orefkonv.getStrassenSegment().getPid());
        Assert.assertEquals((Object)159, (Object)orefkonv.getStartOffset());
    }

    @Test
    public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusSSO() {
        try {
            String segment = IsisTests.konfig.getString("Segment");
            long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
            System.out.println("Test Referenzierungsumrechnung Segment " + segment + ", Offset " + offset + " in Stra\u00dfe und Betriebskilometer");
            OrtsReferenzStrassenSegmentUndOffset oref = new OrtsReferenzStrassenSegmentUndOffset(segment, offset);
            Assert.assertNotNull((Object)oref);
            OrtsReferenzStrasseUndBetriebsKilometerInterface ref = oref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
            System.out.println("ermittelte Ortsreferenz:");
            System.out.println("Strasse:            " + ref.getStrasse().getName());
            System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
            System.out.println("Blocknummer:        " + ref.getBlockNummer());
            Assert.assertEquals((Object)ref.getStrasse().getPid(), (Object)IsisTests.konfig.getString("Strasse"));
            Assert.assertEquals((Object)588841L, (Object)ref.getBetriebsKilometer());
            Assert.assertEquals((Object)ref.getBlockNummer(), (Object)Integer.parseInt(IsisTests.konfig.getString("Blocknummer")));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }

    @Test(expected=BisInterfaceException.class)
    public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusSSO_FehlerSegment() throws BisInterfaceException {
        String segment = "ass.n.55555.n.55554.0";
        long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
        System.out.println("Test Referenzierungsumrechnung Segment " + segment + ", Offset " + offset + " in Stra\u00dfe und Betriebskilometer");
        OrtsReferenzStrassenSegmentUndOffset oref = new OrtsReferenzStrassenSegmentUndOffset(segment, offset);
        Assert.assertNotNull((Object)oref);
        OrtsReferenzStrasseUndBetriebsKilometerInterface ref = oref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
        System.out.println("ermittelte Ortsreferenz:");
        System.out.println("Strasse:            " + ref.getStrasse().getName());
        System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
        System.out.println("Blocknummer:        " + ref.getBlockNummer());
        Assert.assertEquals((Object)ref.getStrasse().getPid(), (Object)IsisTests.konfig.getString("Strasse"));
        Assert.assertEquals((Object)588841, (Object)ref.getBetriebsKilometer());
        Assert.assertEquals((Object)ref.getBlockNummer(), (Object)Integer.parseInt(IsisTests.konfig.getString("Blocknummer")));
    }

    @Test(expected=BisInterfaceException.class)
    public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusSSO_FehlerOffset() throws BisInterfaceException {
        String segment = IsisTests.konfig.getString("Segment");
        long offset = 100000L;
        System.out.println("Test Referenzierungsumrechnung Segment " + segment + ", Offset " + offset + " in Stra\u00dfe und Betriebskilometer");
        OrtsReferenzStrassenSegmentUndOffset oref = new OrtsReferenzStrassenSegmentUndOffset(segment, offset);
        Assert.assertNotNull((Object)oref);
        OrtsReferenzStrasseUndBetriebsKilometerInterface ref = oref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
        System.out.println("ermittelte Ortsreferenz:");
        System.out.println("Strasse:            " + ref.getStrasse().getName());
        System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
        System.out.println("Blocknummer:        " + ref.getBlockNummer());
        Assert.assertEquals((Object)ref.getStrasse().getPid(), (Object)IsisTests.konfig.getString("Strasse"));
        Assert.assertEquals((Object)588841, (Object)ref.getBetriebsKilometer());
        Assert.assertEquals((Object)ref.getBlockNummer(), (Object)Integer.parseInt(IsisTests.konfig.getString("Blocknummer")));
    }

    @Test
    public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusASB() {
        try {
            String anfangsknoten = IsisTests.konfig.getString("Anfangsknoten");
            String endknoten = IsisTests.konfig.getString("Endknoten");
            long stationierung = Long.parseLong(IsisTests.konfig.getString("Stationierung"));
            System.out.println("Test Referenzierungsumrechnung ASB in Strasse und Betriebskilometer");
            System.out.println("Anfangsknoten: " + anfangsknoten);
            System.out.println("Endknoten:     " + endknoten);
            System.out.println("Stationierung: " + stationierung);
            OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(anfangsknoten, endknoten, NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, stationierung);
            Assert.assertNotNull((Object)asbref);
            List soref = asbref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
            Assert.assertNotNull((Object)soref);
            for (OrtsReferenzStrasseUndBetriebsKilometerInterface ref : soref) {
                System.out.println("ermittelte Ortsreferenz:");
                System.out.println("Strasse:            " + ref.getStrasse().getPid());
                System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
                System.out.println("Blocknummer:        " + ref.getBlockNummer());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }

    @Test(expected=BisInterfaceException.class)
    public void testErmittleOrtsReferenzStrasseUndBetriebskilometerAusASB_FehlerStationierung() throws BisInterfaceException {
        String anfangsknoten = IsisTests.konfig.getString("Anfangsknoten");
        String endknoten = IsisTests.konfig.getString("Endknoten");
        long stationierung = 10000L;
        System.out.println("Test Referenzierungsumrechnung ASB in Strasse und Betriebskilometer");
        System.out.println("Anfangsknoten: " + anfangsknoten);
        System.out.println("Endknoten:     " + endknoten);
        System.out.println("Stationierung: " + stationierung);
        OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(anfangsknoten, endknoten, NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, stationierung);
        Assert.assertNotNull((Object)asbref);
        List soref = asbref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
        Assert.assertNotNull((Object)soref);
        for (OrtsReferenzStrasseUndBetriebsKilometerInterface ref : soref) {
            System.out.println("ermittelte Ortsreferenz:");
            System.out.println("Strasse:            " + ref.getStrasse().getPid());
            System.out.println("Betriebskilometer:  " + ref.getBetriebsKilometer());
            System.out.println("Blocknummer:        " + ref.getBlockNummer());
        }
    }

    @Test
    public void testErmittleOrtsReferenzStrassenSegmentUndOffsetAusASB() {
        try {
            String anfangsKnoten = IsisTests.konfig.getString("Anfangsknoten");
            String endKnoten = IsisTests.konfig.getString("Endknoten");
            long stationierung = Long.parseLong(IsisTests.konfig.getString("Stationierung"));
            String richtung = IsisTests.konfig.getString("StationierungsRichtung");
            NetzInterface.ASBStationierungsRichtung asbRichtung = null;
            if (richtung.equalsIgnoreCase("IN_STATIONIERUNGSRICHTUNG")) {
                asbRichtung = NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG;
            } else if (richtung.equalsIgnoreCase("GEGEN_STATIONIERUNGSRICHTUNG")) {
                asbRichtung = NetzInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG;
            } else {
                Assert.fail((String)("Die ASB-Stationierungsrichtung '" + richtung + "' ist nicht zul\u00e4ssig"));
            }
            System.out.println("Test Referenzierungsumrechnung ASB in Segment und Offset");
            System.out.println("Anfangsknoten: " + anfangsKnoten);
            System.out.println("Endknoten:     " + endKnoten);
            System.out.println("Stationierung: " + stationierung);
            System.out.println("Richtung:      " + asbRichtung);
            OrtsReferenzAsbStationierung oref = new OrtsReferenzAsbStationierung(anfangsKnoten, endKnoten, asbRichtung, stationierung);
            Assert.assertNotNull((Object)oref);
            List orefkonv = oref.ermittleOrtsReferenzStrassenSegmentUndOffset();
            for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : orefkonv) {
                System.out.println("Ortsreferenz:");
                System.out.println("Segment: " + ref.getStrassenSegment().getPid());
                System.out.println("Offset:  " + ref.getStartOffset());
            }
            String segment = IsisTests.konfig.getString("Segment");
            long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
            Assert.assertEquals((Object)1, (Object)orefkonv.size());
            Assert.assertEquals((Object)segment, (Object)((OrtsReferenzStrassenSegmentUndOffsetInterface)orefkonv.get(0)).getStrassenSegment().getPid());
            Assert.assertEquals((Object)999L, (Object)((OrtsReferenzStrassenSegmentUndOffsetInterface)orefkonv.get(0)).getStartOffset());
        }
        catch (BisInterfaceException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testErmittleOrtsReferenzASBausSSO() {
        try {
            String segment = IsisTests.konfig.getString("Segment");
            long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
            System.out.println("Test Referenzierungsumrechnung Segment " + segment + ", Offset " + offset + " in ASB-Stationierung");
            OrtsReferenzStrassenSegmentUndOffset oref = new OrtsReferenzStrassenSegmentUndOffset(segment, offset);
            Assert.assertNotNull((Object)oref);
            OrtsReferenzAsbStationierungInterface asbref = oref.ermittleOrtsReferenzAsbStationierung();
            System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
            System.out.println("Endknoten:     " + asbref.getEndKnoten());
            System.out.println("Stationierung: " + asbref.getStationierung());
            System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
            Assert.assertEquals((Object)"6617008O", (Object)asbref.getAnfangsKnoten());
            Assert.assertEquals((Object)"6717023", (Object)asbref.getEndKnoten());
            Assert.assertEquals((Object)1118L, (Object)asbref.getStationierung());
            Assert.assertEquals((Object)NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, (Object)asbref.getAsbStationierungsRichtung());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }

    @Test(expected=BisInterfaceException.class)
    public void testErmittleOrtsReferenzASBausSSO_FehlerSegment() throws BisInterfaceException {
        String segment = "ass.n.55555.n.55554.0";
        long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
        System.out.println("Test Referenzierungsumrechnung Segment " + segment + ", Offset " + offset + " in ASB-Stationierung");
        OrtsReferenzStrassenSegmentUndOffset oref = new OrtsReferenzStrassenSegmentUndOffset(segment, offset);
        Assert.assertNotNull((Object)oref);
        OrtsReferenzAsbStationierungInterface asbref = oref.ermittleOrtsReferenzAsbStationierung();
        System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
        System.out.println("Endknoten:     " + asbref.getEndKnoten());
        System.out.println("Stationierung: " + asbref.getStationierung());
        System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
        Assert.assertEquals((Object)"6617008O", (Object)asbref.getAnfangsKnoten());
        Assert.assertEquals((Object)"6717023", (Object)asbref.getEndKnoten());
        Assert.assertEquals((Object)1118, (Object)asbref.getStationierung());
        Assert.assertEquals((Object)NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, (Object)asbref.getAsbStationierungsRichtung());
    }

    @Test(expected=BisInterfaceException.class)
    public void testErmittleOrtsReferenzASBausSSO_FehlerOffset() throws BisInterfaceException {
        String segment = IsisTests.konfig.getString("Segment");
        long offset = 10000L;
        System.out.println("Test Referenzierungsumrechnung Segment " + segment + ", Offset " + offset + " in ASB-Stationierung");
        OrtsReferenzStrassenSegmentUndOffset oref = new OrtsReferenzStrassenSegmentUndOffset(segment, offset);
        Assert.assertNotNull((Object)oref);
        OrtsReferenzAsbStationierungInterface asbref = oref.ermittleOrtsReferenzAsbStationierung();
        System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
        System.out.println("Endknoten:     " + asbref.getEndKnoten());
        System.out.println("Stationierung: " + asbref.getStationierung());
        System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
        Assert.assertEquals((Object)"6617008O", (Object)asbref.getAnfangsKnoten());
        Assert.assertEquals((Object)"6717023", (Object)asbref.getEndKnoten());
        Assert.assertEquals((Object)1118, (Object)asbref.getStationierung());
        Assert.assertEquals((Object)NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG, (Object)asbref.getAsbStationierungsRichtung());
    }

    @Test
    public void testErmittleOrtsReferenzASBausSBK() {
        try {
            String strassenPid = IsisTests.konfig.getString("Strasse");
            long bkm = Long.parseLong(IsisTests.konfig.getString("Betriebskilometer"));
            int blocknummer = Integer.parseInt(IsisTests.konfig.getString("Blocknummer"));
            String richtung = IsisTests.konfig.getString("Fahrtrichtung");
            NetzInterface.FahrtRichtung fahrtRichtung = null;
            if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
                fahrtRichtung = NetzInterface.FahrtRichtung.IN_RICHTUNG;
            } else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
                fahrtRichtung = NetzInterface.FahrtRichtung.GEGEN_RICHTUNG;
            } else {
                Assert.fail((String)("Die Fahrtrichtungsangabe '" + richtung + "' ist nicht zul\u00e4ssig"));
            }
            StrasseInterface strasse = IsisTests.bisTest.getStrasse(strassenPid);
            Assert.assertNotNull((Object)strasse);
            OrtsReferenzStrasseUndBetriebsKilometer oref = new OrtsReferenzStrasseUndBetriebsKilometer(strasse, fahrtRichtung, bkm, blocknummer);
            Assert.assertNotNull((Object)oref);
            OrtsReferenzAsbStationierungInterface asbref = oref.ermittleOrtsReferenzAsbStationierung();
            System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
            System.out.println("Endknoten:     " + asbref.getEndKnoten());
            System.out.println("Stationierung: " + asbref.getStationierung());
            System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }
}

