/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.StrasseInterface;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrasseUndBetriebsKilometer;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSBKinASB {
    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
    }

    @Test
    public void testUmrechnung() {
        try {
            String strassenPid = IsisTests.konfig.getString("Strasse");
            long bkm = Long.parseLong(IsisTests.konfig.getString("Betriebskilometer"));
            int blocknummer = Integer.parseInt(IsisTests.konfig.getString("Blocknummer"));
            String richtung = IsisTests.konfig.getString("Fahrtrichtung");
            NetzInterface.FahrtRichtung fahrtRichtung = null;
            if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
                fahrtRichtung = NetzInterface.FahrtRichtung.IN_RICHTUNG;
            } else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
                fahrtRichtung = NetzInterface.FahrtRichtung.GEGEN_RICHTUNG;
            } else {
                Assert.fail((String)("Die Fahrtrichtungsangabe '" + richtung + "' ist nicht zul\u00e4ssig"));
            }
            StrasseInterface strasse = IsisTests.bisTest.getStrasse(strassenPid);
            Assert.assertNotNull((Object)strasse);
            OrtsReferenzStrasseUndBetriebsKilometer oref = new OrtsReferenzStrasseUndBetriebsKilometer(strasse, fahrtRichtung, bkm, blocknummer);
            Assert.assertNotNull((Object)oref);
            OrtsReferenzAsbStationierungInterface asbref = oref.ermittleOrtsReferenzAsbStationierung();
            System.out.println("Anfangsknoten: " + asbref.getAnfangsKnoten());
            System.out.println("Endknoten:     " + asbref.getEndKnoten());
            System.out.println("Stationierung: " + asbref.getStationierung());
            System.out.println("Richtung:      " + asbref.getAsbStationierungsRichtung());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }
}

