/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.IsisTests;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.StrasseInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSBKinSSO {
    @BeforeClass
    public static void beforeClass() throws Exception {
        IsisTests.init();
    }

    @Test
    public void testUmrechnung() {
        try {
            String strassepid = IsisTests.konfig.getString("Strasse");
            long betriebskilometer = Long.parseLong(IsisTests.konfig.getString("Betriebskilometer"));
            int blocknummer = Integer.parseInt(IsisTests.konfig.getString("Blocknummer"));
            String segment = IsisTests.konfig.getString("Segment");
            long offset = Long.parseLong(IsisTests.konfig.getString("Offset"));
            String richtung = IsisTests.konfig.getString("Fahrtrichtung");
            NetzInterface.FahrtRichtung fahrtRichtung = null;
            if (richtung.equalsIgnoreCase("IN_RICHTUNG")) {
                fahrtRichtung = NetzInterface.FahrtRichtung.IN_RICHTUNG;
            } else if (richtung.equalsIgnoreCase("GEGEN_RICHTUNG")) {
                fahrtRichtung = NetzInterface.FahrtRichtung.GEGEN_RICHTUNG;
            } else {
                Assert.fail((String)("Die Fahrtrichtungsangabe '" + richtung + "' ist nicht zul\u00e4ssig"));
            }
            System.out.println("Test Referenzierungsumrechnung Strasse " + strassepid + ", Betriebskilometer " + betriebskilometer);
            StrasseInterface strasse = IsisTests.bisTest.getStrasse(strassepid);
            Assert.assertNotNull((Object)strasse);
            OrtsReferenzStrasseUndBetriebsKilometerInterface oref = IsisTests.bisTest.erzeugeOrtsReferenz(strasse, fahrtRichtung, betriebskilometer, blocknummer);
            Assert.assertNotNull((Object)oref);
            OrtsReferenzStrassenSegmentUndOffsetInterface ref = oref.ermittleOrtsReferenzStrassenSegmentUndOffset();
            System.out.println("ermittelte Ortsreferenz:");
            System.out.println("Segment: " + ref.getStrassenSegment().getPid());
            System.out.println("Offset:  " + ref.getStartOffset());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Assert.fail();
        }
    }
}

