/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface;
import de.bsvrz.kex.isis.isis.BisInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Punkt;
import de.bsvrz.sys.funclib.bitctrl.geometrie.Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.StrassenTeilSegment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TesteBaustelleAnlegenMitASB
extends AbstractBIS {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void TestBaustelleAnlegen() {
        String propfilename = "de/bsvrz/kex/isis/isis.properties";
        try {
            File propfile = new File(ClassLoader.getSystemResource("de/bsvrz/kex/isis/isis.properties").getFile());
            this.init(propfile.getAbsolutePath());
            BaustellenVerantwortlicherInterface v = this.erzeugeBaustellenVerantwortlichen("firma", "verantwortlicher", "tel", "telf", "telmob");
            int dauer = 86400000;
            String Anfangsknoten = "8211024";
            String Endknoten = "8311029";
            long Stationierung = 2000L;
            NetzInterface.ASBStationierungsRichtung richtung = NetzInterface.ASBStationierungsRichtung.GEGEN_STATIONIERUNGSRICHTUNG;
            OrtsReferenzAsbStationierung asbref = new OrtsReferenzAsbStationierung(Anfangsknoten, Endknoten, richtung, Stationierung);
            Assert.assertNotNull((Object)asbref);
            List soref = asbref.ermittleOrtsReferenzStrassenSegmentUndOffset();
            Assert.assertNotNull((Object)soref);
            System.out.println("Baustelle 'TestbaustelleASB_ISR' wird angelegt");
            for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : soref) {
                System.out.println("Ortsreferenz:");
                System.out.println("Segment: " + ref.getStrassenSegment().getPid() + " Offset: " + ref.getStartOffset());
            }
            this.printPunkt((OrtsReferenzStrassenSegmentUndOffset)soref.get(0));
            long bid = this.erzeugeBaustelle("TestbaustelleASB_ISR", "TestbaustelleASB_ISR", null, System.currentTimeMillis(), dauer, (OrtsReferenzStrassenSegmentUndOffsetInterface)soref.get(0), 1L, BisInterface.BaustellenZustand.GUELTIG, 200, v);
            richtung = NetzInterface.ASBStationierungsRichtung.IN_STATIONIERUNGSRICHTUNG;
            asbref = new OrtsReferenzAsbStationierung(Anfangsknoten, Endknoten, richtung, Stationierung);
            Assert.assertNotNull((Object)asbref);
            soref = asbref.ermittleOrtsReferenzStrassenSegmentUndOffset();
            Assert.assertNotNull((Object)soref);
            System.out.println("Baustelle 'TestbaustelleASB_GSR' wird angelegt");
            for (OrtsReferenzStrassenSegmentUndOffsetInterface ref : soref) {
                System.out.println("Ortsreferenz:");
                System.out.println("Segment: " + ref.getStrassenSegment().getPid() + " Offset: " + ref.getStartOffset());
            }
            this.printPunkt((OrtsReferenzStrassenSegmentUndOffset)soref.get(0));
            bid = this.erzeugeBaustelle("TestbaustelleASB_GSR", "TestbaustelleASB_GSR", null, System.currentTimeMillis(), dauer, (OrtsReferenzStrassenSegmentUndOffsetInterface)soref.get(0), 1L, BisInterface.BaustellenZustand.GUELTIG, 200, v);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BisInterfaceException e) {
            System.err.println(e.getMessage());
        }
    }

    private void printPunkt(OrtsReferenzStrassenSegmentUndOffset ref) {
        System.out.println("Ortsreferenz:");
        System.out.println("Segment: " + ref.getStrassenSegment().getPid() + " Offset: " + ref.getStartOffset());
        ArrayList<WGS84Punkt> koord = new ArrayList<WGS84Punkt>();
        for (StrassenTeilSegment sts : ref.getModelSegment().getStrassenTeilSegmente()) {
            for (Punkt p : sts.getKoordinaten()) {
                koord.add(new WGS84Punkt(p.getX(), p.getY()));
            }
        }
        WGS84Polygon poly = new WGS84Polygon(koord);
        WGS84Punkt bp = poly.bildPunkt((double)ref.getStartOffset());
        System.out.println("WGS84Punkt: " + bp);
    }
}

