/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis;

import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TesteSegmentOffset_nach_ASB
extends AbstractBIS {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void TestSegmentOffset_nach_ASB() {
        String propfilename = "de/bsvrz/kex/isis/isis.properties";
        try {
            File propfile = new File(ClassLoader.getSystemResource("de/bsvrz/kex/isis/isis.properties").getFile());
            this.init(propfile.getAbsolutePath());
            String segment = "ass.n.11607.n.11606.0";
            long offset = 2926L;
            System.out.println("Teste Segment: " + segment + ", Offset: " + offset);
            OrtsReferenzStrassenSegmentUndOffsetInterface oref = this.erzeugeOrtsReferenz(segment, offset);
            Assert.assertNotNull((Object)oref);
            OrtsReferenzAsbStationierungInterface asb = oref.ermittleOrtsReferenzAsbStationierung();
            System.out.println("ASB-Stationierung:");
            System.out.println("Anfangsknoten: " + asb.getAnfangsKnoten() + " Endknoten: " + asb.getEndKnoten());
            System.out.println("Stationierung: " + asb.getStationierung() + " Verkehrsrichtung: " + asb.getAsbStationierungsRichtung());
            Assert.assertEquals((Object)"6417028", (Object)asb.getAnfangsKnoten());
            Assert.assertEquals((Object)"6517065", (Object)asb.getEndKnoten());
            OrtsReferenzStrasseUndBetriebsKilometerInterface sbk = oref.ermittleOrtsReferenzStrasseUndBetriebsKilometer();
            System.out.println("Stra\u00dfe-und-Betriebskilometer-Stationierung:");
            System.out.println("Strasse: " + sbk.getStrasse().getName() + " Betriebskilometer: " + sbk.getBetriebsKilometer());
            System.out.println("Blocknummer: " + sbk.getBlockNummer() + " Fahrtrichtung: " + sbk.getFahrtRichtung());
            System.out.println("ASB-Stationierung:");
            System.out.println("Anfangsknoten: " + asb.getAnfangsKnoten() + " Endknoten: " + asb.getEndKnoten());
            System.out.println("Stationierung: " + asb.getStationierung() + " Verkehrsrichtung: " + asb.getAsbStationierungsRichtung());
            List soref = asb.ermittleOrtsReferenzStrassenSegmentUndOffset();
            for (OrtsReferenzStrassenSegmentUndOffsetInterface sorefi : soref) {
                System.out.println("Strassensegment: " + sorefi.getStrassenSegment().getPid() + ", Offset: " + sorefi.getStartOffset());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BisInterfaceException e) {
            System.err.println(e.getMessage());
        }
    }
}

