/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.dav.daf.main.ApplicationCloseActionHandler;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.CommunicationError;
import de.bsvrz.dav.daf.main.ConnectionException;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DavConnectionListener;
import de.bsvrz.dav.daf.main.InconsistentLoginException;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.DynamicObjectType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BaustelleInterface;
import de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface;
import de.bsvrz.kex.isis.isis.BisInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.BisKommunikationsStatusListener;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.StrasseInterface;
import de.bsvrz.kex.isis.isis.impl.Baustelle;
import de.bsvrz.kex.isis.isis.impl.BaustellenVerantwortlicher;
import de.bsvrz.kex.isis.isis.impl.ISISParameter;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzAsbStationierung;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrasseUndBetriebsKilometer;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;
import de.bsvrz.kex.isis.isis.impl.Strasse;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzen;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.BaustellenListener;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.VerkehrModellNetz;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.parameter.PdBaustellenEigenschaften;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.zustaende.BaustellenVeranlasser;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.dynobj.DynamischeObjekte;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBIS
implements BisInterface,
BaustellenListener,
ClientReceiverInterface {
    protected static final String DAV_KEY = "Datenverteiler";
    protected static final String BENUTZER_KEY = "Benutzer";
    protected static final String PASSWORT_KEY = "Passwort";
    private static final String NETZ_KEY = "Netz";
    protected static final String KV_KEY = "Konfigurationsverantwortlicher";
    private static final String ATTRIBUTGRUPPE_PARAMETER = "atg.parameterIsis";
    public static final String BISAPPNAME = "BIS";
    private final Map<Long, Baustelle> baustellenMap = new HashMap<Long, Baustelle>();
    private final Properties properties = new Properties();
    private ClientDavConnection dav = null;
    private DataModel config = null;
    List<BisKommunikationsStatusListener> kommStatusListener = new ArrayList<BisKommunikationsStatusListener>();
    private SystemObject kv;
    private SystemObject netzObjekt;
    VerkehrModellNetz netzmodell;
    Object initLock = new Object();
    BisInterface.BisKommunikationsStatus kommStatus = BisInterface.BisKommunikationsStatus.BIS_KOMMUNIKATION_FEHLER;
    private boolean initialisiert = false;
    private DataDescription paramEmpfang;
    private final long warteZeitAnmeldung = 10000L;
    private final String logName = "BIS-Interface";
    private Baustelle bLock;
    DavConnectionThread connThread = null;
    private boolean davConnectionRun = false;
    DynamischeObjekte vdo = null;
    DynamicObjectType objektTyp = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKommunikationsStatusListener(BisKommunikationsStatusListener listener) {
        List<BisKommunikationsStatusListener> list = this.kommStatusListener;
        synchronized (list) {
            this.kommStatusListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void baustelleAngelegt(VerkehrModellNetz netz, de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle baustelle) {
        baustelle.getBaustellenEigenschaften().abrufenDatum();
        if (this.bLock != null && baustelle.equals((Object)this.bLock.getModellBaustelle())) {
            this.bLock.setMengeAngemeldet(true);
            Baustelle baustelle2 = this.bLock;
            synchronized (baustelle2) {
                this.bLock.notify();
            }
            return;
        }
        if (this.istISISBaustelle(baustelle)) {
            Baustelle bisbaustelle = null;
            try {
                bisbaustelle = new Baustelle(baustelle);
                this.baustellenMap.put(new Long(baustelle.getId()), bisbaustelle);
            }
            catch (BisInterfaceException e) {
                Logger.getLogger("BIS-Interface").log(Level.WARNING, e.getMessage());
            }
        }
    }

    public void baustelleEntfernt(VerkehrModellNetz netz, de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle baustelle) {
    }

    protected void datenAnmeldenDaV() {
        SystemObject[] objekte = null;
        AttributeGroup attributeGroup = null;
        Aspect aspect = null;
        objekte = new SystemObject[]{this.kv};
        attributeGroup = this.config.getAttributeGroup(ATTRIBUTGRUPPE_PARAMETER);
        aspect = this.config.getAspect("asp.parameterSoll");
        this.paramEmpfang = new DataDescription(attributeGroup, aspect);
        this.dav.subscribeReceiver((ClientReceiverInterface)this, objekte, this.paramEmpfang, new ReceiveOptions(false), ReceiverRole.receiver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long erzeugeBaustelle(String pid, String name, String info, long vonZeitpunkt, long dauer, OrtsReferenzStrassenSegmentUndOffsetInterface ortsReferenz, long laenge, BisInterface.BaustellenZustand baustellenZustand, int engpassKapazitaet, BaustellenVerantwortlicherInterface baustellenVerantwortlicher) throws BisInterfaceException {
        if (ortsReferenz == null) {
            throw new BisInterfaceException("Die Ortsreferenz darf nicht null sein");
        }
        this.testeVerbindung();
        DynamicObject baustellenobjekt = null;
        Baustelle baustelle = null;
        long id = -1L;
        try {
            String baustellepid = pid;
            if (baustellepid == null || baustellepid.length() == 0) {
                baustellepid = Baustelle.bildeBaustellePid();
            }
            String baustellename = name;
            String baustelleinfo = info;
            if (baustelleinfo == null || baustelleinfo.length() == 0) {
                baustelleinfo = Baustelle.bildeBaustelleInfo();
            }
            if (this.config.getObject(baustellepid) != null) {
                throw new BisInterfaceException("Die Baustelle kann nicht angelegt werden, da bereits ein Objekt mit dieser PID existiert");
            }
            baustellenobjekt = this.vdo.erzeugeObjekt(this.objektTyp, baustellename, baustellepid);
            Baustelle baustelle2 = this.bLock = (baustelle = new Baustelle(baustelleinfo, vonZeitpunkt, dauer, ortsReferenz, laenge, baustellenZustand, engpassKapazitaet, baustellenVerantwortlicher, (ClientDavInterface)this.dav, (SystemObject)baustellenobjekt));
            synchronized (baustelle2) {
                this.netzmodell.baustelleHinzufuegen(baustelle.getDavObjekt());
                this.bLock.wait(10000L);
            }
            if (baustelle.istMengeAngemeldet()) {
                this.baustellenMap.put(new Long(baustelle.getId()), baustelle);
            }
            baustelle.publiziereDAV();
            id = baustelle.getId();
        }
        catch (Exception e) {
            if (baustelle != null) {
                this.loescheBaustelle(baustelle.getId());
            } else if (baustellenobjekt != null) {
                try {
                    baustellenobjekt.invalidate();
                }
                catch (ConfigurationChangeException e1) {
                    e1.printStackTrace();
                }
            }
            throw new BisInterfaceException(e);
        }
        return id;
    }

    public BaustellenVerantwortlicherInterface erzeugeBaustellenVerantwortlichen(String firma, String nameBaustellenVerantwortlicher, String telefonBaustellenVerantwortlicher, String telefonFirma, String telefonMobilBaustellenVerantwortlicher) {
        return new BaustellenVerantwortlicher(firma, nameBaustellenVerantwortlicher, telefonBaustellenVerantwortlicher, telefonFirma, telefonMobilBaustellenVerantwortlicher);
    }

    public OrtsReferenzStrasseUndBetriebsKilometerInterface erzeugeOrtsReferenz(StrasseInterface strasse, NetzInterface.FahrtRichtung fahrtRichtung, long betriebsKilometer, int blockNummer) throws BisInterfaceException {
        this.testeVerbindung();
        return new OrtsReferenzStrasseUndBetriebsKilometer(strasse, fahrtRichtung, betriebsKilometer, blockNummer);
    }

    public OrtsReferenzStrassenSegmentUndOffsetInterface erzeugeOrtsReferenz(String pidStrassenSegment, long startOffset) throws BisInterfaceException {
        this.testeVerbindung();
        return new OrtsReferenzStrassenSegmentUndOffset(pidStrassenSegment, startOffset);
    }

    public OrtsReferenzAsbStationierungInterface erzeugeOrtsReferenz(String anfangsKnoten, String endKnoten, NetzInterface.ASBStationierungsRichtung stationierungsRichtung, long stationierung) throws BisInterfaceException {
        this.testeVerbindung();
        return new OrtsReferenzAsbStationierung(anfangsKnoten, endKnoten, stationierungsRichtung, stationierung);
    }

    public BaustelleInterface getBaustelle(long baustellenId) {
        return this.baustellenMap.get(new Long(baustellenId));
    }

    public StrasseInterface getStrasse(String strassenPid) throws BisInterfaceException {
        this.testeVerbindung();
        SystemObject co = this.config.getObject(strassenPid);
        if (co == null) {
            throw new BisInterfaceException("Zur PID '" + strassenPid + "' existiert kein Strassenobjekt");
        }
        return new Strasse(co);
    }

    public StrasseInterface[] getStrassen(int strassenTyp, int strassenNummer, String zusatz) throws BisInterfaceException {
        this.testeVerbindung();
        ArrayList<Strasse> strassen = new ArrayList<Strasse>();
        for (SystemObject so : this.config.getType("typ.stra\u00dfe").getElements()) {
            Strasse strasse = new Strasse(so);
            if (!strasse.testeStrassenDaten(strassenTyp, strassenNummer, zusatz)) continue;
            strassen.add(strasse);
        }
        return strassen.toArray(new StrasseInterface[strassen.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String parameterdatei) throws FileNotFoundException, IOException, BisInterfaceException {
        this.properties.load(new FileInputStream(parameterdatei));
        this.davConnectionRun = true;
        try {
            this.connThread = new DavConnectionThread(this);
            Object object = this.initLock;
            synchronized (object) {
                this.initLock.wait();
            }
            if (this.kommStatus == BisInterface.BisKommunikationsStatus.BIS_KOMMUNIKATION_FEHLER) {
                this.connThread.interrupt();
                throw new BisInterfaceException("Die Datenverteilerverbindung konnte nicht initialisiert werden");
            }
            this.initialisiert = true;
        }
        catch (Exception e) {
            throw new BisInterfaceException(e.getMessage());
        }
    }

    public void disconnect() {
        this.davConnectionRun = false;
        this.connThread.interrupt();
        try {
            this.connThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        long timeOutTime = 5000L;
        int timeOutTimeStep = 500;
        Thread[] threadsArray = new Thread[Thread.activeCount() * 5];
        Thread.enumerate(threadsArray);
        Thread implicitUnsubscriberThread = null;
        String log = "";
        for (Thread thread : threadsArray) {
            if (thread == null) break;
            if (thread.getName().equals("ImplicitUnsubscriber")) {
                implicitUnsubscriberThread = thread;
            }
            log = log + "  " + thread + " (" + (thread.isAlive() ? "alive" : "not alive") + ")\n";
        }
        Logger.getLogger("ImplicitUnsubscriberTerminator").severe("Alle Threads\n" + log);
        if (implicitUnsubscriberThread != null && implicitUnsubscriberThread.isAlive()) {
            Logger.getLogger("ImplicitUnsubscriberTerminator").severe("ImplicitUnsubscriber: " + implicitUnsubscriberThread);
            Random r = new Random();
            long timeout = 5000L;
            while (timeout > 0L) {
                try {
                    implicitUnsubscriberThread.checkAccess();
                    timeout = -1L;
                    Logger.getLogger("ImplicitUnsubscriberTerminator").severe("Beim ersten mal unterbrochen");
                }
                catch (SecurityException ex) {
                    Logger.getLogger("ImplicitUnsubscriberTerminator").severe("Warte...");
                    long nextSleep = r.nextInt(500);
                    timeout -= nextSleep;
                    try {
                        Thread.sleep(nextSleep);
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
            implicitUnsubscriberThread.interrupt();
        }
    }

    boolean istISISBaustelle(de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle b) {
        b.getBaustellenEigenschaften().abrufenDatum();
        return ((PdBaustellenEigenschaften.Daten)b.getBaustellenEigenschaften().getDatum()).getVeranlasser() == BaustellenVeranlasser.BIS;
    }

    public void loescheBaustelle(long baustellenId) throws BisInterfaceException {
        this.testeVerbindung();
        Long key = new Long(baustellenId);
        Baustelle baustelle = this.baustellenMap.get(key);
        if (baustelle == null) {
            throw new BisInterfaceException("Zur angeforderten ID '" + baustellenId + "' existiert kein Objekt!");
        }
        this.netzmodell.baustelleEntfernen(baustelle.getDavObjekt());
        baustelle.loeschen();
        this.baustellenMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKommunikationsStatusListener(BisKommunikationsStatusListener listener) {
        List<BisKommunikationsStatusListener> list = this.kommStatusListener;
        synchronized (list) {
            this.kommStatusListener.remove(listener);
        }
    }

    private void testeVerbindung() throws BisInterfaceException {
        if (!this.initialisiert) {
            throw new BisInterfaceException("Das Interface wurde noch nicht initialisiert!");
        }
        if (this.kommStatus == BisInterface.BisKommunikationsStatus.BIS_KOMMUNIKATION_FEHLER) {
            throw new BisInterfaceException("Die Funktion kann nicht ausgef\u00fchrt werden, da keine Datenverteilerverbindung besteht!");
        }
    }

    public void update(ResultData[] results) {
        for (ResultData datensatz : results) {
            if (!datensatz.hasData() || !datensatz.getDataDescription().equals((Object)this.paramEmpfang)) continue;
            Logger.getLogger("BIS-Interface").log(Level.FINE, "Parameterdatensatz empfangen");
            ISISParameter.getInstance().aktualisieren(datensatz.getData());
            for (Baustelle baustelle : this.baustellenMap.values()) {
                baustelle.aktualisiereEreignisse();
            }
        }
    }

    private class DavConnectionThread
    extends Thread
    implements DavConnectionListener,
    ApplicationCloseActionHandler {
        private final int warteZeitNeuverbindung = 2000;
        private final AbstractBIS parent;
        private final Object commlock = new Object();

        public DavConnectionThread(AbstractBIS parent) {
            this.parent = parent;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void benachrichtigeListener() {
            List<BisKommunikationsStatusListener> list = AbstractBIS.this.kommStatusListener;
            synchronized (list) {
                for (BisKommunikationsStatusListener listener : AbstractBIS.this.kommStatusListener) {
                    listener.setKommunikationsStatus(AbstractBIS.this.kommStatus);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(String error) {
            System.err.println("Verbindung zum Datenverteiler geschlossen (ApplicationCloseActionHandler)");
            Object object = this.commlock;
            synchronized (object) {
                this.commlock.notify();
            }
        }

        private ClientDavInterface connect(String davHost, String davUsername, String davPassword) throws MissingParameterException, CommunicationError, ConnectionException, InconsistentLoginException {
            ArgumentList argList = new ArgumentList(new String[]{"-datenverteiler=" + davHost});
            ClientDavParameters cdp = new ClientDavParameters(argList);
            cdp.setApplicationName(AbstractBIS.BISAPPNAME);
            if (AbstractBIS.this.dav == null) {
                AbstractBIS.this.dav = new ClientDavConnection(cdp);
            }
            AbstractBIS.this.dav.connect();
            AbstractBIS.this.dav.login(davUsername, davPassword);
            return AbstractBIS.this.dav;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ClientDavInterface connection) {
            System.err.println("Verbindung zum Datenverteiler geschlossen!");
            Object object = this.commlock;
            synchronized (object) {
                this.commlock.notify();
            }
        }

        private void initDavConnection() throws BisInterfaceException {
            try {
                AbstractBIS.this.dav = (ClientDavConnection)this.connect(AbstractBIS.this.properties.getProperty(AbstractBIS.DAV_KEY), AbstractBIS.this.properties.getProperty(AbstractBIS.BENUTZER_KEY), AbstractBIS.this.properties.getProperty(AbstractBIS.PASSWORT_KEY));
                AbstractBIS.this.dav.setCloseHandler((ApplicationCloseActionHandler)this);
                AbstractBIS.this.config = AbstractBIS.this.dav.getDataModel();
                AbstractBIS.this.vdo = DynamischeObjekte.getInstanz((ClientDavInterface)AbstractBIS.this.dav);
                AbstractBIS.this.objektTyp = (DynamicObjectType)AbstractBIS.this.dav.getDataModel().getType("typ.baustelle");
                if (AbstractBIS.this.objektTyp == null) {
                    throw new RuntimeException("Der Typ ''typ.baustelle'' existiert nicht!");
                }
                MessageSender.getInstance().init((ClientDavInterface)AbstractBIS.this.dav, AbstractBIS.BISAPPNAME, AbstractBIS.BISAPPNAME);
                AbstractBIS.this.kv = AbstractBIS.this.config.getObject(AbstractBIS.this.properties.getProperty(AbstractBIS.KV_KEY));
                if (AbstractBIS.this.kv == null) {
                    throw new BisInterfaceException("Der Konfigurationsverantwortliche '" + AbstractBIS.this.properties.getProperty(AbstractBIS.KV_KEY) + "' kann nicht initialisiert werden");
                }
                if (!AbstractBIS.this.kv.getType().getPid().equals("typ.isis")) {
                    throw new BisInterfaceException("Der Konfigurationsverantwortliche '" + AbstractBIS.this.properties.getProperty(AbstractBIS.KV_KEY) + "' ist nicht vom Typ 'typ.isis'!");
                }
                AbstractBIS.this.datenAnmeldenDaV();
                AbstractBIS.this.netzObjekt = AbstractBIS.this.config.getObject(AbstractBIS.this.properties.getProperty(AbstractBIS.NETZ_KEY));
                if (AbstractBIS.this.netzObjekt == null) {
                    throw new BisInterfaceException("Das Netz '" + AbstractBIS.this.properties.getProperty(AbstractBIS.NETZ_KEY) + "' kann nicht initialisiert werden");
                }
                ObjektFactory.getInstanz().setVerbindung((ClientDavInterface)AbstractBIS.this.dav);
                ObjektFactory.getInstanz().registerStandardFactories();
                AbstractBIS.this.netzmodell = (VerkehrModellNetz)ObjektFactory.getInstanz().getModellobjekt(AbstractBIS.this.netzObjekt);
                NetzReferenzen.getInstanz().setNetzmodell(AbstractBIS.this.netzmodell);
                AbstractBIS.this.netzmodell.addBaustellenListener((BaustellenListener)this.parent);
                for (de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle b : AbstractBIS.this.netzmodell.getBaustellen()) {
                    if (!AbstractBIS.this.istISISBaustelle(b)) continue;
                    Logger.getLogger("BIS-Interface").log(Level.INFO, "Die existierende BIS-Baustelle: " + b.getSystemObject() + " wird intialisiert");
                    try {
                        Baustelle bisbaustelle = new Baustelle(b);
                        AbstractBIS.this.baustellenMap.put(new Long(b.getId()), bisbaustelle);
                    }
                    catch (BisInterfaceException be) {
                        Logger.getLogger("BIS-Interface").log(Level.WARNING, "Die existierende BIS-Baustelle: " + b.getSystemObject() + " kann nicht intialisiert werden (" + be.getMessage() + ")");
                    }
                }
            }
            catch (Exception e) {
                if (AbstractBIS.this.dav != null) {
                    AbstractBIS.this.dav.disconnect(false, "");
                    AbstractBIS.this.dav = null;
                }
                throw new BisInterfaceException(e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractBIS.this.initialisiert = false;
            try {
                while (AbstractBIS.this.davConnectionRun) {
                    try {
                        Object object;
                        Logger.getLogger("BIS-Interface").log(Level.INFO, "Verbindung zum Datenverteiler wird hergestellt");
                        this.initDavConnection();
                        Logger.getLogger("BIS-Interface").log(Level.INFO, "Verbindung zum Datenverteiler hergestellt");
                        this.setKommStatus(BisInterface.BisKommunikationsStatus.BIS_KOMMUNIKATION_OK);
                        if (!AbstractBIS.this.initialisiert) {
                            object = AbstractBIS.this.initLock;
                            synchronized (object) {
                                AbstractBIS.this.initLock.notify();
                            }
                        }
                        AbstractBIS.this.initialisiert = true;
                        object = this.commlock;
                        synchronized (object) {
                            this.commlock.wait();
                        }
                        this.setKommStatus(BisInterface.BisKommunikationsStatus.BIS_KOMMUNIKATION_FEHLER);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        if (!AbstractBIS.this.initialisiert) {
                            Object object = AbstractBIS.this.initLock;
                            synchronized (object) {
                                AbstractBIS.this.initLock.notify();
                                break;
                            }
                        }
                        AbstractBIS.this.initialisiert = true;
                    }
                    this.setKommStatus(BisInterface.BisKommunikationsStatus.BIS_KOMMUNIKATION_FEHLER);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e1) {}
                }
                if (AbstractBIS.this.dav != null) {
                    Logger.getLogger("BIS-Interface").log(Level.INFO, "Verbindung zum Datenverteiler wird beendet");
                    AbstractBIS.this.dav.disconnect(false, "");
                    this.setKommStatus(BisInterface.BisKommunikationsStatus.BIS_KOMMUNIKATION_FEHLER);
                    AbstractBIS.this.dav = null;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            finally {
                if (AbstractBIS.this.dav != null && AbstractBIS.this.kommStatus == BisInterface.BisKommunikationsStatus.BIS_KOMMUNIKATION_OK) {
                    AbstractBIS.this.dav.disconnect(false, "");
                }
            }
        }

        private void setKommStatus(BisInterface.BisKommunikationsStatus neuerstatus) {
            boolean notify = neuerstatus != AbstractBIS.this.kommStatus;
            AbstractBIS.this.kommStatus = neuerstatus;
            if (notify) {
                this.benachrichtigeListener();
            }
        }
    }
}

