/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BaustelleInterface;
import de.bsvrz.kex.isis.isis.BaustellenPrognoseInterface;
import de.bsvrz.kex.isis.isis.BaustellenVerantwortlicherInterface;
import de.bsvrz.kex.isis.isis.BisInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.impl.BaustellenEreignis;
import de.bsvrz.kex.isis.isis.impl.BaustellenEreignisFactory;
import de.bsvrz.kex.isis.isis.impl.BaustellenPrognose;
import de.bsvrz.kex.isis.isis.impl.BaustellenVerantwortlicher;
import de.bsvrz.kex.isis.isis.impl.ISISParameter;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.Datum;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.Ereignis;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.InneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.onlinedaten.OdBaustellenSimulation;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.parameter.PdBaustellenEigenschaften;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.parameter.PdBaustellenVerantwortlicher;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.parameter.PdSituationsEigenschaften;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.zustaende.BaustellenStatus;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.zustaende.BaustellenVeranlasser;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Baustelle
implements BaustelleInterface,
ClientSenderInterface,
DatensatzUpdateListener {
    private final String logName = "BIS-Interface";
    private OrtsReferenzStrassenSegmentUndOffsetInterface ortsReferenzBaustelle = null;
    private long laengeBaustelle = 0L;
    private BisInterface.BaustellenZustand zustandBaustelle = null;
    private String infoTextBaustelle = "";
    private ClientDavInterface dav = null;
    private SystemObject davObjekt = null;
    private final Object anmeldungsLock = new Object();
    private final de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle modellBaustelle;
    private PdSituationsEigenschaften.Daten baustellenSituationModell;
    private PdBaustellenEigenschaften.Daten baustellenEigenschaftenModell;
    private PdBaustellenVerantwortlicher.Daten baustellenVerantwortlicherModell;
    private boolean datenAngemeldet = false;
    private boolean mengeAngemeldet = false;
    private final Object prognoseLock = new Object();
    private final long warteZeitPrognose = 100000L;
    private boolean prognoseEmpfangen = false;
    private long startZeitPrognose;
    private final List<BaustellenEreignis> ereignisse = new ArrayList<BaustellenEreignis>();

    public static String bildeBaustelleInfo() {
        return "Baustelle angelegt durch ISIS-Interface";
    }

    public static String bildeBaustelleName(String baustellepid) {
        return baustellepid;
    }

    public static String bildeBaustellePid() {
        return "baustelle.isis." + System.currentTimeMillis();
    }

    public Baustelle(ClientDavInterface dav, SystemObject objekt) throws BisInterfaceException {
        this.dav = dav;
        this.davObjekt = objekt;
        this.modellBaustelle = (de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle)ObjektFactory.getInstanz().getModellobjekt(objekt);
        this.anmeldenDav();
    }

    public Baustelle(de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle baustelle) throws BisInterfaceException {
        this.modellBaustelle = baustelle;
        this.baustellenEigenschaftenModell = (PdBaustellenEigenschaften.Daten)this.modellBaustelle.getBaustellenEigenschaften().abrufenDatum();
        this.baustellenSituationModell = (PdSituationsEigenschaften.Daten)this.modellBaustelle.getSituationsEigenschaften().abrufenDatum();
        this.baustellenVerantwortlicherModell = (PdBaustellenVerantwortlicher.Daten)this.modellBaustelle.getBaustellenVerantwortlicher().abrufenDatum();
        if (this.baustellenSituationModell.getSegment(0) == null) {
            throw new BisInterfaceException("Die Baustelle besitzt kein zugeordnetes Strassensegment");
        }
        this.ortsReferenzBaustelle = new OrtsReferenzStrassenSegmentUndOffset(this.baustellenSituationModell.getSegment(0).getPid(), this.baustellenSituationModell.getStartOffset());
        this.davObjekt = baustelle.getSystemObject();
        this.anmeldenDav();
    }

    public Baustelle(String info, long vonZeitpunkt, long dauer, OrtsReferenzStrassenSegmentUndOffsetInterface ortsReferenz, long laenge, BisInterface.BaustellenZustand baustellenZustand, int engpassKapazitaet, BaustellenVerantwortlicherInterface baustellenVerantwortlicher, ClientDavInterface dav, SystemObject objekt) throws BisInterfaceException {
        this(dav, objekt);
        if (laenge < 0L) {
            throw new BisInterfaceException("Eine negative L\u00e4nge wird nicht unterst\u00fctzt");
        }
        this.laengeBaustelle = laenge;
        this.baustellenEigenschaftenModell = this.modellBaustelle.getBaustellenEigenschaften().erzeugeDatum();
        this.baustellenEigenschaftenModell.setRestKapazitaet((long)engpassKapazitaet);
        this.baustellenEigenschaftenModell.setStatus(this.getDavBaustellenStatus(baustellenZustand));
        this.baustellenEigenschaftenModell.setVeranlasser(BaustellenVeranlasser.BIS);
        this.baustellenSituationModell = this.modellBaustelle.getSituationsEigenschaften().erzeugeDatum();
        this.baustellenSituationModell.setDauer(dauer);
        this.baustellenSituationModell.setStartZeit(vonZeitpunkt);
        this.ortsReferenzBaustelle = ortsReferenz;
        this.setzeOrtsreferenz();
        this.baustellenVerantwortlicherModell = this.modellBaustelle.getBaustellenVerantwortlicher().erzeugeDatum();
        this.modellBaustelle.getBaustellenVerantwortlicher().erzeugeDatum();
        this.setzeBaustellenVerantwortlicherModell(baustellenVerantwortlicher);
        this.setBaustellenZustand(baustellenZustand);
        this.aendereInfo(info);
    }

    public void aendereBaustellenGueltigkeitsZeitraum(long vonZeitpunkt, long dauer) throws BisInterfaceException {
        this.baustellenSituationModell.setDauer(dauer);
        this.baustellenSituationModell.setStartZeit(vonZeitpunkt);
        try {
            this.publiziereDAVSituation();
        }
        catch (DatensendeException e) {
            throw new BisInterfaceException("Fehler beim Senden zum Datenverteiler: " + e.getMessage());
        }
    }

    public void aendereBaustellenOrt(OrtsReferenzStrassenSegmentUndOffsetInterface ortsReferenzNeu) throws BisInterfaceException {
        this.ortsReferenzBaustelle = ortsReferenzNeu;
        this.setzeOrtsreferenz();
        try {
            this.publiziereDAVSituation();
        }
        catch (DatensendeException e) {
            throw new BisInterfaceException("Fehler beim Senden zum Datenverteiler: " + e.getMessage());
        }
    }

    public void aendereBaustellenStartOffsetUndLaenge(long startOffset, long laenge) throws BisInterfaceException {
        this.ortsReferenzBaustelle = new OrtsReferenzStrassenSegmentUndOffset(this.ortsReferenzBaustelle.getStrassenSegment().getPid(), startOffset);
        this.laengeBaustelle = laenge;
        this.setzeOrtsreferenz();
        try {
            this.publiziereDAVSituation();
        }
        catch (DatensendeException e) {
            throw new BisInterfaceException("Fehler beim Senden zum Datenverteiler: " + e.getMessage());
        }
    }

    public void aendereBaustellenVerantwortlichen(BaustellenVerantwortlicherInterface baustellenVerantwortlicher) throws BisInterfaceException {
        this.setzeBaustellenVerantwortlicherModell(baustellenVerantwortlicher);
        try {
            this.publiziereDAVBaustellenVerantwortlicher();
        }
        catch (DatensendeException e) {
            throw new BisInterfaceException("Fehler beim Senden zum Datenverteiler: " + e.getMessage());
        }
    }

    public void aendereBaustellenZustand(BisInterface.BaustellenZustand baustellenZustand) throws BisInterfaceException {
        this.setBaustellenZustand(baustellenZustand);
        this.baustellenEigenschaftenModell.setStatus(this.getDavBaustellenStatus(this.zustandBaustelle));
        try {
            this.publiziereDAVBaustelle();
        }
        catch (DatensendeException e) {
            throw new BisInterfaceException("Fehler beim Senden zum Datenverteiler: " + e.getMessage());
        }
    }

    public void aendereEngpassKapazitaet(int engpassKapazitaet) throws BisInterfaceException {
        if (engpassKapazitaet < 0) {
            throw new BisInterfaceException("Die Engpasskapazit\u00e4t muss positiv sein");
        }
        this.baustellenEigenschaftenModell.setRestKapazitaet((long)engpassKapazitaet);
        try {
            this.publiziereDAVBaustelle();
        }
        catch (DatensendeException e) {
            throw new BisInterfaceException("Fehler beim Senden zum Datenverteiler: " + e.getMessage());
        }
    }

    public void aendereInfo(String infoText) throws BisInterfaceException {
        this.infoTextBaustelle = infoText;
        try {
            this.publiziereDAVObjektDaten();
        }
        catch (ConfigurationChangeException e) {
            throw new BisInterfaceException(e.getMessage());
        }
    }

    public void aktualisiereEreignisse() {
        ArrayList<BaustellenEreignis> geloescht = new ArrayList<BaustellenEreignis>();
        for (BaustellenEreignis ereignis : this.ereignisse) {
            if (BaustellenEreignisFactory.getInstance().istEreignis(ereignis.getZustand())) continue;
            try {
                ereignis.loeschen();
            }
            catch (ConfigurationChangeException e) {
                e.printStackTrace();
            }
            geloescht.add(ereignis);
        }
        this.ereignisse.removeAll(geloescht);
        try {
            this.erzeugeEreignis();
        }
        catch (BisInterfaceException e) {
            Logger.getLogger("BIS-Interface").log(Level.WARNING, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void anmeldenDav() throws BisInterfaceException {
        try {
            this.modellBaustelle.getSituationsEigenschaften().anmeldenSender();
            this.modellBaustelle.getBaustellenEigenschaften().anmeldenSender();
            this.modellBaustelle.getBaustellenVerantwortlicher().anmeldenSender();
            this.modellBaustelle.getSituationsEigenschaften().addUpdateListener((DatensatzUpdateListener)this);
            this.modellBaustelle.getBaustellenEigenschaften().addUpdateListener((DatensatzUpdateListener)this);
            this.modellBaustelle.getBaustellenVerantwortlicher().addUpdateListener((DatensatzUpdateListener)this);
            Object object = this.anmeldungsLock;
            synchronized (object) {
                try {
                    this.anmeldungsLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.datenAngemeldet) {
                throw new BisInterfaceException("Die Baustelle konnte nicht erfolgreich beim DaV angemeldet werden");
            }
        }
        catch (AnmeldeException e) {
            throw new BisInterfaceException(e.getMessage());
        }
    }

    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void datensatzAktualisiert(DatensatzUpdateEvent event) {
        Object object;
        if (event.getDatensatz() instanceof OdBaustellenSimulation && event.getDatum().isValid() && event.getDatum().getZeitstempel() > this.startZeitPrognose) {
            this.prognoseEmpfangen = true;
            object = this.prognoseLock;
            synchronized (object) {
                this.prognoseLock.notify();
            }
        }
        boolean bl = this.datenAngemeldet = !(this.modellBaustelle.getBaustellenEigenschaften().getDatum() == null || !((PdBaustellenEigenschaften.Daten)this.modellBaustelle.getBaustellenEigenschaften().getDatum()).isValid() && ((PdBaustellenEigenschaften.Daten)this.modellBaustelle.getBaustellenEigenschaften().getDatum()).getDatenStatus() != Datum.Status.KEINE_DATEN || this.modellBaustelle.getBaustellenVerantwortlicher().getDatum() == null || !((PdBaustellenVerantwortlicher.Daten)this.modellBaustelle.getBaustellenVerantwortlicher().getDatum()).isValid() && ((PdBaustellenVerantwortlicher.Daten)this.modellBaustelle.getBaustellenVerantwortlicher().getDatum()).getDatenStatus() != Datum.Status.KEINE_DATEN || this.modellBaustelle.getSituationsEigenschaften().getDatum() == null || !((PdSituationsEigenschaften.Daten)this.modellBaustelle.getSituationsEigenschaften().getDatum()).isValid() && ((PdSituationsEigenschaften.Daten)this.modellBaustelle.getSituationsEigenschaften().getDatum()).getDatenStatus() != Datum.Status.KEINE_DATEN);
        if (this.datenAngemeldet) {
            object = this.anmeldungsLock;
            synchronized (object) {
                this.anmeldungsLock.notify();
            }
        }
    }

    private void erzeugeEreignis() throws BisInterfaceException {
        Ereignis ereignis = BaustellenEreignisFactory.getInstance().anlegenEreignis(this);
        if (ereignis != null) {
            this.ereignisse.add(new BaustellenEreignis(this.zustandBaustelle, ereignis));
        }
    }

    public BaustellenVerantwortlicherInterface getBaustellenVerantwortlichen() {
        return new BaustellenVerantwortlicher(this.baustellenVerantwortlicherModell.getFirma(), this.baustellenVerantwortlicherModell.getNameBaustellenVerantwortlicher(), this.baustellenVerantwortlicherModell.getTelefonBaustellenVerantwortlicher(), this.baustellenVerantwortlicherModell.getTelefonFirma(), this.baustellenVerantwortlicherModell.getTelefonMobilBaustellenVerantwortlicher());
    }

    public BisInterface.BaustellenZustand getBaustellenZustand() {
        return this.zustandBaustelle;
    }

    public long getDauer() {
        return this.baustellenSituationModell.getDauer();
    }

    public BaustellenStatus getDavBaustellenStatus(BisInterface.BaustellenZustand bisZustand) throws BisInterfaceException {
        if (bisZustand == BisInterface.BaustellenZustand.ENTWORFEN) {
            return BaustellenStatus.ENTWORFEN;
        }
        if (bisZustand == BisInterface.BaustellenZustand.GUELTIG) {
            return BaustellenStatus.GUELTIG;
        }
        if (bisZustand == BisInterface.BaustellenZustand.GEPLANT) {
            return BaustellenStatus.GEPLANT;
        }
        if (bisZustand == BisInterface.BaustellenZustand.STORNIERT) {
            return BaustellenStatus.STORNIERT;
        }
        throw new BisInterfaceException("Der Baustellenzustand '" + (Object)((Object)bisZustand) + "' kann nicht auf einen DAV-Zustand abgebildet werden");
    }

    public SystemObject getDavObjekt() {
        return this.davObjekt;
    }

    public int getEngpassKapazitaet() {
        return (int)this.baustellenEigenschaftenModell.getRestKapazitaet();
    }

    public long getId() {
        return this.davObjekt.getId();
    }

    public String getInfo() {
        return this.infoTextBaustelle;
    }

    public long getLaenge() {
        return this.laengeBaustelle;
    }

    public de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Baustelle getModellBaustelle() {
        return this.modellBaustelle;
    }

    public String getName() {
        return this.davObjekt.getName();
    }

    public OrtsReferenzStrassenSegmentUndOffsetInterface getOrtsReferenzStrassenSegmentUndOffset() {
        return this.ortsReferenzBaustelle;
    }

    public String getPid() {
        return this.davObjekt.getPid();
    }

    public long getStartZeitpunkt() {
        return this.baustellenSituationModell.getStartZeit();
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return false;
    }

    public boolean istMengeAngemeldet() {
        return this.mengeAngemeldet;
    }

    public void loeschen() throws BisInterfaceException {
        try {
            this.davObjekt.invalidate();
            this.zustandBaustelle = BisInterface.BaustellenZustand.STORNIERT;
            BaustellenEreignisFactory.getInstance().anlegenEreignis(this);
        }
        catch (ConfigurationChangeException e) {
            throw new BisInterfaceException(e.getMessage());
        }
    }

    public void publiziereDAV() throws DatensendeException, BisInterfaceException {
        this.publiziereDAVBaustelle();
        this.publiziereDAVSituation();
        this.publiziereDAVBaustellenVerantwortlicher();
    }

    private void publiziereDAVBaustelle() throws DatensendeException, BisInterfaceException {
        this.modellBaustelle.getBaustellenEigenschaften().sendeDaten((Datum)this.baustellenEigenschaftenModell);
        this.erzeugeEreignis();
    }

    private void publiziereDAVBaustellenVerantwortlicher() throws DatensendeException {
        this.modellBaustelle.getBaustellenVerantwortlicher().sendeDaten((Datum)this.baustellenVerantwortlicherModell);
    }

    private void publiziereDAVObjektDaten() throws ConfigurationChangeException {
        this.dav = ObjektFactory.getInstanz().getVerbindung();
        AttributeGroup atg = this.dav.getDataModel().getAttributeGroup("atg.info");
        Data data = this.dav.createData(atg);
        data.getTextValue("kurzinfo").setText(this.infoTextBaustelle);
        data.getTextValue("beschreibung").setText(this.infoTextBaustelle);
        this.davObjekt.setConfigurationData(atg, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publiziereDAVSituation() throws DatensendeException {
        this.modellBaustelle.getSituationsEigenschaften().sendeDaten((Datum)this.baustellenSituationModell);
        Object object = this.anmeldungsLock;
        synchronized (object) {
            try {
                this.anmeldungsLock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void setBaustellenZustand(BisInterface.BaustellenZustand neuerZustand) {
        if (this.zustandBaustelle == neuerZustand) {
            return;
        }
        if ((this.zustandBaustelle == BisInterface.BaustellenZustand.GUELTIG || neuerZustand == BisInterface.BaustellenZustand.GUELTIG) && this.getStartZeitpunkt() > System.currentTimeMillis() && this.getStartZeitpunkt() < System.currentTimeMillis() + ISISParameter.getInstance().warnZeitraum) {
            SimpleDateFormat formatter = new SimpleDateFormat();
            String nachricht = "Die Baustelle " + this.getName() + " wird am " + formatter.format(this.getStartZeitpunkt()) + " " + (Object)((Object)neuerZustand);
            MessageSender.getInstance().sendMessage(MessageType.APPLICATION_DOMAIN, MessageGrade.INFORMATION, nachricht);
        }
        this.zustandBaustelle = neuerZustand;
    }

    public void setMengeAngemeldet(boolean angemeldet) {
        this.mengeAngemeldet = angemeldet;
    }

    private void setzeBaustellenVerantwortlicherModell(BaustellenVerantwortlicherInterface verantwortlicher) {
        this.baustellenVerantwortlicherModell.setFirma(verantwortlicher.getFirma());
        this.baustellenVerantwortlicherModell.setNameBaustellenVerantwortlicher(verantwortlicher.getNameBaustellenVerantwortlicher());
        this.baustellenVerantwortlicherModell.setTelefonBaustellenVerantwortlicher(verantwortlicher.getTelefonBaustellenVerantwortlicher());
        this.baustellenVerantwortlicherModell.setTelefonFirma(verantwortlicher.getTelefonFirma());
        this.baustellenVerantwortlicherModell.setTelefonMobilBaustellenVerantwortlicher(verantwortlicher.getTelefonMobilBaustellenVerantwortlicher());
    }

    private void setzeOrtsreferenz() throws BisInterfaceException {
        this.baustellenSituationModell.setStartOffset(this.ortsReferenzBaustelle.getStartOffset());
        Object segment = ((OrtsReferenzStrassenSegmentUndOffset)this.ortsReferenzBaustelle).getModelSegment();
        LinkedList<StrassenSegment> segmente = new LinkedList<StrassenSegment>();
        if ((float)this.ortsReferenzBaustelle.getStartOffset() > segment.getLaenge()) {
            throw new BisInterfaceException("Der Offset auf dem Stra\u00dfensegment ist gr\u00f6\u00dfer als seine L\u00e4nge");
        }
        segmente.add((StrassenSegment)segment);
        long restlaenge = (long)((float)this.laengeBaustelle - (segment.getLaenge() - (float)this.ortsReferenzBaustelle.getStartOffset()));
        this.baustellenSituationModell.setEndOffset(this.ortsReferenzBaustelle.getStartOffset() + this.laengeBaustelle);
        while (segment != null && restlaenge > 0L) {
            StrassenKnoten knoten;
            if ((segment = segment instanceof InneresStrassenSegment ? ((InneresStrassenSegment)segment).getNachSegment() : ((knoten = ((AeusseresStrassenSegment)segment).getNachKnoten()) != null ? knoten.getInnereVerbindungDanach((AeusseresStrassenSegment)segment) : null)) == null) continue;
            segmente.add((StrassenSegment)segment);
            if ((restlaenge = (long)((float)restlaenge - segment.getLaenge())) > 0L) continue;
            this.baustellenSituationModell.setEndOffset((long)(segment.getLaenge() + (float)restlaenge));
        }
        if (restlaenge > 0L) {
            this.baustellenSituationModell.setEndOffset((long)((StrassenSegment)segmente.getLast()).getLaenge());
            this.laengeBaustelle -= restlaenge;
        }
        this.baustellenSituationModell.setSegmente(segmente);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaustellenPrognoseInterface startePrognose(String veranlasser, String ursache) throws BisInterfaceException {
        try {
            OdBaustellenSimulation antwort = (OdBaustellenSimulation)this.modellBaustelle.getOnlineDatensatz(OdBaustellenSimulation.class);
            antwort.abrufenDatum(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt());
            antwort.addUpdateListener(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt(), (DatensatzUpdateListener)this);
            this.startZeitPrognose = antwort.getDatum(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt()) == null ? 0L : ((OdBaustellenSimulation.Daten)antwort.getDatum(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt())).getZeitstempel();
            this.prognoseEmpfangen = false;
            this.modellBaustelle.simuliereBaustelle(veranlasser, ursache);
            Object object = this.prognoseLock;
            synchronized (object) {
                try {
                    this.prognoseLock.wait(100000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!this.prognoseEmpfangen) {
                throw new BisInterfaceException("Die Prognose konnte nicht erfolgreich ausgef\u00fchrt werden");
            }
            return new BaustellenPrognose((OdBaustellenSimulation.Daten)antwort.getDatum(OdBaustellenSimulation.Aspekte.PrognoseNormal.getAspekt()));
        }
        catch (AnmeldeException e) {
            e.printStackTrace();
        }
        catch (DatensendeException e) {
            e.printStackTrace();
        }
        return null;
    }
}

