/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis.impl;

import com.bitctrl.util.Interval;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BisInterface;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.impl.Baustelle;
import de.bsvrz.kex.isis.isis.impl.ISISParameter;
import de.bsvrz.sys.funclib.bitctrl.kalender.Ereigniskalender;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.Ereignis;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.EreignisTyp;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;

public final class BaustellenEreignisFactory {
    private static BaustellenEreignisFactory singleton;
    public static final String PID_BAUSTELLENEREIGNIS = "ereignisTyp.Baustelle";
    protected MessageSender nachrichtenSender = null;
    private EreignisTyp ereignisTyp = null;

    public static BaustellenEreignisFactory getInstance() {
        if (singleton == null) {
            singleton = new BaustellenEreignisFactory();
        }
        return singleton;
    }

    private BaustellenEreignisFactory() {
        SystemObject etdav = ObjektFactory.getInstanz().getVerbindung().getDataModel().getObject(PID_BAUSTELLENEREIGNIS);
        this.ereignisTyp = etdav != null ? (EreignisTyp)ObjektFactory.getInstanz().getModellobjekt(etdav) : null;
    }

    public Ereignis anlegenEreignis(Baustelle baustelle) throws BisInterfaceException {
        Ereignis ereignis = null;
        if (this.ereignisTyp == null) {
            throw new BisInterfaceException("Der EreignisTyp 'ereignisTyp.Baustelle' existiert nicht im Datenkatalog!");
        }
        if (!this.istEreignis(baustelle.getBaustellenZustand())) {
            return null;
        }
        try {
            String pid = this.bildePIDEreignis(baustelle);
            String name = this.bildeNameEreignis(baustelle);
            String beschreibung = this.bildeBeschreibungEreignis(baustelle);
            String quelle = "BIS";
            Interval intervall = new Interval(baustelle.getStartZeitpunkt(), baustelle.getStartZeitpunkt() + baustelle.getDauer());
            ereignis = Ereigniskalender.getInstanz().anlegenEreignis(pid, name, beschreibung, this.ereignisTyp, intervall, quelle);
        }
        catch (ConfigurationChangeException e) {
            throw new BisInterfaceException("Das Ereignis konnte nicht angelegt werden: " + e.getMessage());
        }
        catch (AnmeldeException e) {
            throw new BisInterfaceException("Das Ereignis konnte nicht angelegt werden: " + e.getMessage());
        }
        catch (DatensendeException e) {
            throw new BisInterfaceException("Das Ereignis konnte nicht angelegt werden: " + e.getMessage());
        }
        return ereignis;
    }

    private String bildeBeschreibungEreignis(Baustelle baustelle) throws BisInterfaceException {
        String statustext = baustelle.getDavBaustellenStatus(baustelle.getBaustellenZustand()).getName();
        return "Die Baustelle " + baustelle.getName() + " wurde in den Zustand " + statustext + " \u00fcberf\u00fchrt";
    }

    private String bildeNameEreignis(Baustelle baustelle) throws BisInterfaceException {
        return baustelle.getName() + " " + baustelle.getDavBaustellenStatus(baustelle.getBaustellenZustand()).getName();
    }

    private String bildePIDEreignis(Baustelle baustelle) throws BisInterfaceException {
        return "ereignis." + baustelle.getDavBaustellenStatus(baustelle.getBaustellenZustand()).getName() + "." + baustelle.getPid() + "." + System.currentTimeMillis();
    }

    public boolean istEreignis(BisInterface.BaustellenZustand zustand) {
        if (zustand == BisInterface.BaustellenZustand.ENTWORFEN) {
            return ISISParameter.getInstance().ereignisBeiEntworfen;
        }
        if (zustand == BisInterface.BaustellenZustand.GUELTIG) {
            return ISISParameter.getInstance().ereignisBeiGueltig;
        }
        if (zustand == BisInterface.BaustellenZustand.GEPLANT) {
            return ISISParameter.getInstance().ereignisBeiGeplant;
        }
        if (zustand == BisInterface.BaustellenZustand.STORNIERT) {
            return ISISParameter.getInstance().ereignisBeiStorniert;
        }
        return false;
    }
}

