/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.impl.AbstractBIS;
import de.bsvrz.sys.funclib.bitctrl.kalender.Ereigniskalender;
import de.bsvrz.sys.funclib.bitctrl.modell.AnmeldeException;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.kalender.objekte.EreignisTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.objekte.AutarkeOrganisationsEinheit;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class EreignisTypBaustelleAnlegen
extends AbstractBIS {
    private final String propertiesDatei = "isis.properties";
    private final int baustellenEreignisPrioritaet = 210;

    public static void main(String[] args) {
        EreignisTypBaustelleAnlegen el = new EreignisTypBaustelleAnlegen();
        el.typAnlegen();
        System.exit(0);
    }

    private ClientDavInterface connect(String davHost, String davUsername, String davPassword) throws BisInterfaceException {
        ClientDavConnection dav = null;
        ArgumentList argList = new ArgumentList(new String[]{"-datenverteiler=" + davHost});
        try {
            ClientDavParameters cdp = new ClientDavParameters(argList);
            cdp.setApplicationName("BIS");
            dav = new ClientDavConnection(cdp);
            dav.connect();
            dav.login(davUsername, davPassword);
        }
        catch (Exception e) {
            throw new BisInterfaceException(e.getMessage());
        }
        return dav;
    }

    private void typAnlegen() {
        try {
            File propfile = new File("isis.properties");
            Properties properties = new Properties();
            properties.load(new FileInputStream(propfile));
            ClientDavConnection dav = (ClientDavConnection)this.connect(properties.getProperty("Datenverteiler"), properties.getProperty("Benutzer"), properties.getProperty("Passwort"));
            DataModel config = dav.getDataModel();
            SystemObject kv = config.getObject(properties.getProperty("Konfigurationsverantwortlicher"));
            if (kv == null) {
                throw new BisInterfaceException("Der Konfigurationsverantwortliche '" + properties.getProperty("Konfigurationsverantwortlicher") + "' kann nicht initialisiert werden");
            }
            if (!kv.getType().getPid().equals("typ.isis")) {
                throw new BisInterfaceException("Der Konfigurationsverantwortliche '" + properties.getProperty("Konfigurationsverantwortlicher") + "' ist nicht vom Typ 'typ.isis'!");
            }
            ObjektFactory.getInstanz().setVerbindung((ClientDavInterface)dav);
            ObjektFactory.getInstanz().registerStandardFactories();
            AutarkeOrganisationsEinheit isisAoe = (AutarkeOrganisationsEinheit)ObjektFactory.getInstanz().getModellobjekt(kv);
            if (isisAoe == null) {
                throw new BisInterfaceException("Die AutarkeOrganisationsEinheit kann nicht initialisiert werden!");
            }
            SystemObject etdav = config.getObject("ereignisTyp.Baustelle");
            if (etdav == null) {
                System.out.println("Der EreignisTyp 'ereignisTyp.Baustelle' wird angelegt.");
                EreignisTyp ereignisTyp = Ereigniskalender.getInstanz().anlegenEreignisTyp("ereignisTyp.Baustelle", "Baustelle", 210);
                if (ereignisTyp == null) {
                    throw new BisInterfaceException("Der Ereignistyp kann nicht angelegt werden!");
                }
            } else {
                System.out.println("Der EreignisTyp ereignisTyp.Baustelle existiert bereits.");
            }
        }
        catch (BisInterfaceException e) {
            System.err.println(e.getMessage());
        }
        catch (FileNotFoundException e) {
            System.err.println("Die Datei 'isis.properties' konnte nicht ge\u00f6ffnet werden.");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (ConfigurationChangeException e) {
            System.err.println(e.getMessage());
        }
        catch (DatensendeException e) {
            e.printStackTrace();
        }
        catch (AnmeldeException e) {
            e.printStackTrace();
        }
    }
}

