/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis.impl;

import com.bitctrl.util.Interval;
import de.bsvrz.iav.gllib.gllib.Ganglinie;
import de.bsvrz.iav.gllib.gllib.dav.GanglinieMQ;
import de.bsvrz.kex.isis.isis.GanglinienInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ganglinien
implements GanglinienInterface {
    private static final long INTERVALLBREITE = 3600000L;
    private final GanglinieMQ prognoseganglinie;

    public Ganglinien(GanglinieMQ mqganglinie) {
        this.prognoseganglinie = mqganglinie;
    }

    private int[] erzeugeBISStuetzstellen(Ganglinie<Double> ganglinie) {
        Interval aintervall = this.prognoseganglinie.getIntervall();
        int anz = (int)(aintervall.getLength() / 3600000L);
        int[] bisstuetzstellen = new int[anz];
        for (int i = 0; i < anz; ++i) {
            Interval bintervall = new Interval(aintervall.getStart() + (long)i * 3600000L, aintervall.getStart() + (long)(i + 1) * 3600000L);
            bisstuetzstellen[i] = ganglinie.isValid(bintervall) ? (int)(ganglinie.getApproximation().integral(bintervall) / 3600000.0) : -1;
        }
        return bisstuetzstellen;
    }

    @Override
    public long getDatum() {
        return this.prognoseganglinie.getIntervall().getStart();
    }

    @Override
    public int[] getQKfz() {
        return this.erzeugeBISStuetzstellen((Ganglinie<Double>)this.prognoseganglinie.getGanglinieQKfz());
    }

    @Override
    public int[] getQLkw() {
        return this.erzeugeBISStuetzstellen((Ganglinie<Double>)this.prognoseganglinie.getGanglinieQLkw());
    }

    @Override
    public int[] getQPkw() {
        return this.erzeugeBISStuetzstellen((Ganglinie<Double>)this.prognoseganglinie.getGanglinieQPkw());
    }

    @Override
    public int[] getVKfz() {
        return this.erzeugeBISStuetzstellen((Ganglinie<Double>)this.prognoseganglinie.getGanglinieVKfz());
    }

    @Override
    public int[] getVLkw() {
        return this.erzeugeBISStuetzstellen((Ganglinie<Double>)this.prognoseganglinie.getGanglinieVLkw());
    }

    @Override
    public int[] getVPkw() {
        return this.erzeugeBISStuetzstellen((Ganglinie<Double>)this.prognoseganglinie.getGanglinieVPkw());
    }
}

