/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis.impl;

import com.bitctrl.util.Interval;
import de.bsvrz.iav.gllib.gllib.dav.GanglinieMQ;
import de.bsvrz.iav.gllib.gllib.dav.Ganglinienprognose;
import de.bsvrz.iav.gllib.gllib.dav.GlProgAnfrage;
import de.bsvrz.iav.gllib.gllib.dav.GlProgAntwortEvent;
import de.bsvrz.iav.gllib.gllib.dav.GlProgAntwortListener;
import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.GanglinienInterface;
import de.bsvrz.kex.isis.isis.MessQuerschnittInterface;
import de.bsvrz.kex.isis.isis.impl.Ganglinien;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensendeException;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.MessQuerschnittAllgemein;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessQuerschnitt
implements MessQuerschnittInterface,
GlProgAntwortListener {
    MessQuerschnittAllgemein messQuerschnitt;
    private final Object progWait = new Object();
    private Collection<GanglinieMQ> mqganglinien = null;

    public MessQuerschnitt(MessQuerschnittAllgemein mq) {
        this.messQuerschnitt = mq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void antwortEingetroffen(GlProgAntwortEvent e) {
        this.mqganglinien = e.getGanglinien();
        Object object = this.progWait;
        synchronized (object) {
            this.progWait.notify();
        }
    }

    private List<Interval> bildeAbfrageIntervalle(long vonZeitpunkt, long bisZeitpunkt) {
        ArrayList<Interval> intervalle = new ArrayList<Interval>();
        GregorianCalendar calvon = new GregorianCalendar();
        calvon.setTimeInMillis(vonZeitpunkt);
        calvon.set(11, 0);
        calvon.set(12, 0);
        calvon.set(13, 0);
        calvon.set(14, 0);
        if (vonZeitpunkt != calvon.getTimeInMillis()) {
            calvon.add(5, 1);
        }
        GregorianCalendar calbis = new GregorianCalendar();
        calbis.setTimeInMillis(bisZeitpunkt);
        calbis.set(11, 24);
        calbis.set(12, 0);
        calbis.set(13, 0);
        calbis.set(14, 0);
        if (bisZeitpunkt != calbis.getTimeInMillis()) {
            calbis.add(5, -1);
        }
        if (calvon.getTimeInMillis() == 0L) {
            calvon.setTimeInMillis(1L);
        }
        if (calbis.getTimeInMillis() == 0L) {
            calbis.setTimeInMillis(1L);
        }
        for (long t = calvon.getTimeInMillis(); t < calbis.getTimeInMillis(); t += 86400000L) {
            intervalle.add(new Interval(t, t + 86400000L));
        }
        return intervalle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GanglinienInterface[] getGanglinien(long vonZeitpunkt, long bisZeitpunkt) throws BisInterfaceException {
        Object anfrage;
        this.mqganglinien = null;
        ArrayList<Ganglinien> ganglinien = new ArrayList<Ganglinien>();
        List<Interval> abfrageIntervalle = this.bildeAbfrageIntervalle(vonZeitpunkt, bisZeitpunkt);
        ArrayList<GlProgAnfrage> anfragen = new ArrayList<GlProgAnfrage>();
        for (Interval intervall : abfrageIntervalle) {
            anfrage = new GlProgAnfrage(this.messQuerschnitt, intervall, false);
            anfragen.add((GlProgAnfrage)anfrage);
        }
        String absender = "BIS-INTERFACE";
        Ganglinienprognose prog = Ganglinienprognose.getInstanz();
        prog.addAntwortListener((GlProgAntwortListener)this);
        try {
            prog.sendeAnfrage(absender, anfragen);
            anfrage = this.progWait;
            synchronized (anfrage) {
                this.progWait.wait(60000L);
            }
            if (this.mqganglinien != null) {
                for (GanglinieMQ mqganglinie : this.mqganglinien) {
                    if (!this.istGueltig(mqganglinie)) continue;
                    ganglinien.add(new Ganglinien(mqganglinie));
                }
            }
        }
        catch (DatensendeException e) {
            throw new BisInterfaceException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new BisInterfaceException("Timeout beim Warten auf die Antwort der Ganglinienprognose");
        }
        return ganglinien.toArray(new GanglinienInterface[ganglinien.size()]);
    }

    public MessQuerschnittAllgemein getMessQuerschnitt() {
        return this.messQuerschnitt;
    }

    @Override
    public String getName() {
        return this.messQuerschnitt.getName();
    }

    @Override
    public String getPid() {
        return this.messQuerschnitt.getPid();
    }

    private boolean istGueltig(GanglinieMQ mqganglinie) {
        return !mqganglinie.getGanglinieQKfz().getIntervalle().isEmpty();
    }
}

