/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.isis.isis.impl;

import de.bsvrz.kex.isis.isis.BisInterfaceException;
import de.bsvrz.kex.isis.isis.OrtsReferenzAsbStationierungInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrasseUndBetriebsKilometerInterface;
import de.bsvrz.kex.isis.isis.OrtsReferenzStrassenSegmentUndOffsetInterface;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrasseUndBetriebsKilometer;
import de.bsvrz.kex.isis.isis.impl.OrtsReferenzStrassenSegmentUndOffset;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.AsbStationierungOrtsReferenz;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.AsbStationierungOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzException;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.NetzReferenzen;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrasseUndBetriebsKilometerOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.netz.StrassenSegmentUndOffsetOrtsReferenzInterface;
import de.bsvrz.sys.funclib.bitctrl.modell.verkehr.objekte.Strasse;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrtsReferenzAsbStationierung
implements OrtsReferenzAsbStationierungInterface {
    private AsbStationierungOrtsReferenz modelReferenz;

    public OrtsReferenzAsbStationierung(String anfangsKnoten, String endKnoten, NetzInterface.ASBStationierungsRichtung richtung, long stationierung) {
        this.modelReferenz = new AsbStationierungOrtsReferenz(anfangsKnoten, endKnoten, richtung, stationierung);
    }

    public OrtsReferenzAsbStationierung(AsbStationierungOrtsReferenzInterface asbStationierungOrtsReferenzInterface) {
        this(asbStationierungOrtsReferenzInterface.getAnfangsKnoten(), asbStationierungOrtsReferenzInterface.getEndKnoten(), asbStationierungOrtsReferenzInterface.getAsbStationierungsRichtung(), asbStationierungOrtsReferenzInterface.getStationierung());
    }

    @Override
    public List<OrtsReferenzStrassenSegmentUndOffsetInterface> ermittleOrtsReferenzStrassenSegmentUndOffset() throws BisInterfaceException {
        try {
            ArrayList<OrtsReferenzStrassenSegmentUndOffsetInterface> ergebnis = new ArrayList<OrtsReferenzStrassenSegmentUndOffsetInterface>();
            for (StrassenSegmentUndOffsetOrtsReferenzInterface ref : NetzReferenzen.getInstanz().ermittleOrtsReferenzStrassenSegmentUndOffset((AsbStationierungOrtsReferenzInterface)this.modelReferenz)) {
                ergebnis.add(new OrtsReferenzStrassenSegmentUndOffset(ref));
            }
            return ergebnis;
        }
        catch (NetzReferenzException nre) {
            try {
                Strasse strasse = NetzReferenzen.getInstanz().findeStrasse(this.modelReferenz);
                if (strasse != null) {
                    String meldung = "Die " + this + " auf Stra\u00dfe '" + strasse + "' konnte nicht auf eine OrtsReferenzStrassenSegmentUndOffset abgebildet werden" + " (" + nre.getMessage() + ")";
                    MessageSender.getInstance().sendMessage(MessageType.APPLICATION_DOMAIN, MessageGrade.INFORMATION, meldung);
                }
            }
            catch (NetzReferenzException netzReferenzException) {
                // empty catch block
            }
            throw new BisInterfaceException(nre);
        }
    }

    @Override
    public List<OrtsReferenzStrasseUndBetriebsKilometerInterface> ermittleOrtsReferenzStrasseUndBetriebsKilometer() throws BisInterfaceException {
        try {
            ArrayList<OrtsReferenzStrasseUndBetriebsKilometerInterface> ergebnis = new ArrayList<OrtsReferenzStrasseUndBetriebsKilometerInterface>();
            for (StrasseUndBetriebsKilometerOrtsReferenzInterface ref : NetzReferenzen.getInstanz().ermittleOrtsReferenzStrasseUndBetriebsKilometer((AsbStationierungOrtsReferenzInterface)this.modelReferenz)) {
                ergebnis.add(new OrtsReferenzStrasseUndBetriebsKilometer(ref));
            }
            return ergebnis;
        }
        catch (NetzReferenzException nre) {
            throw new BisInterfaceException(nre);
        }
    }

    @Override
    public String getAnfangsKnoten() {
        return this.modelReferenz.getAnfangsKnoten();
    }

    @Override
    public NetzInterface.ASBStationierungsRichtung getAsbStationierungsRichtung() {
        return this.modelReferenz.getAsbStationierungsRichtung();
    }

    @Override
    public String getEndKnoten() {
        return this.modelReferenz.getEndKnoten();
    }

    @Override
    public long getStationierung() {
        return this.modelReferenz.getStationierung();
    }

    public String toString() {
        return "ASB-Ortsreferenz (Anfangsknoten: " + this.modelReferenz.getAnfangsKnoten() + ", Endknoten: " + this.modelReferenz.getEndKnoten() + ", Stationierung: " + this.modelReferenz.getStationierung() + ", Stationierungsrichtung: " + this.modelReferenz.getAsbStationierungsRichtung() + ")";
    }
}

